ORCA/M Asm65816 2.1.0

0001 A5BD                       title 'Misc Tools           GS ROM 3.0'
0002 A5BD              **********************************************************************
0003 A5BD              *
0004 A5BD              *	   Misc Tools
0005 A5BD              *
0006 A5BD              *
0007 A5BD              *	Copyright (C) 1985-1988
0008 A5BD              *	All Rights Reserved
0009 A5BD              *	Apple Computer, Inc.
0010 A5BD              *
0011 A5BD              *
0012 A5BD              * Change History
0013 A5BD              *
0014 A5BD              * Revision     Date      Description                    Who
0015 A5BD              * Alpha1.0     02-17-86  Initial ALPHA release          RBM
0016 A5BD              *              02-27-86  Implemented IDTAG MGR          RBM
0017 A5BD              *	     Corrected error codes
0018 A5BD              *	     Math Divide/0 error reporting
0019 A5BD              *	     Fixed MAINSIDE dispatcher
0020 A5BD              *              03-07-86  Build NEW miscellaneous tools  RBM
0021 A5BD              * Beta 1.0     03-26-86  Psuedo keyboard IRQ task.      RBM
0022 A5BD              * Beta 2.0     04-23-86  More parms for get address.    RBM
0023 A5BD              *              04-29-86  No calls to system death from  RBM
0024 A5BD              *	     mouse tools.  Added absolute
0025 A5BD              *	     device clamp support. The get
0026 A5BD              *	     address call has more parms.
0027 A5BD              * Rom  0.1     10-27-86  Fixed endcall in SetAbsClamps. RBM
0028 A5BD              *	     ID manager now reassigns tags.
0029 A5BD              *	     Fixed WrBram & RdBram so that
0030 A5BD              *	     buffer may be in any bank.
0031 A5BD              * Rom  0.1     10-29-86  Added SysBeep                  RBM
0032 A5BD              *
0033 A5BD              * For ROM 3.0
0034 A5BD              *
0035 A5BD              * 06 May 88	Joe Bo
0036 A5BD              *
0037 A5BD              * Implemented mouse hardware interfaces to mouse calling routines.
0038 A5BD              *
0039 A5BD              *
0040 A5BD              * 09 May 88	Joe Bo
0041 A5BD              *
0042 A5BD              * Added a new entry point for BASIC to initialize mouse.
0043 A5BD              *
0044 A5BD              *
0045 A5BD              * 26 Jul 88	Steven Glass
0046 A5BD              *
0047 A5BD              * Get and SetVector disable interrupts during access to the vectors.
0048 A5BD              *
0049 A5BD              * DelHeartbeat and ClearHeartbeat try and turn off vbl interrupts
0050 A5BD              * if it is safe to do so.
0051 A5BD              *
0052 A5BD              * 10 Sep 88	Steven Glass
0053 A5BD              *
0054 A5BD              * Entry in call table for BasicInit did not include -1.
0055 A5BD              *
0056 A5BD              * Added calls AddToQueue and DeleteFromQueue.
0057 A5BD              *
0058 A5BD              * 30 Sep 88	Joe Bo
0059 A5BD              *
0060 A5BD              * GetMouseClamp:  Saved and restored dbr around internal calls.
0061 A5BD              *
0062 A5BD              * 03 Sep 88	Steven Glass
0063 A5BD              *
0064 A5BD              * GetMouseClamp:  Changed equates to account for saving and restoring dbr.
0065 A5BD              *
0066 A5BD              * 17 Oct 88	Steven Glass
0067 A5BD              *
0068 A5BD              * The bParam table entry for slot one (address $21) is not offset
0069 A5BD              * to $58.  This is to make appletalk work in the new configuration.
0070 A5BD              *
0071 A5BD              * 17 Nov 88	Konstantin Othmer
0072 A5BD              *
0073 A5BD              * Added slot arbiter stuff to fwentry.  A call to _FWEntry (which really goes
0074 A5BD              *  through MonEntry) will set the slots to the default configuration if the call
0075 A5BD              *  is in the Cn00 space.  Using fwentry directly (which only the text tools do)
0076 A5BD              *  will not change the slot configuration.
0077 A5BD              *
0078 A5BD              * 08 Dec 88	Steven Glass
0079 A5BD              *
0080 A5BD              * Change to DeathMgr in way it checks for NIL ptr.
0081 A5BD              *
0082 A5BD              * 04 Jan 89	Mensch
0083 A5BD              * 
0084 A5BD              * Added ReadMouse2 Call. and changed ReadMouse call, The new read mouse is
0085 A5BD              * identical to old read mouse read mouse, except that
0086 A5BD              * it will allow journaling to occur. ReadMouse2 is the old readmouse call
0087 A5BD              * should only be used by the event manager. Everyone else should stick with
0088 A5BD              * the old readmouse
0089 A5BD              *
0090 A5BD              * 12 Jan 89	Mensch
0091 A5BD              * Fix bug introduced on jan 4 that caused infinite loop in readmouse.
0092 A5BD              *
0093 A5BD              * 17 Jan 89	Mensch
0094 A5BD              * Added GetROMResource and ReleaseROMResource to Misc Tools
0095 A5BD              *
0096 A5BD              * 26-Sep-90	Dave Lyons
0097 A5BD              *
0098 A5BD              * Changed _SysDeath to _SysFailMgr so it builds.
0099 A5BD              *
0100 A5BD              * 4-Mar-91	Dave Lyons
0101 A5BD              *
0102 A5BD              * Adding new call $3B03 StringToText to translate 8-bit "Shaston 8" style
0103 A5BD              * text into the nearest equivalent Text-screen text (allowing for mousetext,
0104 A5BD              * etc).  (Code is really in the ROM 3 patch file.)
0105 A5BD              *
0106 A5BD              **********************************************************************
0107 A5BD
0108 A5BD
0109 A5BD                       include 'all.macros' 
0110 A5BD                       include '::sys.equs.asm' 
0111 A5BD
0112 A5BD              ;-----------------------------------------------------------
0113 A5BD              ;
0114 A5BD              ; Global Version Number
0115 A5BD              ;
0116 A5BD              Version  equ   $0300                    ; version number
0117 A5BD
0118 A5BD              ;-----------------------------------------------------------
0119 A5BD              ;
0120 A5BD              ; from e16.misctool
0121 A5BD              ;
0122 A5BD              vblDisable   EQU   $0003                ; Interrupt Ref Number - Parameter to IntSource
0123 A5BD
0124 A5BD              ;-----------------------------------------------------------
0125 A5BD              ;
0126 A5BD              ; Slot Arbiter Entry point
0127 A5BD              ;
0128 A5BD              Slot_arbiter equ   $E10208
0129 A5BD
0130 A5BD
0131 A5BD              ;-----------------------------------------------------------
0132 A5BD              ;
0133 A5BD              ; Definition of Record used by Queue Routines
0134 A5BD              ;
0135 A5BD                       DSect 0 
0136 A5BD              HeaderLink LONG 
0137 A5BD              HeaderReserved WORD 
0138 A5BD              HeaderSignature WORD 
0139 A5BD              HeaderRoutine LONG 
0140 A5BD
0141 A5BD              QueueSignature equ   $A55A
0142 A5BD
0143 A5BD              ;-----------------------------------------------------------
0144 A5BD              ;
0145 A5BD              ; Misc tools Errors
0146 A5BD              ;
0147 A5BD              BadInputErr equ   $0301                 ; bad input
0148 A5BD              noDevParamErr equ   $0302               ; no device for input paramter
0149 A5BD              taskInstlErr equ   $0303                ; specified task already in queue
0150 A5BD              noSigTaskErr equ   $0304                ; no signature detected in task header
0151 A5BD              queueDmgdErr equ   $0305                ; damaged heartbeat queue detected (fatal)
0152 A5BD              taskNtFdErr equ   $0306                 ; specified task not in queue
0153 A5BD              firmTaskErr equ   $0307                 ; Unsuccessful fw task
0154 A5BD              hbQueueBadErr equ   $0308               ; damaged heartbeat queue detected (fatal)
0155 A5BD              unCnctdDevErr equ   $0309               ; dispatch to unconnect device
0156 A5BD              idTagNtAvlErr equ   $030B               ; no id tag available
0157 A5BD
0158 A5BD              RecordNotFound equ   $0380
0159 A5BD              BadSignature equ   $0381
0160 A5BD
0161 A5BD
0162 A5BD              ;-----------------------------------------------
0163 A5BD              ;
0164 A5BD              ;   Imported addresses
0165 A5BD              ;
0166 A5BD              ;-----------------------------------------------
0167 A5BD
0168 A5BD                       IMPORT EndCall0 
0169 A5BD                       IMPORT EndCall2 
0170 A5BD                       IMPORT EndCall4 
0171 A5BD                       IMPORT EndCall8 
0172 A5BD                       IMPORT ErrOut2 
0173 A5BD                       IMPORT ErrOut4 
0174 A5BD                       IMPORT FFEntry 
0175 A5BD                       IMPORT LastTag 
0176 A5BD                       IMPORT LongDiv 
0177 A5BD                       IMPORT Multiply 
0178 A5BD                       IMPORT SpecialNewHandle 
0179 A5BD                       IMPORT UDivide 
0180 A5BD                       IMPORT oEndCall0 
0181 A5BD                       IMPORT oEndCall2 
0182 A5BD                       IMPORT oEndCall4 
0183 A5BD                       IMPORT oEndCall6 
0184 A5BD                       IMPORT oEndCall8 
0185 A5BD                       IMPORT oErrOut0 
0186 A5BD                       IMPORT oErrOut2 
0187 A5BD                       IMPORT oErrOut4 
0188 A5BD                       IMPORT oErrOut6 
0189 A5BD                       IMPORT oErrOut8 
0190 A5BD
0191 A5BD
0192 A5BD
0193 A5BD
0194 A5BD              ;-----------------------------------------------
0195 A5BD              ;
0196 A5BD              ;   Forward addresses and entries
0197 A5BD              ;
0198 A5BD              ;-----------------------------------------------
0199 A5BD
0200 A5BD                       ENTRY ClearGlue 
0201 A5BD                       ENTRY ClrHeart 
0202 A5BD                       ENTRY DelHeart 
0203 A5BD                       ENTRY DeleteID 
0204 A5BD                       ENTRY GetAbsClamp 
0205 A5BD                       ENTRY GetAddr 
0206 A5BD                       ENTRY GetIRQenbl 
0207 A5BD                       ENTRY GetNewID 
0208 A5BD                       ENTRY GetTick 
0209 A5BD                       ENTRY GetVector 
0210 A5BD                       ENTRY HexToAscii 
0211 A5BD                       ENTRY HomeGlue 
0212 A5BD                       ENTRY ISIT44 
0213 A5BD                       ENTRY InitGlue 
0214 A5BD                       ENTRY IntSrc 
0215 A5BD                       ENTRY Irq_Heart 
0216 A5BD                       ENTRY LOOKAT4 
0217 A5BD                       ENTRY MTCallTable 
0218 A5BD                       ENTRY MTDeref 
0219 A5BD                       ENTRY MTInit 
0220 A5BD                       ENTRY MTRes7 
0221 A5BD                       ENTRY MTRes8 
0222 A5BD                       ENTRY MTReset 
0223 A5BD                       ENTRY MTShutDown 
0224 A5BD                       ENTRY MTStartup 
0225 A5BD                       ENTRY MTStatus 
0226 A5BD                       ENTRY MTVer 
0227 A5BD                       ENTRY MonEntry 
0228 A5BD                       ENTRY Munger 
0229 A5BD                       ENTRY PackBytes 
0230 A5BD                       ENTRY RdATime 
0231 A5BD                       ENTRY ReadBParam 
0232 A5BD                       ENTRY ReadBRam 
0233 A5BD                       ENTRY ReadMouseJ 
0234 A5BD                       ENTRY RdTimeHex 
0235 A5BD                       ENTRY SetAbsClamp 
0236 A5BD                       ENTRY SetHeart 
0237 A5BD                       ENTRY SetVector 
0238 A5BD                       ENTRY StatusID 
0239 A5BD                       ENTRY SysBeep 
0240 A5BD                       ENTRY SysDeathMgr 
0241 A5BD                       ENTRY TClmpMou 
0242 A5BD                       ENTRY TGetClamp 
0243 A5BD                       ENTRY TPosMou 
0244 A5BD                       ENTRY TRdMou 
0245 A5BD                       ENTRY TServMou 
0246 A5BD                       ENTRY TSetMou 
0247 A5BD                       ENTRY ToLDivide 
0248 A5BD                       ENTRY ToMainSide 
0249 A5BD                       ENTRY ToMult 
0250 A5BD                       ENTRY ToUDivide 
0251 A5BD                       ENTRY UnPackBytes 
0252 A5BD                       ENTRY WriteBParam 
0253 A5BD                       ENTRY WriteBRam 
0254 A5BD                       ENTRY WrTimeHex 
0255 A5BD
0256 A5BD
0257 A5BD                       ENTRY GetMData 
0258 A5BD                       ENTRY setdbtoe1 
0259 A5BD                       ENTRY MYBasicInit 
0260 A5BD                       ENTRY InitFlag 
0261 A5BD
0262 A5BD                       import AddToQueue 
0263 A5BD                       import DeleteFromQueue 
0264 A5BD                       Import ReleaseROMResource 
0265 A5BD                       Import GetROMResource 
0266 A5BD
0267 A5BD                       title 'Call Table'
0268 A5BD              ****************************************************************
0269 A5BD              *
0270 A5BD              MTCallTable PROC EXPORT 
0271 A5BD              *
0272 A5BD              * Call table for the tool
0273 A5BD              *
0274 A5BD              *
0275 A5BD              * Inputs:
0276 A5BD              *	none
0277 A5BD              *
0278 A5BD              * Outputs:
0279 A5BD              *	none
0280 A5BD              *
0281 A5BD              * External Refs:
0282 A5BD                       import SetInterruptState 
0283 A5BD                       import GetInterruptState 
0284 A5BD                       import GetIntStateRecSize 
0285 A5BD                       import GetCodeResConverter 
0286 A5BD                       import ConvSeconds 
0287 A5BD                       import SysBeep2 
0288 A5BD                       import VersionString 
0289 A5BD                       import WaitUntil 
0290 A5BD                       import StringToText 
0291 A5BD
0292 A5BD              *
0293 A5BD              * Entry Points:
0294 A5BD              *	none
0295 A5BD              *
0296 A5BD                       longa on                       ; mode
0297 A5BD                       longi on
0298 A5BD              *
0299 A5BD              ****************************************************************
0300 A5BD
0301 A5BD
0302 A5BD              Here      
0303 A5BD 37 00 00 00           DC L:(TheEnd-Here)/4           ; num calls +1
0304 A5C1 98 A6 FE 00           DC L:MTInit-1                  	; PowerUp Initialization
0305 A5C5 E6 A6 FE 00           DC L:MTStartup-1               	; application startup
0306 A5C9 E6 A6 FE 00           DC L:MTShutDown-1              	; application shutdown
0307 A5CD 04 A7 FE 00           DC L:MTVer-1                   	; version number
0308 A5D1 E9 A6 FE 00           DC L:MTReset-1                 	; Misc. Tools Reset
0309 A5D5 0C A7 FE 00           DC L:MTStatus-1                	; Reserved
0310 A5D9 E6 A6 FE 00           DC L:MTRes7-1                  	; Reserved
0311 A5DD E6 A6 FE 00           DC L:MTRes8-1                  	; Reserved
0312 A5E1 5A A7 FE 00           DC L:WriteBRam-1               	; Write battery ram
0313 A5E5 7E A7 FE 00           DC L:ReadBRam-1                	; Read battery ram
0314 A5E9 96 A7 FE 00           DC L:WriteBParam-1             	; Write battery ram parameter
0315 A5ED B7 A7 FE 00           DC L:ReadBParam-1              	; Read battery ram parameter
0316 A5F1 D1 A8 FE 00           DC L:RdTimeHex-1               	; read clock w/ hex format
0317 A5F5 83 AA FE 00           DC L:WrTimeHex-1               	; write clock w/ hex format
0318 A5F9 42 AC FE 00           DC L:RdATime-1                 	; read clock w/ ascii format
0319 A5FD 76 AD FE 00           DC L:SetVector-1               	; set interrupt vector
0320 A601 9C AD FE 00           DC L:GetVector-1               	; get interrupt vector
0321 A605 BF AD FE 00           DC L:SetHeart-1                	; insert procedure in Heartbeat chain
0322 A609 9F AE FE 00           DC L:DelHeart-1                	; delete procedure from heartbeat chai
0323 A60D 5F AF FE 00           DC L:ClrHeart-1                	; clear heartbeat chain
0324 A611 3B B0 FE 00           DC L:SysDeathMgr-1             	; system death manager
0325 A615 4A B0 FE 00           DC L:GetAddr-1                 	;  ???
0326 A619 AB B0 FE 00           DC L:ReadMouseJ-1              	; Read Mouse (Was TRdMou)
0327 A61D B5 B2 FE 00           DC L:InitGlue-1                	; initialize mouse
0328 A621 EC B2 FE 00           DC L:TSetMou-1                 	; set mouse mode
0329 A625 3D B3 FE 00           DC L:HomeGlue-1                	; home mouse position to min. clamp
0330 A629 67 B3 FE 00           DC L:ClearGlue-1               	; clear mouse position to 0
0331 A62D 88 B3 FE 00           DC L:TClmpMou-1                	; set both X and Y clamps
0332 A631 C2 B3 FE 00           DC L:TGetClamp-1               	; get both X and Y clamps
0333 A635 E1 B3 FE 00           DC L:TPosMou-1                 	; set mouse position
0334 A639 07 B4 FE 00           DC L:TServMou-1                	; service mouse interrupt
0335 A63D 15 B6 FE 00           DC L:GetNewID-1                	; get ID tag
0336 A641 C3 B6 FE 00           DC L:DeleteID-1                	; delete ID tag
0337 A645 1E B7 FE 00           DC L:StatusID-1                	; get ID tag status
0338 A649 63 B7 FE 00           DC L:IntSrc-1                  	; enable interrupt source
0339 A64D A6 B8 FE 00           DC L:MonEntry-1                	; Firmware entry points
0340 A651 94 B8 FE 00           DC L:GetTick-1                 	; get tick counter contents
0341 A655 F9 B8 FE 00           DC L:PackBytes-1               	; Pack bytes
0342 A659 61 BB FE 00           DC L:UnPackBytes-1             	; UnPack dem dere bytes
0343 A65D C5 BC FE 00           DC L:Munger-1                  	; This routine munges strings
0344 A661 C1 BE FE 00           DC L:GetIRQenbl-1              	; returns IRQ enble status
0345 A665 67 B4 FE 00           DC L:SetAbsClamp-1             	; set absolute device clamps
0346 A669 4C B4 FE 00           DC L:GetAbsClamp-1             	; get absolute device clamps
0347 A66D 00 BF FE 00           DC L:SysBeep-1                 	; system beep
0348 A671 82 B4 FE 00           DC L:MyBasicInit-1             	; mouse init for BASIC from $c4xx
0349 A675 F1 FC FE 00           DC L:AddToQueue-1              	; added 10 sep 88
0350 A679 3E FD FE 00           DC L:DeleteFromQueue-1         ; added 10 sep 88
0351 A67D
0352 A67D 53 FF FC 00           DC L:SetInterruptState-1       ; added 24 Nov 88
0353 A681 2E FF FC 00           DC L:GetInterruptState-1       ; added 24 Nov 88
0354 A685 78 FF FC 00           DC L:GetIntStateRecSize-1      ; added 24 Nov 88
0355 A689 F8 B0 FE 00           DC L:TRdMou-1                  	; added 03 jan 89 {$3303}
0356 A68D 52 FE FC 00           DC L:GetCodeResConverter-1     ; added 12 Jan 89 {$3403}
0357 A691 18 D8 FD 00           DC L:GetROMResource-1          ; Added 17 Jan 89 {$3503}
0358 A695 AC D8 FD 00           DC L:ReleaseROMResource-1      ; Added 17 Jan 89 {$3603}
0359 A699              TheEnd    
0360 A699
0361 A699                       ENDP 
0362 A699
0363 A699                       title 'Init Routines'
0364 A699              ****************************************************************
0365 A699              *
0366 A699              * BOOTINIT:     Clears heartbeat queue. Sets no slot flags.
0367 A699              *               Clears tick counter. Allocates IDtag memory.
0368 A699              * STARTUPINIT:  Does nothing
0369 A699              * SHUTDOWN:     Does nothing
0370 A699              * RESET:        Clears heartbeat queue. Sets no slot flags.
0371 A699              *
0372 A699              ****************************************************************
0373 A699              MTInit   PROC                           ; Tool Boot Initialization
0374 A699
0375 A699 8B                    phb                            ; save the dbr on stack
0376 A69A
0377 A69A A9 00 00              lda   #0                       ; Init HeartBeat chain
0378 A69D 8F D8 00 E1           sta   >HBptr
0379 A6A1 8F DA 00 E1           sta   >HBptr+2
0380 A6A5 8F DC 00 E1           sta   >TickCnt                 ; initialize tick counter
0381 A6A9 8F DE 00 E1           sta   >TickCnt+2
0382 A6AD E2 20                 sep   #$20                     ; 8 bit 'm'
0383 A6AF 8F D4 0F E1           sta   >KBDIRQFLAG              ; clear interrupt flag
0384 A6B3 3A                    dec   a                        ; assume no Slot I/O
0385 A6B4 8F CF 00 E1           sta   >SIOFlag
0386 A6B8 8F E0 00 E1           sta   >MouseSlot               ; assume no mouse either
0387 A6BC C2 20                 rep   #$20                     ; 16 bit 'm'
0388 A6BE
0389 A6BE
0390 A6BE
0391 A6BE A9 00 00              lda   #0                       ; size
0392 A6C1 A2 01 41              ldx   #$4101
0393 A6C4 A0 08 00              ldy   #$0008                   ; no special memory
0394 A6C7 20 3B 13              jsr   SpecialNewHandle
0395 A6CA 90 10                 bcc   MTInit0                  ; if got block
0396 A6CC F4 00 00              pea   $0000                    ; no message
0397 A6CF F4 00 00              pea   $0000
0398 A6D2 F4 25 00              pea   $0025                    ; cant allocate IDTAG queue
0399 A6D5 A2 03 15 22           _SysFailMgr                    ; SYSTEM DEATH
0400 A6DC
0401 A6DC              MTInit0                                 ; 
0402 A6DC 8A                    txa                            ; save handle
0403 A6DD 8F D0 0F E1           sta   >MThandle
0404 A6E1 98                    tya   
0405 A6E2 8F D2 0F E1           sta   >MThandle+2
0406 A6E6              SkipNewHandle  
0407 A6E6 AB                    plb                            ; restore data bank reg
0408 A6E7
0409 A6E7                       ENTRY MTStartup 
0410 A6E7              MTStartup                               ;       ; Tool Startup Initialization
0411 A6E7                       ENTRY MTShutdown 
0412 A6E7              MTShutdown                              ;       ; Tool Shut Down
0413 A6E7                       ENTRY MTRes7 
0414 A6E7              MTRes7                                  ;       ; Reserved function #7
0415 A6E7                       ENTRY MTRes8 
0416 A6E7              MTRes8                                  ;       ; Reserved function #8
0417 A6E7
0418 A6E7 4C DF FB              jmp   oEndCall0
0419 A6EA
0420 A6EA                       ENTRY MTReset 
0421 A6EA              MTReset                                 ; 
0422 A6EA A9 00 00              lda   #0                       ; clear HeartBeat queue
0423 A6ED 8F D8 00 E1           sta   >HBptr
0424 A6F1 8F DA 00 E1           sta   >HBptr+2
0425 A6F5 E2 20                 sep   #$20                     ; 8 bit 'm'
0426 A6F7 3A                    dec   a                        ; assume no Slot I/O
0427 A6F8 8F CF 00 E1           sta   >SIOFlag
0428 A6FC 8F E0 00 E1           sta   >MouseSlot               ; no mouse either
0429 A700 C2 20                 rep   #$20                     ; 16 bit 'm'
0430 A702 4C DF FB              jmp   oEndCall0
0431 A705
0432 A705                       ENDP 
0433 A705
0434 A705
0435 A705              ****************************************************************
0436 A705              *
0437 A705              * Return with miscellaneous tools version #
0438 A705              *
0439 A705              ****************************************************************
0440 A705              MTVer    PROC 
0441 A705
0442 A705              RTL1     equ   1
0443 A705              RTL2     equ   RTL1+3
0444 A705              Result   equ   RTL2+3
0445 A705
0446 A705
0447 A705 A9 00 03              lda   #version                 ; get MT version #
0448 A708 83 07                 sta   Result,s                 ; pass to caller
0449 A70A 4C DF FB              jmp   oEndCall0
0450 A70D
0451 A70D                       ENDP 
0452 A70D
0453 A70D              ****************************************************************
0454 A70D              *
0455 A70D              * Return with status that indicates the tool is active
0456 A70D              *
0457 A70D              ****************************************************************
0458 A70D              MTStatus PROC 
0459 A70D
0460 A70D              rtl1     equ   1
0461 A70D              rtl2     equ   rtl1+3
0462 A70D              ThisStatus equ   rtl2+3
0463 A70D
0464 A70D A9 FF FF              lda   #$FFFF                   ; status = tool active
0465 A710 83 07                 sta   ThisStatus,s
0466 A712 4C DF FB              jmp   oEndCall0
0467 A715
0468 A715                       ENDP 
0469 A715
0470 A715
0471 A715
0472 A715
0473 A715              ****************************************************************
0474 A715              *
0475 A715              * Dereference a Handle, and return with pointer in X and DBR.
0476 A715              *
0477 A715              * Inputs :  MThandle contains handle to IDTAG block
0478 A715              * Output :  DBR = Block addr (high), X=Block addr (low)
0479 A715              *
0480 A715              * NOTE   : this trashes A, X, Y and D
0481 A715              *
0482 A715              ****************************************************************
0483 A715              MTderef  PROC 
0484 A715
0485 A715 AF D0 0F E1           lda   >MThandle                ; get handle into X and A
0486 A719 AA                    tax   
0487 A71A AF D2 0F E1           lda   >MThandle+2
0488 A71E EB                    xba                            ; get bank into B
0489 A71F 48                    pha   
0490 A720 AB                    plb                            ; remove trash
0491 A721 AB                    plb                            ; set bank to bank of pointer
0492 A722 BD 00 00              lda   |0,x                     ; get pointer (low)
0493 A725 BC 02 00              ldy   |2,x                     ; get pointer (high)
0494 A728 AA                    tax   
0495 A729 98                    tya   
0496 A72A EB                    xba                            ; get bank into B
0497 A72B 48                    pha                            ; push bank + trash
0498 A72C AB                    plb                            ; remove trash
0499 A72D AB                    plb                            ; set bank = ptr (high)
0500 A72E 60                    rts   
0501 A72F
0502 A72F                       ENDP 
0503 A72F
0504 A72F
0505 A72F              ****************************************************************
0506 A72F              *
0507 A72F              MTHandleStuff PROC 
0508 A72F              *
0509 A72F              *
0510 A72F              * Sets or returns the size of the MT handle.
0511 A72F              *
0512 A72F              *
0513 A72F              * Inputs:
0514 A72F              *	none
0515 A72F              *
0516 A72F              * Outputs:
0517 A72F              *	a-reg  Size of MTHandle
0518 A72F              *
0519 A72F              * External Refs:
0520 A72F              *	none
0521 A72F              *
0522 A72F              * Entry Points:
0523 A72F                       ENTRY GetMTHandleSize 
0524 A72F                       ENTRY SetMTHandleSize 
0525 A72F              *
0526 A72F                       longa on                       ; mode
0527 A72F                       longi on
0528 A72F              *
0529 A72F              ****************************************************************
0530 A72F
0531 A72F              GetMTHandleSize  
0532 A72F 48                    pha   
0533 A730 48                    pha   
0534 A731 AF D2 0F E1           lda   >MThandle+2
0535 A735 48                    pha   
0536 A736 AF D0 0F E1           lda   >MThandle
0537 A73A 48                    pha   
0538 A73B A2 02 18 22           _GetHandleSize 
0539 A742 68                    pla   
0540 A743 FA                    plx   
0541 A744 60                    rts   
0542 A745
0543 A745              SetMTHandleSize  
0544 A745 F4 00 00              pea   0000
0545 A748 48                    pha   
0546 A749 AF D2 0F E1           lda   >MThandle+2
0547 A74D 48                    pha   
0548 A74E AF D0 0F E1           lda   >MThandle
0549 A752 48                    pha   
0550 A753 A2 02 19 22           _SetHandleSize 
0551 A75A 60                    rts   
0552 A75B
0553 A75B                       ENDP 
0554 A75B
0555 A75B
0556 A75B
0557 A75B                       title 'Battery Ram Routines'
0558 A75B              ****************************************************************
0559 A75B              *
0560 A75B              * Write battery ram
0561 A75B              *
0562 A75B              * Input     LongWord     Address
0563 A75B              *
0564 A75B              * Change History
0565 A75B              *
0566 A75B              * 29 January 87	 Ray Montagne
0567 A75B              *
0568 A75B              *    Since firmware cannot generate error on write we don't
0569 A75B              *    look for one to return
0570 A75B              *
0571 A75B              ****************************************************************
0572 A75B              WriteBRam PROC 
0573 A75B
0574 A75B              OrigDir  equ   1
0575 A75B              rtl1     equ   OrigDir+2
0576 A75B              rtl2     equ   rtl1+3
0577 A75B              buffer   equ   rtl2+3
0578 A75B
0579 A75B 0B                    phd                            ; turn stack into zp
0580 A75C 3B                    tsc   
0581 A75D 5B                    tcd   
0582 A75E E2 30                 sep   #$30                     ; 8 bit 'm' & 'x'
0583 A760                       longi off
0584 A760 A0 00                 ldy   #0
0585 A762 A2 00                 ldx   #0
0586 A764              MovLoop                                 ; 
0587 A764 B7 09                 lda   [buffer],y               ; get application data
0588 A766 9F C0 02 E1           sta   >BramBuffer,x            ; move to our buffer
0589 A76A CA                    dex   
0590 A76B 88                    dey   
0591 A76C D0 F6                 bne   movloop
0592 A76E E2 30                 sep   #$30                     ; 8 bit m/x
0593 A770 22 80 00 E1           jsl   ToWriteBram
0594 A774 C2 30                 rep   #$30
0595 A776                       longa on
0596 A776                       longi on
0597 A776
0598 A776 4C 0E FC              jmp   EndCall4
0599 A779
0600 A779              BramErr                                 ;       
0601 A779 A2 07 03              ldx   #firmTaskErr             ; BRAM call failed
0602 A77C 4C 11 FC              jmp   ErrOut4
0603 A77F
0604 A77F                       ENDP 
0605 A77F
0606 A77F
0607 A77F
0608 A77F
0609 A77F              ****************************************************************
0610 A77F              *
0611 A77F              ReadBRam PROC 
0612 A77F              *
0613 A77F              * Reads the page of battery RAM into the callers buffer.
0614 A77F              *
0615 A77F              *
0616 A77F              * Inputs:
0617 A77F              *	BufferPtr : Long
0618 A77F              *
0619 A77F              * Outputs:
0620 A77F              *	none
0621 A77F              *
0622 A77F              * External Refs:
0623 A77F              *	none
0624 A77F              *
0625 A77F              * Entry Points:
0626 A77F              *	none
0627 A77F              *
0628 A77F                       longa on                       ; mode
0629 A77F                       longi on
0630 A77F              *
0631 A77F              * Change History
0632 A77F              *
0633 A77F              * 17 Jun 88	Steven Glass
0634 A77F              *
0635 A77F              * This routine had always called the routine which did an actual
0636 A77F              * read of the battery RAM.  This is not necessary since the
0637 A77F              * battery ram buffer is always correct before the read.
0638 A77F              *
0639 A77F              * Making this change we save the read time (1/10 second with
0640 A77F              * interrupts off).
0641 A77F              *
0642 A77F              ****************************************************************
0643 A77F
0644 A77F
0645 A77F              OrigDir  equ   1
0646 A77F              rtl1     equ   OrigDir+2
0647 A77F              rtl2     equ   rtl1+3
0648 A77F              buffer   equ   rtl2+3
0649 A77F
0650 A77F 0B                    phd                            ; turn stack into zp
0651 A780 3B                    tsc   
0652 A781 5B                    tcd   
0653 A782
0654 A782 E2 30                 sep   #$30                     ; 8 bit 'm' and 'x'
0655 A784                       longi off
0656 A784                       longa off
0657 A784
0658 A784 A2 00                 ldx   #0
0659 A786 A0 00                 ldy   #0
0660 A788 BF C0 02 E1  movloop  lda   >BramBuffer,x            ; data from bram buffer
0661 A78C 97 09                 sta   [buffer],y               ; to user buffer
0662 A78E CA                    dex   
0663 A78F 88                    dey   
0664 A790 D0 F6                 bne   movloop
0665 A792
0666 A792
0667 A792 C2 30                 rep   #$30                     ; 16 bit 'm' and 'x'
0668 A794                       longa on
0669 A794                       longi on
0670 A794 4C 0E FC              jmp   EndCall4
0671 A797
0672 A797                       ENDP 
0673 A797
0674 A797
0675 A797
0676 A797
0677 A797              ****************************************************************
0678 A797              *
0679 A797              WriteBParam PROC 
0680 A797              *
0681 A797              * Takes the value from the stack, puts it into the BRam buffer
0682 A797              * and writes to the battery.
0683 A797              *
0684 A797              *
0685 A797              * Input     word	 Data
0686 A797              * Input     word	 Parameter #
0687 A797              *
0688 A797              * Outputs   none
0689 A797              *
0690 A797              * External Refs:
0691 A797                       import BParamIndexToTable 
0692 A797              *
0693 A797              * Entry Points:
0694 A797              *	none
0695 A797              *
0696 A797                       longa on                       ; mode
0697 A797                       longi on
0698 A797              *
0699 A797              * Change History
0700 A797              *
0701 A797              * 29 January 87	 Ray Montagne
0702 A797              *
0703 A797              *    Since firmware cannot generate error on write we don't
0704 A797              *    look for one to return
0705 A797              *
0706 A797              * 10 Sep 88	Steven Glass
0707 A797              *
0708 A797              * Index number is directed through table, rather than being
0709 A797              * actual memory location in the BRAM.
0710 A797              *
0711 A797              * 14 Sep 88	Steven Glass
0712 A797              *
0713 A797              * Table index is only one byte wide so I mask result
0714 A797              *
0715 A797              ****************************************************************
0716 A797
0717 A797
0718 A797 E2 30                 sep   #$30
0719 A799                       longa off
0720 A799                       longi off
0721 A799
0722 A799 22 84 00 E1           jsl   ToReadBram               ; read ram first
0723 A79D A3 07                 lda   7,s                      ; get parm index
0724 A79F 29 FF                 and   #$00FF
0725 A7A1 AA                    tax                            ; Turn index into buffer address
0726 A7A2 BF D2 A7 FE           lda   >BParamIndexToTable,x
0727 A7A6 29 FF                 and   #$00FF
0728 A7A8 AA                    tax   
0729 A7A9 A3 09                 lda   9,s                      ; get data
0730 A7AB 9F C0 02 E1           sta   >BramBuffer,x            ; move to BRAM buffer
0731 A7AF 22 80 00 E1           jsl   ToWriteBram              ; now write ram
0732 A7B3 C2 30                 rep   #$30
0733 A7B5
0734 A7B5                       longa on
0735 A7B5                       longi on
0736 A7B5 4C 0D FC              jmp   oEndCall4
0737 A7B8                       ENDP 
0738 A7B8
0739 A7B8
0740 A7B8
0741 A7B8
0742 A7B8              ****************************************************************
0743 A7B8              *
0744 A7B8              ReadBParam PROC 
0745 A7B8              *
0746 A7B8              * Returns the specified byte from the battery RAM on the stack.
0747 A7B8              *
0748 A7B8              *
0749 A7B8              * Inputs:
0750 A7B8              *	Space for result : word
0751 A7B8              *	ID of Parameter to read : word
0752 A7B8              *
0753 A7B8              * Outputs:
0754 A7B8              *	Parameter value : word
0755 A7B8              *
0756 A7B8              * External Refs:
0757 A7B8                       import BParamIndexToTable 
0758 A7B8              *
0759 A7B8              * Entry Points:
0760 A7B8              *	none
0761 A7B8              *
0762 A7B8                       longa on                       ; mode
0763 A7B8                       longi on
0764 A7B8              *
0765 A7B8              * Change History
0766 A7B8              *
0767 A7B8              * 17 Jun 88	Steven Glass
0768 A7B8              *
0769 A7B8              * This routine had always called the routine which did an actual
0770 A7B8              * read of the battery RAM.  This is not necessary since the
0771 A7B8              * battery ram buffer is always correct before the read.
0772 A7B8              *
0773 A7B8              * Making this change we save the read time (1/10 second with
0774 A7B8              * interrupts off).
0775 A7B8              *
0776 A7B8              * 10 Sep 88	Steven Glass
0777 A7B8              *
0778 A7B8              * Index number is directed through table, rather than being
0779 A7B8              * actual memory location in the BRAM
0780 A7B8              *
0781 A7B8              * 
0782 A7B8              * 14 Sep 88	Steven Glass
0783 A7B8              *
0784 A7B8              * Table index is only one byte wide so I mask result
0785 A7B8              *
0786 A7B8              *
0787 A7B8              ****************************************************************
0788 A7B8                       DefineStack 
0789 A7B8              RTL1     block 3 
0790 A7B8              RTL2     block 3 
0791 A7B8              ParamID  word 
0792 A7B8              ResultValue word 
0793 A7B8
0794 A7B8 A3 07                 lda   ParamID,s                ; get parm index
0795 A7BA 29 FF 00              and   #$00FF
0796 A7BD AA                    tax                            ; Turn index into buffer address
0797 A7BE BF D2 A7 FE           lda   >BParamIndexToTable,x
0798 A7C2 29 FF 00              and   #$00FF
0799 A7C5 AA                    tax   
0800 A7C6 BF C0 02 E1           lda   >BramBuffer,x            ; move from BRAM buffer
0801 A7CA 29 FF 00              and   #$00FF
0802 A7CD 83 09                 sta   ResultValue,s
0803 A7CF 4C F7 FB              jmp   oEndCall2
0804 A7D2
0805 A7D2
0806 A7D2                       ENDP 
0807 A7D2
0808 A7D2
0809 A7D2
0810 A7D2              ****************************************************************
0811 A7D2              *
0812 A7D2              BParamIndexToTable PROC 
0813 A7D2              *
0814 A7D2              * This is a table of addresses in the battery RAM.  The 
0815 A7D2              * zeroth entry gives the address of item 0 in the RAM.  The
0816 A7D2              * next entry gives the address of the next item, etc.
0817 A7D2              *
0818 A7D2              ****************************************************************
0819 A7D2
0820 A7D2
0821 A7D2 00                    DC B:$00                       ; $00 Port Type for Port 1
0822 A7D3 01                    DC B:$01                       ; $01 Line Length
0823 A7D4 02                    DC B:$02                       ; $02 Delete First LF after CR
0824 A7D5 03                    DC B:$03                       ; $03 Add LF after CR
0825 A7D6 04                    DC B:$04                       ; $04 Echo
0826 A7D7 05                    DC B:$05                       ; $05 Buffering
0827 A7D8 06                    DC B:$06                       ; $06 Baud
0828 A7D9 07                    DC B:$07                       ; $07 Parity
0829 A7DA 08                    DC B:$08                       ; $08 Data/Stop Bits
0830 A7DB 09                    DC B:$09                       ; $09 DCD Handshake
0831 A7DC 0A                    DC B:$0A                       ; $0A DSR/DTR Handshake
0832 A7DD 0B                    DC B:$0B                       ; $0B XON/XOFF Handshake
0833 A7DE 0C                    DC B:$0C                       ; $0C Port Type for Port 2
0834 A7DF 0D                    DC B:$0D                       ; $0D Line Length
0835 A7E0 0E                    DC B:$0E                       ; $0E Delete First LF after CR
0836 A7E1 0F                    DC B:$0F                       ; $0F Add LF after CR
0837 A7E2
0838 A7E2 10                    DC B:$10                       ; $10 Echo
0839 A7E3 11                    DC B:$11                       ; $11 Buffering
0840 A7E4 12                    DC B:$12                       ; $12 Baud
0841 A7E5 13                    DC B:$13                       ; $13 Parity
0842 A7E6 14                    DC B:$14                       ; $14 Data/Stop Bits
0843 A7E7 15                    DC B:$15                       ; $15 DCD Handshake
0844 A7E8 16                    DC B:$16                       ; $16 DSR/DTR Handshake
0845 A7E9 17                    DC B:$17                       ; $17 XON/XOFF Handshake
0846 A7EA 18                    DC B:$18                       ; $18 Display Type
0847 A7EB 19                    DC B:$19                       ; $19 Columns
0848 A7EC 1A                    DC B:$1A                       ; $1A Text Color
0849 A7ED 1B                    DC B:$1B                       ; $1B Background Color
0850 A7EE 1C                    DC B:$1C                       ; $1C Border Color
0851 A7EF 1D                    DC B:$1D                       ; $1D Display Cycle Rate (Hertz)
0852 A7F0 1E                    DC B:$1E                       ; $1E Volume
0853 A7F1 1F                    DC B:$1F                       ; $1F Pitch
0854 A7F2
0855 A7F2 20                    DC B:$20                       ; $20 Speed
0856 A7F3 58                    DC B:$58                       ; $21 Fake Slot 1
0857 A7F4 22                    DC B:$22                       ; $22 Slot 2
0858 A7F5 23                    DC B:$23                       ; $23 Slot 3
0859 A7F6 24                    DC B:$24                       ; $24 Slot 4
0860 A7F7 25                    DC B:$25                       ; $25 Slot 5
0861 A7F8 26                    DC B:$26                       ; $26 Slot 6
0862 A7F9 27                    DC B:$27                       ; $27 Slot 7
0863 A7FA 28                    DC B:$28                       ; $28 Startup Slot
0864 A7FB 29                    DC B:$29                       ; $29 Display Language
0865 A7FC 2A                    DC B:$2A                       ; $2A Keyboard Layout
0866 A7FD 2B                    DC B:$2B                       ; $2B Keyboard Buffering
0867 A7FE 2C                    DC B:$2C                       ; $2C Repeat Speed
0868 A7FF 2D                    DC B:$2D                       ; $2D Repeat Delay
0869 A800 3A                    DC B:$3A                       ; $2E Double Click
0870 A801 2E                    DC B:$2E                       ; $2F Cursor Flash
0871 A802
0872 A802 2F                    DC B:$2F                       ; $30 Shift Caps/Lower Case
0873 A803 30                    DC B:$30                       ; $31 Fast Space & Delete keys
0874 A804 31                    DC B:$31                       ; $32 Dual Speed Keys
0875 A805 39                    DC B:$39                       ; $33 Mouse Tracking
0876 A806 34                    DC B:$34                       ; $34 Date Format
0877 A807 35                    DC B:$35                       ; $35 Time Format
0878 A808 36                    DC B:$36                       ; $36 Min Ram Disk Size
0879 A809 37                    DC B:$37                       ; $37 Max Ram Disk Size
0880 A80A 3E                    DC B:$3E                       ; $38 Number of Languages
0881 A80B 3F                    DC B:$3F                       ; $39 First Language
0882 A80C 40                    DC B:$40                       ; $3A Second Language
0883 A80D 41                    DC B:$41                       ; $3B Third Language
0884 A80E 42                    DC B:$42                       ; $3C Fourth Language
0885 A80F 43                    DC B:$43                       ; $3D Fifth Language
0886 A810 44                    DC B:$44                       ; $3E Sixth Language
0887 A811 45                    DC B:$45                       ; $3F Seventh Language
0888 A812
0889 A812 46                    DC B:$46                       ; $40 Eightth Language
0890 A813 47                    DC B:$47                       ; $41 Number of Layouts
0891 A814 48                    DC B:$48                       ; $42 First Layout
0892 A815 49                    DC B:$49                       ; $43 Second Layout
0893 A816 4A                    DC B:$4A                       ; $44 Third Layout
0894 A817 4B                    DC B:$4B                       ; $45 Fourth Layout
0895 A818 4C                    DC B:$4C                       ; $46 Fifth Layout
0896 A819 4D                    DC B:$4D                       ; $47 Sixth Layout
0897 A81A 4E                    DC B:$4E                       ; $48 Seventh Layout
0898 A81B 4F                    DC B:$4F                       ; $49 Eightth Layout
0899 A81C 50                    DC B:$50                       ; $4A Ninth Layout
0900 A81D 51                    DC B:$51                       ; $4B Tenth Layout
0901 A81E 52                    DC B:$52                       ; $4C Eleventh Layout
0902 A81F 53                    DC B:$53                       ; $4D Twelvth Layout
0903 A820 54                    DC B:$54                       ; $4E Thirteenth Layout
0904 A821 55                    DC B:$55                       ; $4F Fourteenth Layout
0905 A822
0906 A822 56                    DC B:$56                       ; $50 Fifteenth Layout
0907 A823 57                    DC B:$57                       ; $51 Sixteenth Layout
0908 A824 32                    DC B:$32                       ; $52 Disk Eject 1
0909 A825 33                    DC B:$33                       ; $53 Disk Eject 2
0910 A826 38                    DC B:$38                       ; $54 Reset RAM at next Reset
0911 A827 3B                    DC B:$3B                       ; $55 Delay To Start
0912 A828 3C                    DC B:$3C                       ; $56 Acceleration
0913 A829 3D                    DC B:$3D                       ; $57 Maximum Speed
0914 A82A 58                    DC B:$58                       ; $58 new Slot 1
0915 A82B 59                    DC B:$59                       ; $59
0916 A82C 5A                    DC B:$5A                       ; $5A
0917 A82D 5B                    DC B:$5B                       ; $5B
0918 A82E 5C                    DC B:$5C                       ; $5C
0919 A82F 5D                    DC B:$5D                       ; $5D
0920 A830 5E                    DC B:$5E                       ; $5E
0921 A831 5F                    DC B:$5F                       ; $5F
0922 A832
0923 A832 60                    DC B:$60                       ; $60
0924 A833 61                    DC B:$61                       ; $61
0925 A834 62                    DC B:$62                       ; $62
0926 A835 63                    DC B:$63                       ; $63
0927 A836 64                    DC B:$64                       ; $64
0928 A837 65                    DC B:$65                       ; $65
0929 A838 66                    DC B:$66                       ; $66
0930 A839 67                    DC B:$67                       ; $67
0931 A83A 68                    DC B:$68                       ; $68
0932 A83B 69                    DC B:$69                       ; $69
0933 A83C 6A                    DC B:$6A                       ; $6A
0934 A83D 6B                    DC B:$6B                       ; $6B
0935 A83E 6C                    DC B:$6C                       ; $6C
0936 A83F 6D                    DC B:$6D                       ; $6D
0937 A840 6E                    DC B:$6E                       ; $6E
0938 A841 6F                    DC B:$6F                       ; $6F
0939 A842
0940 A842 70                    DC B:$70                       ; $70
0941 A843 71                    DC B:$71                       ; $71
0942 A844 72                    DC B:$72                       ; $72
0943 A845 73                    DC B:$73                       ; $73
0944 A846 74                    DC B:$74                       ; $74
0945 A847 75                    DC B:$75                       ; $75
0946 A848 76                    DC B:$76                       ; $76
0947 A849 77                    DC B:$77                       ; $77 Reserved
0948 A84A 78                    DC B:$78                       ; $78 PassWord
0949 A84B 79                    DC B:$79                       ; $79 PassWord
0950 A84C 7A                    DC B:$7A                       ; $7A PassWord
0951 A84D 7B                    DC B:$7B                       ; $7B PassWord
0952 A84E 7C                    DC B:$7C                       ; $7C PassWord
0953 A84F 7D                    DC B:$7D                       ; $7D PassWord
0954 A850 7E                    DC B:$7E                       ; $7E PassWord
0955 A851 7F                    DC B:$7F                       ; $7F PassWord
0956 A852
0957 A852 80                    DC B:$80                       ; $80 AppleTalk Node Number
0958 A853 81                    DC B:$81                       ; $81 OS Variables
0959 A854 82                    DC B:$82                       ; $82
0960 A855 83                    DC B:$83                       ; $83
0961 A856 84                    DC B:$84                       ; $84
0962 A857 85                    DC B:$85                       ; $85
0963 A858 86                    DC B:$86                       ; $86
0964 A859 87                    DC B:$87                       ; $87
0965 A85A 88                    DC B:$88                       ; $88
0966 A85B 89                    DC B:$89                       ; $89
0967 A85C 8A                    DC B:$8A                       ; $8A
0968 A85D 8B                    DC B:$8B                       ; $8B
0969 A85E 8C                    DC B:$8C                       ; $8C
0970 A85F 8D                    DC B:$8D                       ; $8D
0971 A860 8E                    DC B:$8E                       ; $8E
0972 A861 8F                    DC B:$8F                       ; $8F
0973 A862
0974 A862 90                    DC B:$90                       ; $90
0975 A863 91                    DC B:$91                       ; $91
0976 A864 92                    DC B:$92                       ; $92
0977 A865 93                    DC B:$93                       ; $93
0978 A866 94                    DC B:$94                       ; $94
0979 A867 95                    DC B:$95                       ; $95
0980 A868 96                    DC B:$96                       ; $96
0981 A869 97                    DC B:$97                       ; $97
0982 A86A 98                    DC B:$98                       ; $98
0983 A86B 99                    DC B:$99                       ; $99
0984 A86C 9A                    DC B:$9A                       ; $9A
0985 A86D 9B                    DC B:$9B                       ; $9B
0986 A86E 9C                    DC B:$9C                       ; $9C
0987 A86F 9D                    DC B:$9D                       ; $9D
0988 A870 9E                    DC B:$9E                       ; $9E
0989 A871 9F                    DC B:$9F                       ; $9F
0990 A872
0991 A872 A0                    DC B:$A0                       ; $A0
0992 A873 A1                    DC B:$A1                       ; $A1
0993 A874 A2                    DC B:$A2                       ; $A2
0994 A875 A3                    DC B:$A3                       ; $A3
0995 A876 A4                    DC B:$A4                       ; $A4
0996 A877 A5                    DC B:$A5                       ; $A5
0997 A878 A6                    DC B:$A6                       ; $A6
0998 A879 A7                    DC B:$A7                       ; $A7
0999 A87A A8                    DC B:$A8                       ; $A8
1000 A87B A9                    DC B:$A9                       ; $A9
1001 A87C AA                    DC B:$AA                       ; $AA
1002 A87D AB                    DC B:$AB                       ; $AB
1003 A87E AC                    DC B:$AC                       ; $AC
1004 A87F AD                    DC B:$AD                       ; $AD
1005 A880 AE                    DC B:$AE                       ; $AE
1006 A881 AF                    DC B:$AF                       ; $AF
1007 A882
1008 A882 B0                    DC B:$B0                       ; $B0
1009 A883 B1                    DC B:$B1                       ; $B1
1010 A884 B2                    DC B:$B2                       ; $B2
1011 A885 B3                    DC B:$B3                       ; $B3
1012 A886 B4                    DC B:$B4                       ; $B4
1013 A887 B5                    DC B:$B5                       ; $B5
1014 A888 B6                    DC B:$B6                       ; $B6
1015 A889 B7                    DC B:$B7                       ; $B7
1016 A88A B8                    DC B:$B8                       ; $B8
1017 A88B B9                    DC B:$B9                       ; $B9
1018 A88C BA                    DC B:$BA                       ; $BA
1019 A88D BB                    DC B:$BB                       ; $BB
1020 A88E BC                    DC B:$BC                       ; $BC
1021 A88F BD                    DC B:$BD                       ; $BD
1022 A890 BE                    DC B:$BE                       ; $BE
1023 A891 BF                    DC B:$BF                       ; $BF OS Variables
1024 A892
1025 A892 C0                    DC B:$C0                       ; $C0 Reserved
1026 A893 C1                    DC B:$C1                       ; $C1
1027 A894 C2                    DC B:$C2                       ; $C2
1028 A895 C3                    DC B:$C3                       ; $C3
1029 A896 C4                    DC B:$C4                       ; $C4
1030 A897 C5                    DC B:$C5                       ; $C5
1031 A898 C6                    DC B:$C6                       ; $C6
1032 A899 C7                    DC B:$C7                       ; $C7
1033 A89A C8                    DC B:$C8                       ; $C8
1034 A89B C9                    DC B:$C9                       ; $C9
1035 A89C CA                    DC B:$CA                       ; $CA
1036 A89D CB                    DC B:$CB                       ; $CB
1037 A89E CC                    DC B:$CC                       ; $CC
1038 A89F CD                    DC B:$CD                       ; $CD
1039 A8A0 CE                    DC B:$CE                       ; $CE
1040 A8A1 CF                    DC B:$CF                       ; $CF
1041 A8A2
1042 A8A2 D0                    DC B:$D0                       ; $D0
1043 A8A3 D1                    DC B:$D1                       ; $D1
1044 A8A4 D2                    DC B:$D2                       ; $D2
1045 A8A5 D3                    DC B:$D3                       ; $D3
1046 A8A6 D4                    DC B:$D4                       ; $D4
1047 A8A7 D5                    DC B:$D5                       ; $D5
1048 A8A8 D6                    DC B:$D6                       ; $D6
1049 A8A9 D7                    DC B:$D7                       ; $D7
1050 A8AA D8                    DC B:$D8                       ; $D8
1051 A8AB D9                    DC B:$D9                       ; $D9
1052 A8AC DA                    DC B:$DA                       ; $DA
1053 A8AD DB                    DC B:$DB                       ; $DB
1054 A8AE DC                    DC B:$DC                       ; $DC
1055 A8AF DD                    DC B:$DD                       ; $DD
1056 A8B0 DE                    DC B:$DE                       ; $DE
1057 A8B1 DF                    DC B:$DF                       ; $DF
1058 A8B2
1059 A8B2 E0                    DC B:$E0                       ; $E0
1060 A8B3 E1                    DC B:$E1                       ; $E1
1061 A8B4 E2                    DC B:$E2                       ; $E2
1062 A8B5 E3                    DC B:$E3                       ; $E3
1063 A8B6 E4                    DC B:$E4                       ; $E4
1064 A8B7 E5                    DC B:$E5                       ; $E5
1065 A8B8 E6                    DC B:$E6                       ; $E6
1066 A8B9 E7                    DC B:$E7                       ; $E7
1067 A8BA E8                    DC B:$E8                       ; $E8
1068 A8BB E9                    DC B:$E9                       ; $E9
1069 A8BC EA                    DC B:$EA                       ; $EA
1070 A8BD EB                    DC B:$EB                       ; $EB
1071 A8BE EC                    DC B:$EC                       ; $EC
1072 A8BF ED                    DC B:$ED                       ; $ED
1073 A8C0 EE                    DC B:$EE                       ; $EE
1074 A8C1 EF                    DC B:$EF                       ; $EF
1075 A8C2
1076 A8C2 F0                    DC B:$F0                       ; $F0
1077 A8C3 F1                    DC B:$F1                       ; $F1
1078 A8C4 F2                    DC B:$F2                       ; $F2
1079 A8C5 F3                    DC B:$F3                       ; $F3
1080 A8C6 F4                    DC B:$F4                       ; $F4
1081 A8C7 F5                    DC B:$F5                       ; $F5
1082 A8C8 F6                    DC B:$F6                       ; $F6
1083 A8C9 F7                    DC B:$F7                       ; $F7
1084 A8CA F8                    DC B:$F8                       ; $F8
1085 A8CB F9                    DC B:$F9                       ; $F9
1086 A8CC FA                    DC B:$FA                       ; $FA
1087 A8CD FB                    DC B:$FB                       ; $FB Reserved
1088 A8CE FC                    DC B:$FC                       ; $FC Check Sum
1089 A8CF FD                    DC B:$FD                       ; $FD Check Sum
1090 A8D0 FE                    DC B:$FE                       ; $FE Check Sum
1091 A8D1 FF                    DC B:$FF                       ; $FF Check Sum
1092 A8D2
1093 A8D2
1094 A8D2
1095 A8D2
1096 A8D2                       ENDP 
1097 A8D2
1098 A8D2
1099 A8D2                       title 'Time Routines'
1100 A8D2              ****************************************************************
1101 A8D2              *
1102 A8D2              * RdTimeHex:
1103 A8D2              *     Input     Word     Space for result
1104 A8D2              *     Input     Word     Space for result
1105 A8D2              *     Input     Word     Space for result
1106 A8D2              *     Input     Word     Space for result
1107 A8D2              *     Output    Byte     Year
1108 A8D2              *     Output    Byte     Month   (0...11)
1109 A8D2              *     Output    Byte     Day     (0...30)
1110 A8D2              *     Output    Byte     Hour    (0...23)
1111 A8D2              *     Output    Byte     Minute  (0...59)
1112 A8D2              *     Output    Byte     Second  (0...59)
1113 A8D2              *     Output    Byte     Null
1114 A8D2              *     Output    Byte     Day of Week (0....6)
1115 A8D2              *
1116 A8D2              ****************************************************************
1117 A8D2              RdTimeHex PROC 
1118 A8D2
1119 A8D2              D0       equ   $E103E9
1120 A8D2              D1       equ   D0+4
1121 A8D2              D2       equ   D1+4
1122 A8D2              D3       equ   D2+4
1123 A8D2              D4       equ   D3+4
1124 A8D2
1125 A8D2              OrigDir  equ   1
1126 A8D2              OrigDBR  equ   OrigDir+2
1127 A8D2              OrigP    equ   OrigDBR+1
1128 A8D2              rtl1     equ   OrigP+1
1129 A8D2              rtl2     equ   rtl1+3
1130 A8D2              Second   equ   rtl2+3
1131 A8D2              Minute   equ   Second+1
1132 A8D2              Hour     equ   Minute+1
1133 A8D2              Year     equ   Hour+1
1134 A8D2              Day      equ   Year+1
1135 A8D2              Month    equ   Day+1
1136 A8D2              null     equ   Month+1
1137 A8D2              WkDay    equ   Null+1
1138 A8D2
1139 A8D2              WSsize   equ   10                       ; 10 words - DUMMY !!!
1140 A8D2
1141 A8D2 E2 30                 sep   #$30                     ; off to 8 bit land
1142 A8D4 22 8C 00 E1           jsl   ToReadTime               ; read clock
1143 A8D8 C2 30                 rep   #$30                     ; then back to 16 bit land
1144 A8DA 90 06                 bcc   GotTimeOK                ; if read clock
1145 A8DC A2 07 03              ldx   #firmTaskErr             ; set error flag
1146 A8DF 4C E4 FB              jmp   oErrOut0
1147 A8E2
1148 A8E2              *
1149 A8E2              * now convert Binary time to Hex time format
1150 A8E2              *
1151 A8E2
1152 A8E2              GotTimeOK                               ; 
1153 A8E2 08                    php                            ; save interrupt state
1154 A8E3 78                    sei                            ; and disable interrupts
1155 A8E4 8B                    phb                            ; save data bank
1156 A8E5 F4 E1 E1              pea   $E1E1                    ; and set to our data area
1157 A8E8 AB                    plb   
1158 A8E9 AB                    plb   
1159 A8EA 0B                    phd                            ; save direct page
1160 A8EB 3B                    tsc                            ; turn stack into zp
1161 A8EC 5B                    tcd   
1162 A8ED
1163 A8ED              *
1164 A8ED              * Have number of seconds N 1984 in ClkRData.
1165 A8ED              * DN  = number of days elapsed = N div 86400
1166 A8ED              * HMS = number of seconds in last day = N mod 86400
1167 A8ED              *
1168 A8ED F4 00 00              pea   $0000                    ; space for result
1169 A8F0 F4 00 00              pea   $0000
1170 A8F3 F4 00 00              pea   $0000
1171 A8F6 F4 00 00              pea   $0000
1172 A8F9 AD E3 03              lda   |ClkRData+2              ; numerator = N
1173 A8FC 48                    pha   
1174 A8FD AD E1 03              lda   |ClkRData
1175 A900 48                    pha   
1176 A901 F4 01 00              pea   $0001                    ; Denom = 86400
1177 A904 F4 80 51              pea   $5180
1178 A907 22 7A AA FE           jsl   ToLDivide                ; want DN
1179 A90B 68                    pla                            ; DN = quotient
1180 A90C 8D E9 03              sta   |D0
1181 A90F 8D F1 03              sta   |D2                      ; and make a copy in D2
1182 A912 68                    pla   
1183 A913 8D EB 03              sta   |D0+2
1184 A916 8D F3 03              sta   |D2+2
1185 A919 68                    pla                            ; HMS = remainder
1186 A91A 8D ED 03              sta   |D1
1187 A91D 68                    pla   
1188 A91E 8D EF 03              sta   |D1+2
1189 A921              *
1190 A921              * YearsGone = (DN * 4) div 1461     where 1461 is 4 * 365 + 1
1191 A921              * Formula depends on leap year being the first of the four.
1192 A921              *
1193 A921 0E F1 03              asl   |D2                      ; DN * 4
1194 A924 2E F3 03              rol   |D2+2
1195 A927 0E F1 03              asl   |D2
1196 A92A 2E F3 03              rol   |D2+2
1197 A92D F4 00 00              pea   $0000                    ; space for result
1198 A930 F4 00 00              pea   $0000
1199 A933 F4 00 00              pea   $0000
1200 A936 F4 00 00              pea   $0000
1201 A939 AD F3 03              lda   |D2+2                    ; YearsGone = (DN*4) div 1461
1202 A93C 48                    pha   
1203 A93D AD F1 03              lda   |D2
1204 A940 48                    pha   
1205 A941 F4 00 00              pea   $0000                    ; 1461 = $000005B5
1206 A944 F4 B5 05              pea   $05B5
1207 A947 22 7A AA FE           jsl   ToLDivide
1208 A94B 18                    clc                            ; YG referenced to 1904
1209 A94C 68                    pla   
1210 A94D 8D F1 03              sta   |D2
1211 A950 69 04 00              adc   #0004
1212 A953 E2 20                 sep   #$20                     ; 8 bit 'm'
1213 A955 85 0E                 sta   year
1214 A957 C2 20                 rep   #$20                     ; 16 bit 'm'
1215 A959 18                    clc   
1216 A95A AD F1 03              lda   |D2
1217 A95D 69 70 07              adc   #1904
1218 A960 8D F1 03              sta   |D2                      ; hex year
1219 A963 68                    pla   
1220 A964 8D F3 03              sta   |D2+2
1221 A967              *
1222 A967              * Need number of days in Jan+Feb just below.
1223 A967              * Take YEAR mod 3 before clearing year.
1224 A967              *
1225 A967 A9 3B 00              lda   #59                      ; assume not leap year
1226 A96A 8D F5 03              sta   |D3
1227 A96D 9C F7 03              stz   |D3+2
1228 A970 A9 03 00              lda   #3                       ; Year MOD 3
1229 A973 2D F1 03              and   |D2
1230 A976 D0 03                 bne   NotLeap
1231 A978 EE F5 03              inc   |D3
1232 A97B              NotLeap                                 ; 
1233 A97B 68                    pla                            ; DOY * 4 in D2
1234 A97C 8D F1 03              sta   |D2
1235 A97F 68                    pla   
1236 A980 8D F3 03              sta   |D2+2                    ; DOY = D2 div 4
1237 A983 4E F3 03              lsr   |D2+2
1238 A986 6E F1 03              ror   |D2
1239 A989 4E F3 03              lsr   |D2+2
1240 A98C 6E F1 03              ror   |D2                      ; DOY in D2
1241 A98F              *
1242 A98F              * Computing Month/Day from DOY is an exercise in interpolation.
1243 A98F              * As a function of DOY, Month is a step function.  Because of
1244 A98F              * the leap year glitch, convenient to restart function at March
1245 A98F              *
1246 A98F              *       DOY	         MONTH
1247 A98F              *--------------------------------------------------------------
1248 A98F              *       0-31	         1    January
1249 A98F              *      31-58	         2    February for non leap year
1250 A98F              *      31-59	         2    February for leap year
1251 A98F              *       0-30	         3    March
1252 A98F              *      31-60	         4    April
1253 A98F              *      61-91	         5    May
1254 A98F              *      92-121	         6    June
1255 A98F              *     122-152	         7    July
1256 A98F              *     153-183	         8    August
1257 A98F              *     184-213	         9    September
1258 A98F              *     214-244	        10    October
1259 A98F              *     245-274	        11    November
1260 A98F              *     275-305	        12    December
1261 A98F              *
1262 A98F              * The linear interpolator is ((DOY * 128) + 71) div 3919
1263 A98F              *
1264 A98F A9 01 00              lda   #1                       ; month offset, 1 or 3
1265 A992 8D F9 03              sta   |D4
1266 A995 AD F1 03              lda   |D2                      ; 59/60 versus DOY
1267 A998 CD F5 03              cmp   |D3
1268 A99B 90 19                 blt   JanFeb                   ; less than means Jan or Feb
1269 A99D EE F9 03              inc   |D4                      ; else adjust month offset
1270 A9A0 EE F9 03              inc   |D4
1271 A9A3 38                    sec                            ; start DOY at march
1272 A9A4 AD F1 03              lda   |D2
1273 A9A7 ED F5 03              sbc   |D3
1274 A9AA 8D F1 03              sta   |D2
1275 A9AD AD F3 03              lda   |D2+2
1276 A9B0 ED F7 03              sbc   |D3+2
1277 A9B3 8D F3 03              sta   |D2+2
1278 A9B6              JanFeb                                  ; 
1279 A9B6 A0 07 00              ldy   #7                       ; DOY * 128
1280 A9B9              MultDOY                                 ; 
1281 A9B9 0E F1 03              asl   |D2
1282 A9BC 2E F3 03              rol   |D2+2
1283 A9BF 88                    dey   
1284 A9C0 D0 F7                 bne   MultDOY
1285 A9C2 F4 00 00              pea   $0000                    ; space for result
1286 A9C5 F4 00 00              pea   $0000
1287 A9C8 18                    clc                            ; (DOY * 128) + 71
1288 A9C9 A9 47 00              lda   #71
1289 A9CC 6D F1 03              adc   |D2
1290 A9CF 8D F1 03              sta   |D2
1291 A9D2 48                    pha                            ; NUM = (DOY * 128) + 71
1292 A9D3 A9 00 00              lda   #0
1293 A9D6 6D F3 03              adc   |D2+2
1294 A9D9 8D F3 03              sta   |D2+2
1295 A9DC F4 4F 0F              pea   $0F4F                    ; DEN = 3919
1296 A9DF 22 7F AA FE           jsl   ToUDivide
1297 A9E3 18                    clc   
1298 A9E4 68                    pla                            ; month = Quot + MOffset
1299 A9E5 6D F9 03              adc   |D4
1300 A9E8 8D F3 03              sta   |D2+2                    ; D2 (MSB) = Month (1..12)
1301 A9EB E2 20                 sep   #$20                     ; 8 bit 'm'
1302 A9ED 3A                    dec   a                        ; make month (0.....11)
1303 A9EE 85 10                 sta   Month
1304 A9F0 C2 20                 rep   #$20                     ; 16 bit 'm'
1305 A9F2 68                    pla                            ; divide by 128 to get DOM
1306 A9F3 A0 07 00              ldy   #7
1307 A9F6              DivDOM                                  ; 
1308 A9F6 4A                    lsr   a
1309 A9F7 88                    dey   
1310 A9F8 D0 FC                 bne   DivDOM
1311 A9FA E2 20                 sep   #$20                     ; 8 bit 'm'
1312 A9FC 85 0F                 sta   Day                      ; day (0....30)
1313 A9FE C2 20                 rep   #$20
1314 AA00              *
1315 AA00              * Hours   = HMS div	3600
1316 AA00              * MS      = HMS mod	3600
1317 AA00              * Minutes = MS div 60
1318 AA00              * Seconds = MS mod 60
1319 AA00              *
1320 AA00 F4 00 00              pea   $0000                    ; space for result
1321 AA03 F4 00 00              pea   $0000
1322 AA06 F4 00 00              pea   $0000
1323 AA09 F4 00 00              pea   $0000
1324 AA0C AD EF 03              lda   |D1+2                    ; Numerator = HMS
1325 AA0F 48                    pha   
1326 AA10 AD ED 03              lda   |D1
1327 AA13 48                    pha   
1328 AA14 F4 00 00              pea   $0000                    ; Denominator = 3600
1329 AA17 F4 10 0E              pea   $0E10
1330 AA1A 22 7A AA FE           jsl   ToLDivide
1331 AA1E 68                    pla   
1332 AA1F FA                    plx                            ; Hours = Quot
1333 AA20 E2 20                 sep   #$20                     ; 8 bit 'm'
1334 AA22 85 0D                 sta   Hour
1335 AA24 C2 20                 rep   #$20
1336 AA26 68                    pla                            ; MS = remainder
1337 AA27 FA                    plx   
1338 AA28 F4 00 00              pea   $0000                    ; space for result
1339 AA2B F4 00 00              pea   $0000
1340 AA2E 48                    pha                            ; Numerator = MS
1341 AA2F F4 3C 00              pea   $003C                    ; Denominator = 60
1342 AA32 22 7F AA FE           jsl   ToUDivide
1343 AA36 68                    pla                            ; Minutes = Quot
1344 AA37 E2 20                 sep   #$20                     ; 8 bit 'm'
1345 AA39 85 0C                 sta   Minute
1346 AA3B 68                    pla   
1347 AA3C 85 0B                 sta   Second
1348 AA3E 68                    pla                            ; clean up
1349 AA3F C2 30                 rep   #$30                     ; 16 bit 'm'
1350 AA41              *
1351 AA41              * Finally get the day of week = ((DN + 5) mod 7) + 1
1352 AA41              * The 5 is added since 1 Jan 1904 was a Friday.
1353 AA41              *
1354 AA41 F4 00 00              pea   $0000                    ; space for divide
1355 AA44 F4 00 00              pea   $0000
1356 AA47 F4 00 00              pea   $0000
1357 AA4A F4 00 00              pea   $0000
1358 AA4D 18                    clc   
1359 AA4E A9 05 00              lda   #5                       ; DN+5
1360 AA51 6F E9 03 E1           adc   D0
1361 AA55 AA                    tax   
1362 AA56 A9 00 00              lda   #0
1363 AA59 6F EB 03 E1           adc   D0+2
1364 AA5D 48                    pha   
1365 AA5E DA                    phx   
1366 AA5F F4 00 00              pea   $0000
1367 AA62 F4 07 00              pea   $0007
1368 AA65 22 7A AA FE           jsl   ToLDivide                ; ((DN + 5) mod 7)
1369 AA69 68                    pla   
1370 AA6A 68                    pla   
1371 AA6B 68                    pla                            ; Get DOW-1
1372 AA6C 1A                    inc   a                        ; ((DN + 5) mod 7) + 1
1373 AA6D FA                    plx   
1374 AA6E E2 20                 sep   #$20                     ; 8 bit 'm'
1375 AA70 85 12                 sta   WkDay                    ; store day of week
1376 AA72 C2 20                 rep   #$20                     ; 16 bit 'm'
1377 AA74 2B                    pld                            ; restore direct page
1378 AA75 AB                    plb                            ; restore data area
1379 AA76 28                    plp                            ; restore interrupt state
1380 AA77 4C DF FB              jmp   oEndCall0                ; all done
1381 AA7A
1382 AA7A                       ENTRY ToLDivide 
1383 AA7A              ToLDivide                               ;       
1384 AA7A 22 CD F1 FE           jsl   LongDiv
1385 AA7E 6B                    rtl   
1386 AA7F
1387 AA7F                       ENTRY ToUDivide 
1388 AA7F              ToUDivide                               ;       
1389 AA7F 22 23 F1 FE           jsl   UDivide
1390 AA83 6B                    rtl   
1391 AA84
1392 AA84                       ENDP 
1393 AA84
1394 AA84
1395 AA84              ****************************************************************
1396 AA84              *
1397 AA84              * WrTimeHex:
1398 AA84              *
1399 AA84              *     Input     Byte     second (0.....59)
1400 AA84              *     Input     Byte     Minute (0.....59)
1401 AA84              *     Input     Byte     Hour   (0.....23)
1402 AA84              *     Input     Byte     Day    (0.....30)
1403 AA84              *     Input     Byte     Month  (0.....11)
1404 AA84              *     Input     Byte     Year
1405 AA84              *
1406 AA84              * Change History
1407 AA84              *
1408 AA84              * February 18, 1987	 Ray Montagne
1409 AA84              *
1410 AA84              * Wrong error code was being returned.
1411 AA84              *
1412 AA84              ****************************************************************
1413 AA84
1414 AA84              WrTimeHex PROC 
1415 AA84
1416 AA84              D0       equ   $E103E9
1417 AA84              D1       equ   D0+4
1418 AA84              D2       equ   D1+4
1419 AA84              D3       equ   D2+4
1420 AA84              D4       equ   D3+4
1421 AA84
1422 AA84              OrigDir  equ   1
1423 AA84              OrigDBR  equ   OrigDir+2
1424 AA84              OrigP    equ   OrigDBR+1
1425 AA84              rtl1     equ   OrigP+1
1426 AA84              rtl2     equ   rtl1+3
1427 AA84              Second   equ   rtl2+3
1428 AA84              Minute   equ   Second+1
1429 AA84              Hour     equ   Minute+1
1430 AA84              Year     equ   Hour+1
1431 AA84              Day      equ   Year+1
1432 AA84              Month    equ   Day+1
1433 AA84
1434 AA84              WSsize   equ   10                       ; is 20 bytes workspace area
1435 AA84
1436 AA84 08                    php                            ; save interrupt state
1437 AA85 78                    sei                            ; and disable IRQ
1438 AA86 8B                    phb                            ; save data area
1439 AA87 F4 E1 E1              pea   $E1E1                    ; set our own
1440 AA8A AB                    plb   
1441 AA8B AB                    plb   
1442 AA8C 0B                    phd                            ; save direct page
1443 AA8D 3B                    tsc                            ; set stack = zp
1444 AA8E 5B                    tcd   
1445 AA8F E2 30                 sep   #$30                     ; 8 bit 'm' and 'x'
1446 AA91                       longa off
1447 AA91                       longi off
1448 AA91 8B                    phb                            ; save DBR for bounds chk
1449 AA92 4B                    phk                            ; set DBR to code segment
1450 AA93 AB                    plb   
1451 AA94 A4 10                 ldy   Month                    ; get month
1452 AA96 A5 0E                 lda   Year                     ; get year
1453 AA98 29 03                 and   #3                       ; leap year?
1454 AA9A D0 06                 bne   DayCheck                 ; no
1455 AA9C C0 01                 cpy   #1                       ; if yes, is it February?
1456 AA9E D0 02                 bne   DayCheck                 ; no
1457 AAA0 A0 0C                 ldy   #12                      ; if February & leap year
1458 AAA2              DayCheck                                ; 
1459 AAA2 A5 0F                 lda   Day                      ; and day
1460 AAA4 D9 36 AC              cmp   MonthLen,y               ; check valid day ?
1461 AAA7 C2 30                 rep   #$30                     ; 16 bit 'm' and 'x'
1462 AAA9                       longa on
1463 AAA9                       longi on
1464 AAA9 90 0A                 bcc   DayOK                    ; if valid
1465 AAAB AB                    plb   
1466 AAAC 2B                    pld                            ; restore direct page
1467 AAAD AB                    plb                            ; and data bank
1468 AAAE 28                    plp                            ; restore interrupt state
1469 AAAF A2 01 03              ldx   #badInputErr             ; bad input parm error changed 18 Feb
1470 AAB2              ;                                       ;                87 by RBM
1471 AAB2 4C 28 FC              jmp   oErrOut6
1472 AAB5              DayOK                                   ; 
1473 AAB5 AB                    plb                            ; restore DBR
1474 AAB6
1475 AAB6              *
1476 AAB6              * Have Year/Month/Day/Hour/Minute/Second in a sequence of words
1477 AAB6              * in direct page.
1478 AAB6              *
1479 AAB6              * DAYSGONE * 86400 + HOURS * 3600 + MINUTES * 60 + SECONDS
1480 AAB6              *
1481 AAB6              * Do the easy part with HOURS, MINUTES, and SECONDS.
1482 AAB6              *
1483 AAB6 F4 00 00              pea   $0000                    ; space for result
1484 AAB9 F4 00 00              pea   $0000
1485 AABC F4 00 00              pea   $0000
1486 AABF F4 00 00              pea   $0000
1487 AAC2 A5 0D                 lda   Hour                     ; Convert hour to minutes
1488 AAC4 29 FF 00              and   #$00FF
1489 AAC7 48                    pha   
1490 AAC8 F4 3C 00              pea   $003C                    ; Hour * 60
1491 AACB 22 31 AC FE           jsl   ToMult
1492 AACF 18                    clc   
1493 AAD0 A5 0C                 lda   Minute                   ; (Hour * 60) + Minute
1494 AAD2 29 FF 00              and   #$00FF
1495 AAD5 63 01                 adc   1,s
1496 AAD7 83 01                 sta   1,s
1497 AAD9 A9 00 00              lda   #0
1498 AADC 63 03                 adc   3,s
1499 AADE 83 03                 sta   3,s
1500 AAE0 68                    pla   
1501 AAE1 FA                    plx   
1502 AAE2 48                    pha   
1503 AAE3 F4 3C 00              pea   $003C                    ; ((Hour * 60) + Minute) * 60
1504 AAE6 22 31 AC FE           jsl   ToMult
1505 AAEA 18                    clc   
1506 AAEB A5 0B                 lda   Second                   ; now add in seconds
1507 AAED 29 FF 00              and   #$00FF
1508 AAF0 63 01                 adc   1,s
1509 AAF2 83 01                 sta   1,s
1510 AAF4 A9 00 00              lda   #0
1511 AAF7 63 03                 adc   3,s
1512 AAF9 83 03                 sta   3,s
1513 AAFB 68                    pla                            ; and store in D0
1514 AAFC 8D E9 03              sta   |D0
1515 AAFF 68                    pla   
1516 AB00 8D EB 03              sta   |D0+2
1517 AB03              *
1518 AB03              * Compute DAYSGONE in D1
1519 AB03              *
1520 AB03 A5 0F                 lda   Day                      ; Days
1521 AB05 29 FF 00              and   #$00FF                   ; have day (0.......30)
1522 AB08 8D ED 03              sta   |D1
1523 AB0B 9C EF 03              stz   |D1+2
1524 AB0E A5 10                 lda   Month                    ; get Month
1525 AB10 29 FF 00              and   #$00FF                   ; have Month (0.....11)
1526 AB13 1A                    inc   a                        ; make Month (1.....12)
1527 AB14 8D F1 03              sta   |D2
1528 AB17 9C F3 03              stz   |D2+2
1529 AB1A A5 0E                 lda   Year                     ; and Year
1530 AB1C 29 FF 00              and   #$00FF
1531 AB1F 18                    clc   
1532 AB20 69 6C 07              adc   #1900
1533 AB23 8D F5 03              sta   |D3
1534 AB26 8D F9 03              sta   |D4                      ; copy year for LEAP test
1535 AB29 9C F7 03              stz   |D3+2
1536 AB2C 9C FB 03              stz   |D4+2
1537 AB2F              *
1538 AB2F              * To find number of	days in elapsed years use:
1539 AB2F              *     ((YEARSGONE *	1461) + 3) div 4
1540 AB2F              * Formula depends on leap year being the first of 4.
1541 AB2F              *
1542 AB2F 38                    sec                            ; years gone
1543 AB30 AD F5 03              lda   |D3
1544 AB33 E9 70 07              sbc   #1904
1545 AB36 8D F5 03              sta   |D3
1546 AB39 F4 00 00              pea   $0000                    ; space for result
1547 AB3C F4 00 00              pea   $0000
1548 AB3F 48                    pha                            ; YearsGone * 1461
1549 AB40 F4 B5 05              pea   $05B5
1550 AB43 22 31 AC FE           jsl   ToMult
1551 AB47 18                    clc   
1552 AB48 A9 03 00              lda   #3                       ; (YearsGone * 1461) + 3
1553 AB4B 63 01                 adc   1,s
1554 AB4D 83 01                 sta   1,s
1555 AB4F A9 00 00              lda   #0
1556 AB52 63 03                 adc   3,s
1557 AB54 4A                    lsr   a                        ; ((YG * 1461) + 3) div 4
1558 AB55 83 03                 sta   3,s
1559 AB57 A3 01                 lda   1,s
1560 AB59 6A                    ror   a
1561 AB5A 83 01                 sta   1,s
1562 AB5C A3 03                 lda   3,s
1563 AB5E 4A                    lsr   a
1564 AB5F 83 03                 sta   3,s
1565 AB61 8D F7 03              sta   |D3+2
1566 AB64 A3 01                 lda   1,s
1567 AB66 6A                    ror   a
1568 AB67 83 01                 sta   1,s
1569 AB69 8D F5 03              sta   |D3
1570 AB6C 68                    pla                            ; accumulate days gone
1571 AB6D 18                    clc   
1572 AB6E 6D ED 03              adc   |D1
1573 AB71 8D ED 03              sta   |D1
1574 AB74 68                    pla   
1575 AB75 6D EF 03              adc   |D1+2
1576 AB78 8D EF 03              sta   |D1+2                    ; D1 = DAYSGONE
1577 AB7B              *
1578 AB7B              * As above, the tough part is finding the number of days in
1579 AB7B              * elapsed months.
1580 AB7B              *
1581 AB7B CE F1 03              dec   |D2                      ; month-1 (ranges 0..11)
1582 AB7E AD F1 03              lda   |D2                      ; 2 or more is March
1583 AB81 C9 02 00              cmp   #2
1584 AB84 90 21                 blt   DSJanFeb
1585 AB86
1586 AB86 CE F1 03              dec   |D2                      ; Month-3 (Restart at March)
1587 AB89 CE F1 03              dec   |D2
1588 AB8C A9 3B 00              lda   #59                      ; Days in Jan + Feb
1589 AB8F 8D F5 03              sta   |D3
1590 AB92 AD F9 03              lda   |D4                      ; Check for leap year, MOD 3
1591 AB95 29 03 00              and   #3
1592 AB98 D0 03                 bne   DSNotLeap                ; if not leap year
1593 AB9A EE F5 03              inc   |D3                      ; Leap Days in Jan + Feb
1594 AB9D
1595 AB9D              DSNotLeap                               ; 
1596 AB9D 18                    clc   
1597 AB9E AD F5 03              lda   |D3                      ; some more elapsed days
1598 ABA1 6D ED 03              adc   |D1
1599 ABA4 8D ED 03              sta   |D1
1600 ABA7
1601 ABA7              DSJanFeb                                ; 
1602 ABA7 F4 00 00              pea   $0000                    ; space for result
1603 ABAA F4 00 00              pea   $0000
1604 ABAD AD F1 03              lda   |D2                      ; Month * 3917
1605 ABB0 48                    pha   
1606 ABB1 A9 4D 0F              lda   #3917
1607 ABB4 48                    pha   
1608 ABB5 22 31 AC FE           jsl   ToMult
1609 ABB9 18                    clc   
1610 ABBA A9 34 00              lda   #52                      ; (Month * 3917) + 52
1611 ABBD 63 01                 adc   1,s
1612 ABBF 83 01                 sta   1,s
1613 ABC1 A9 00 00              lda   #0
1614 ABC4 63 03                 adc   3,s
1615 ABC6 83 03                 sta   3,s
1616 ABC8 68                    pla   
1617 ABC9 8D F1 03              sta   |D2
1618 ABCC 68                    pla   
1619 ABCD 8D F3 03              sta   |D2+2
1620 ABD0 A0 07 00              ldy   #7                       ; ((Month * 3917) + 52 div 128
1621 ABD3              Div128                                  ; 
1622 ABD3 4E F3 03              lsr   |D2+2
1623 ABD6 6E F1 03              ror   |D2
1624 ABD9 88                    dey   
1625 ABDA D0 F7                 bne   Div128
1626 ABDC 18                    clc   
1627 ABDD AD ED 03              lda   |D1                      ; more elapsed days
1628 ABE0 6D F1 03              adc   |D2
1629 ABE3 8D ED 03              sta   |D1
1630 ABE6 AD EF 03              lda   |D1+2
1631 ABE9 6D F3 03              adc   |D2+2
1632 ABEC 8D EF 03              sta   |D1+2
1633 ABEF              *
1634 ABEF              * Finally multiply the number of days elapsed by
1635 ABEF              * 24 * 60 * 60 = 86400 = 43200 * 2
1636 ABEF              *
1637 ABEF F4 00 00              pea   $0000                    ; space for result
1638 ABF2 F4 00 00              pea   $0000
1639 ABF5 F4 C0 A8              pea   $A8C0                    ; (43200)
1640 ABF8 AD ED 03              lda   |D1
1641 ABFB 48                    pha   
1642 ABFC 22 31 AC FE           jsl   ToMult
1643 AC00 A3 01                 lda   1,s                      ; (43200 * 2)
1644 AC02 0A                    asl   a
1645 AC03 83 01                 sta   1,s
1646 AC05 A3 03                 lda   3,s
1647 AC07 2A                    rol   a
1648 AC08 83 03                 sta   3,s
1649 AC0A 18                    clc   
1650 AC0B 68                    pla   
1651 AC0C 6D E9 03              adc   |D0
1652 AC0F 8D E5 03              sta   |ClkWData                ; store to set time
1653 AC12 68                    pla   
1654 AC13 6D EB 03              adc   |D0+2
1655 AC16 8D E7 03              sta   |ClkWData+2
1656 AC19 E2 30                 sep   #$30                     ; off to 8 bit land
1657 AC1B 22 88 00 E1           jsl   ToWriteTime              ; set the clock
1658 AC1F C2 30                 rep   #$30                     ; back to 16 bit land
1659 AC21 2B                    pld                            ; restore direct page
1660 AC22 AB                    plb                            ; restore data area
1661 AC23 2A                    rol   a                        ; save carry
1662 AC24 28                    plp                            ; restore interrupt state
1663 AC25 6A                    ror   a                        ; and restore carry
1664 AC26 B0 03                 bcs   WrHexErr                 ; if can't write time
1665 AC28 4C 23 FC              jmp   oEndCall6                ; else cleanup & return
1666 AC2B
1667 AC2B              WrHexErr                                ; 
1668 AC2B A2 07 03              ldx   #firmTaskErr             ; set error flag
1669 AC2E 4C 28 FC              jmp   oErrOut6                 ; and return with error
1670 AC31
1671 AC31                       ENTRY ToMult 
1672 AC31              ToMult                                  ;       
1673 AC31 22 05 F1 FE           jsl   Multiply
1674 AC35 6B                    rtl   
1675 AC36
1676 AC36              MonthLen                                ; 
1677 AC36 1F                    DC B:31                        ; days in January
1678 AC37 1C                    DC B:28                        ; days in Febuary (non-leap)
1679 AC38 1F                    DC B:31                        ; days in March
1680 AC39 1E                    DC B:30                        ; days in April
1681 AC3A 1F                    DC B:31                        ; days in May
1682 AC3B 1E                    DC B:30                        ; days in June
1683 AC3C 1F                    DC B:31                        ; days in July
1684 AC3D 1F                    DC B:31                        ; days in August
1685 AC3E 1E                    DC B:30                        ; days in September
1686 AC3F 1F                    DC B:31                        ; days in October
1687 AC40 1E                    DC B:30                        ; days in November
1688 AC41 1F                    DC B:31                        ; days in December
1689 AC42 1D                    DC B:29                        ; days in February (leap)
1690 AC43
1691 AC43                       ENDP 
1692 AC43
1693 AC43
1694 AC43              ****************************************************************
1695 AC43              *
1696 AC43              * RdATime:
1697 AC43              *
1698 AC43              *     Input     LongWord     Buffer address
1699 AC43              *
1700 AC43              * Format of data in buffer is dependent on the values set
1701 AC43              * in the battery ram for time and date format.
1702 AC43              *
1703 AC43              * Date Format   Time Format  ASCII Format
1704 AC43              * -----------   -----------  -----------------------
1705 AC43              *     0              0       mm/dd/yy HH:MM:SS AM-PM
1706 AC43              *     1              0       dd/mm/yy HH:MM:SS AM-PM
1707 AC43              *     2              0       yy/mm/dd HH:MM:SS AM-PM
1708 AC43              *     0              1       mm/dd/yy HH:MM:SS
1709 AC43              *     1              1       dd/mm/yy HH:MM:SS
1710 AC43              *     2              1       yy/mm/dd HH:MM:SS
1711 AC43              *
1712 AC43              * where :      HH = Hour
1713 AC43              *              MM = Minute
1714 AC43              *              SS = Second
1715 AC43              *              mm = Month
1716 AC43              *              dd = Day
1717 AC43              *              yy = Year
1718 AC43              *
1719 AC43              ****************************************************************
1720 AC43
1721 AC43              RdATime  PROC 
1722 AC43
1723 AC43              OrigDir  equ   1
1724 AC43              OrigDBR  equ   OrigDir+2
1725 AC43              rtl1     equ   OrigDBR+1
1726 AC43              rtl2     equ   rtl1+3
1727 AC43              pointer  equ   rtl2+3
1728 AC43
1729 AC43              NewDir   equ   1
1730 AC43              Second   equ   NewDir+2
1731 AC43              Minute   equ   Second+1
1732 AC43              Hour     equ   Minute+1
1733 AC43              Year     equ   Hour+1
1734 AC43              Day      equ   Year+1
1735 AC43              Month    equ   Day+1
1736 AC43              Null     equ   Month+1
1737 AC43              WkDay    equ   Null+1
1738 AC43
1739 AC43 8B                    phb                            ; save data area
1740 AC44 0B                    phd                            ; save direct page
1741 AC45 3B                    tsc                            ; turn stack into zp
1742 AC46 5B                    tcd   
1743 AC47 F4 00 00              pea   $0000                    ; setup for RdHexTime
1744 AC4A F4 00 00              pea   $0000
1745 AC4D F4 00 00              pea   $0000
1746 AC50 F4 00 00              pea   $0000
1747 AC53 22 47 AD FE           jsl   ToRdHexT                 ; now go get it
1748 AC57 90 03                 bcc   NoAtimeErr               ; if no error
1749 AC59 4C 3B AD              jmp   ATimeErr                 ; if can't get it
1750 AC5C
1751 AC5C              *
1752 AC5C              * Now convert HEX time to ascii time and send to buffer
1753 AC5C              *
1754 AC5C
1755 AC5C              NoAtimeErr                              ; 
1756 AC5C A6 0A                 ldx   Pointer                  ; get pointer to App. Buffer
1757 AC5E E2 20                 sep   #$20                     ; 8 bit 'm'
1758 AC60                       longa off
1759 AC60 A5 0C                 lda   Pointer+2
1760 AC62 48                    pha                            ; set App. Buffer bank
1761 AC63 AB                    plb   
1762 AC64 0B                    phd                            ; save new dir
1763 AC65 3B                    tsc                            ; and make stack into zp
1764 AC66 5B                    tcd   
1765 AC67 A9 A0                 lda   #$A0                     ; time/date delimiter
1766 AC69 9D 08 00              sta   |8,x
1767 AC6C 9D 11 00              sta   |17,x
1768 AC6F AF F5 02 E1           lda   >UserAMPM                ; get time format
1769 AC73 C2 20                 rep   #$20                     ; 16 bit 'm'
1770 AC75                       longa on
1771 AC75 08                    php                            ; time format in Z flag
1772 AC76 A0 A0 A0              ldy   #$A0A0                   ; assume 24 hour format
1773 AC79 A5 05                 lda   Hour                     ; get hour
1774 AC7B 28                    plp                            ; Z=1 says 12 hour format
1775 AC7C D0 21                 bne   Fmt24                    ; else 24 hour format
1776 AC7E A0 C1 CD              ldy   #$CDC1                   ; assume AM
1777 AC81 29 FF 00              and   #$00FF                   ; truncate hour
1778 AC84 C9 0C 00              cmp   #12                      ; hour less than 12?
1779 AC87 90 03                 blt   StillAM                  ; if yes, then still AM
1780 AC89 A0 D0 CD              ldy   #$CDD0                   ; else set PM
1781 AC8C              StillAM                                 ; 
1782 AC8C C9 0D 00              cmp   #13                      ; if > 13:00 then subtract 12
1783 AC8F 90 06                 blt   H0TO12                   ; yes
1784 AC91 38                    sec                            ; else hour=hour-12
1785 AC92 E9 0C 00              sbc   #12
1786 AC95 80 08                 bra   Fmt24
1787 AC97              H0TO12                                  ; 
1788 AC97 C9 00 00              cmp   #0                       ; if zero, make it 12
1789 AC9A D0 03                 bne   Fmt24                    ; but if its not, dont
1790 AC9C A9 0C 00              lda   #12                      ;
1791 AC9F              Fmt24                                   ; 
1792 AC9F 20 4C AD              jsr   HexToAscii               ; convert hour to ascii
1793 ACA2 9D 09 00              sta   |9,x                     ; stuff into App. Buffer
1794 ACA5 98                    tya                            ; now set time format
1795 ACA6 9D 12 00              sta   |18,x
1796 ACA9 A5 04                 lda   Minute                   ; convert minute
1797 ACAB 20 4C AD              jsr   HexToAscii
1798 ACAE 9D 0C 00              sta   |12,x                    ; stuff into App. buffer
1799 ACB1 A5 03                 lda   Second                   ; convert seconds
1800 ACB3 20 4C AD              jsr   HexToAscii
1801 ACB6 9D 0F 00              sta   |15,x                    ; stuff into app. buffer
1802 ACB9 A5 08                 lda   Month                    ; convert month
1803 ACBB 1A                    inc   a                        ; 0=Jan
1804 ACBC 20 4C AD              jsr   HexToAscii
1805 ACBF 9D 00 00              sta   |0,x                     ; stuff into app. buffer
1806 ACC2 A5 07                 lda   Day                      ; convert day
1807 ACC4 1A                    inc   a                        ; 0=first day of month
1808 ACC5 20 4C AD              jsr   HexToAscii
1809 ACC8 9D 03 00              sta   |3,x                     ; stuff into app. buffer
1810 ACCB A5 06                 lda   Year                     ; convert Year
1811 ACCD 20 4C AD              jsr   HexToAscii
1812 ACD0 9D 06 00              sta   |6,x                     ; stuff into app. buffer
1813 ACD3 E2 20                 sep   #$20                     ; 8 bit 'm'
1814 ACD5                       longa off
1815 ACD5 A9 BA                 lda   #$BA                     ; time delimiter
1816 ACD7 9D 0B 00              sta   |11,x
1817 ACDA 9D 0E 00              sta   |14,x
1818 ACDD A9 AF                 lda   #$AF                     ; date delimiter
1819 ACDF 9D 02 00              sta   |2,x
1820 ACE2 9D 05 00              sta   |5,x
1821 ACE5              *
1822 ACE5              * Now blank all leading zeros
1823 ACE5              *
1824 ACE5 A0 A0 00              ldy   #$A0                     ; Yreg = ' '
1825 ACE8 BD 09 00              lda   |9,x                     ; first check hours
1826 ACEB C9 B0                 cmp   #$B0                     ; is it a zero ?
1827 ACED D0 04                 bne   NoHrsZ                   ; no
1828 ACEF 98                    tya   
1829 ACF0 9D 09 00              sta   |9,x                     ; blank leading zero
1830 ACF3              NoHrsZ                                  ; 
1831 ACF3 BD 00 00              lda   |0,x                     ; now check month
1832 ACF6 C9 B0                 cmp   #$B0                     ; is it a zero ?
1833 ACF8 D0 04                 bne   NoMoZ                    ; no
1834 ACFA 98                    tya   
1835 ACFB 9D 00 00              sta   |0,x                     ; else blank leading zero
1836 ACFE              NoMoZ                                   ; 
1837 ACFE BD 03 00              lda   |3,x                     ; now check day
1838 AD01 C9 B0                 cmp   #$B0                     ; is it a zero ?
1839 AD03 D0 04                 bne   NoDayZ                   ; no
1840 AD05 98                    tya                            ; else blank leading zero
1841 AD06 9D 03 00              sta   |3,x
1842 AD09              NoDayZ                                  ; 
1843 AD09 AF F4 02 E1           lda   >UserDATE                ; get DATE format
1844 AD0D C2 20                 rep   #$20                     ; 16 bit 'm'
1845 AD0F                       longa on
1846 AD0F F0 20                 beq   DateFmt0                 ; mm/dd/yy HH:MM:SS
1847 AD11 29 FF 00              and   #$00FF                   ; limit options
1848 AD14 48                    pha   
1849 AD15 BD 03 00              lda   |3,x                     ; swap month and year
1850 AD18 A8                    tay                            ; Yreg = dd
1851 AD19 BD 00 00              lda   |0,x
1852 AD1C 9D 03 00              sta   |3,x
1853 AD1F 98                    tya   
1854 AD20 9D 00 00              sta   |0,x                     ; dd/mm/yy
1855 AD23 68                    pla   
1856 AD24 3A                    dec   a                        ; format 2?
1857 AD25 F0 0A                 beq   DateFmt0                 ; no
1858 AD27 BD 06 00              lda   |6,x                     ; now swap year and day
1859 AD2A 9D 00 00              sta   |0,x
1860 AD2D 98                    tya   
1861 AD2E 9D 06 00              sta   |6,x
1862 AD31              DateFmt0                                ; 
1863 AD31 2B                    pld                            ; clean up stack
1864 AD32 68                    pla   
1865 AD33 68                    pla   
1866 AD34 68                    pla   
1867 AD35 68                    pla   
1868 AD36 2B                    pld                            ; restore direct page
1869 AD37 AB                    plb                            ; and data area
1870 AD38 4C 0D FC              jmp   oEndCall4                ; clean up and return
1871 AD3B
1872 AD3B              ATimeErr                                ; 
1873 AD3B 68                    pla                            ; clean up stack
1874 AD3C 68                    pla   
1875 AD3D 68                    pla   
1876 AD3E 68                    pla   
1877 AD3F 2B                    pld                            ; restore direct page
1878 AD40 AB                    plb                            ; restore DBR
1879 AD41 A2 07 03              ldx   #firmTaskErr             ; set error flag
1880 AD44 4C 12 FC              jmp   oErrOut4                 ; and return with error
1881 AD47
1882 AD47              ToRdHexT                                ; 
1883 AD47 22 D2 A8 FE           jsl   RdTimeHex                ; go read HEX time
1884 AD4B 6B                    rtl   
1885 AD4C
1886 AD4C                       ENDP 
1887 AD4C
1888 AD4C              ****************************************************************
1889 AD4C              *
1890 AD4C              * Convert Hex to Ascii
1891 AD4C              *
1892 AD4C              * Input passed in low byte of 16 bit A register
1893 AD4C              * Output returned in 16 bit A register (Most significant in
1894 AD4C              * digit is in low byte of register.  Both the X and Y registers
1895 AD4C              * are preserved.
1896 AD4C              *
1897 AD4C              ****************************************************************
1898 AD4C
1899 AD4C              HexToAscii PROC 
1900 AD4C
1901 AD4C              OrigDir  equ   1
1902 AD4C              OrigY    equ   OrigDir+2
1903 AD4C              OrigX    equ   OrigY+2
1904 AD4C              Decimal  equ   OrigX+2
1905 AD4C
1906 AD4C 48                    pha                            ; input data to convert
1907 AD4D DA                    phx                            ; save App. buffer pointer
1908 AD4E 5A                    phy                            ; and this too!!!
1909 AD4F 0B                    phd                            ; save direct page
1910 AD50 3B                    tsc                            ; turn stack into zp
1911 AD51 5B                    tcd   
1912 AD52 E2 30                 sep   #$30                     ; 8 bit 'm' and 'x'
1913 AD54                       longa off
1914 AD54                       longi off
1915 AD54 A0 02                 ldy   #$02                     ; number of times through loop
1916 AD56              DecAsc1                                 ; 
1917 AD56 A2 09                 ldx   #9                       ; 8 bit and 1st time do nothing
1918 AD58 A9 00                 lda   #0
1919 AD5A 18                    clc                            ; C=0 so 1st ROL leaves A=0
1920 AD5B              DecAsc2                                 ; 
1921 AD5B 2A                    rol   a
1922 AD5C C9 0A                 cmp   #10                      ; A >= 10 ?
1923 AD5E 90 02                 blt   DecAsc4                  ; if <
1924 AD60 E9 0A                 sbc   #10                      ; C=1 from CMP and is left set
1925 AD62              DecAsc4                                 ; 
1926 AD62 26 07                 rol   Decimal
1927 AD64 CA                    dex   
1928 AD65 D0 F4                 bne   DecAsc2
1929 AD67 09 B0                 ora   #$B0                     ; make an ASCII character
1930 AD69 48                    pha                            ; preserve on stack
1931 AD6A 88                    dey   
1932 AD6B D0 E9                 bne   DecAsc1
1933 AD6D C2 30                 rep   #$30                     ; 16 bit 'm' and 'x'
1934 AD6F                       longa on
1935 AD6F                       longi on
1936 AD6F 68                    pla                            ; returned data
1937 AD70 85 07                 sta   Decimal
1938 AD72 2B                    pld                            ; clean up and r
1939 AD73 7A                    ply                            ; restore pointer
1940 AD74 FA                    plx                            ; restore App. buffer pointer
1941 AD75 68                    pla                            ; returned data in A reg
1942 AD76 60                    rts   
1943 AD77
1944 AD77                       ENDP 
1945 AD77
1946 AD77                       title 'Vector Routines'
1947 AD77              ****************************************************************
1948 AD77              *
1949 AD77              * SetVector     (RefNum : integer; NewAdr : Long);
1950 AD77              *
1951 AD77              * Change History
1952 AD77              *
1953 AD77              * 26 Jul 88	Steven Glass
1954 AD77              *
1955 AD77              * Interrupts disabled during access.
1956 AD77              *
1957 AD77              * 23 Feb 89	Mensch
1958 AD77              *
1959 AD77              * Removed error checking.
1960 AD77              ****************************************************************
1961 AD77              SetVector PROC 
1962 AD77
1963 AD77              RTL1     equ   1
1964 AD77              RTL2     equ   RTL1+3
1965 AD77              NewAdr   equ   RTL2+3
1966 AD77              RefNum   equ   NewAdr+4
1967 AD77
1968 AD77              VTblLen  equ   $002D
1969 AD77
1970 AD77 A3 0B                 lda   RefNum,s                 ;get reference
1971 AD79 29 FF 00              and   #$00FF                   ;mask excess
1972 AD7C
1973 AD7C              ; Error checking removed 2/23/89
1974 AD7C              ;	cmp	#VTblLen
1975 AD7C              ;	bge	AnError	;if out of bounds
1976 AD7C
1977 AD7C 0A                    asl   a                        ;and make index
1978 AD7D 0A                    asl   a
1979 AD7E AA                    tax   
1980 AD7F
1981 AD7F 08                    php   
1982 AD80 78                    sei   
1983 AD81
1984 AD81 A3 07                 lda   NewAdr-1+1,s             ;get vector addr 0-7
1985 AD83 29 00 FF              and   #$FF00                   ;patch 'JML' opcode in low byte
1986 AD86 09 5C 00              ora   #$005C
1987 AD89 9F 00 00 E1           sta   >Dispatch1,x             ;set A0-7 & op
1988 AD8D A3 09                 lda   NewAdr+1+1,s             ;get addr 8-23
1989 AD8F 9F 02 00 E1           sta   >Dispatch1+2,x           ;set addr 8-23
1990 AD93
1991 AD93
1992 AD93 28                    plp   
1993 AD94 4C 23 FC              jmp   oEndCall6
1994 AD97
1995 AD97
1996 AD97 A2 01 03     AnError  ldx   #badInputErr
1997 AD9A 4C 28 FC              jmp   oErrOut6
1998 AD9D
1999 AD9D                       ENDP 
2000 AD9D
2001 AD9D
2002 AD9D              ****************************************************************
2003 AD9D              *
2004 AD9D              * GetVector     (RefNum : integer; NewAdr : Long);
2005 AD9D              *
2006 AD9D              * Change History
2007 AD9D              *
2008 AD9D              * 26 Jul 88	Steven Glass
2009 AD9D              *
2010 AD9D              * Interrupts disabled during access.
2011 AD9D              *
2012 AD9D              * 23 Feb 89	Mensch
2013 AD9D              *
2014 AD9D              * Removed error checking.
2015 AD9D              ****************************************************************
2016 AD9D              GetVector PROC 
2017 AD9D
2018 AD9D              RTL1     equ   1
2019 AD9D              RTL2     equ   RTL1+3
2020 AD9D              RefNum   equ   RTL2+3
2021 AD9D              Result   equ   RefNum+2
2022 AD9D
2023 AD9D              VTblLen  equ   $002D
2024 AD9D
2025 AD9D A3 07                 lda   RefNum,s                 ;get reference
2026 AD9F 29 FF 00              and   #$00FF                   ;mask excess
2027 ADA2
2028 ADA2              ; Error checking removed 2/23/89
2029 ADA2              ;	cmp	#VTblLen
2030 ADA2              ;	bge	AnError	;if out of bounds
2031 ADA2
2032 ADA2 0A                    asl   a                        ;and make index
2033 ADA3 0A                    asl   a
2034 ADA4 AA                    tax   
2035 ADA5
2036 ADA5 08                    php   
2037 ADA6 78                    sei   
2038 ADA7
2039 ADA7 BF 01 00 E1           lda   >Dispatch1+1,x
2040 ADAB 83 0A                 sta   Result+1,s
2041 ADAD BF 03 00 E1           lda   >Dispatch1+3,x
2042 ADB1 29 FF 00              and   #$00FF
2043 ADB4 83 0C                 sta   Result+2+1,s
2044 ADB6
2045 ADB6 28                    plp   
2046 ADB7
2047 ADB7 4C F7 FB              jmp   oEndCall2
2048 ADBA
2049 ADBA
2050 ADBA A2 01 03     AnError  ldx   #badInputErr
2051 ADBD 4C FC FB              jmp   oErrOut2
2052 ADC0
2053 ADC0                       ENDP 
2054 ADC0
2055 ADC0                       title 'Heartbeat Routines'
2056 ADC0              ****************************************************************
2057 ADC0              *
2058 ADC0              * Set System Heartbeat Vector
2059 ADC0              *   Input     LongWord     Address
2060 ADC0              *
2061 ADC0              * Possible errors are :
2062 ADC0              *     3 = Task error     (task already in queue)
2063 ADC0              *     4 = Header error   (no signature in new task)
2064 ADC0              *     5 = Queue error    (queue got trashed - system fatal)
2065 ADC0              *     6 = Task Not Found
2066 ADC0              *
2067 ADC0              ****************************************************************
2068 ADC0              SetHeart PROC 
2069 ADC0
2070 ADC0              OrigD    equ   1
2071 ADC0              RTL1     equ   OrigD+2
2072 ADC0              RTL2     equ   RTL1+3
2073 ADC0              VPtr     equ   RTL2+3
2074 ADC0
2075 ADC0 0B                    phd   
2076 ADC1 3B                    tsc                            ; make stack into zp
2077 ADC2 5B                    tcd   
2078 ADC3 08                    php                            ; save IRQ enbl status
2079 ADC4 78                    sei                            ; 'cuz no interrupts for now !
2080 ADC5 A9 AC AF              lda   #Irq_Heart               ; install heartbeat handler
2081 ADC8 48                    pha   
2082 ADC9 EB                    xba   
2083 ADCA 29 00 FF              and   #$FF00
2084 ADCD 09 5C 00              ora   #$005C                   ; opcode = jmp al
2085 ADD0 8F 30 00 E1           sta   >Irq_VBL                 ; install JMP opcode and addrl
2086 ADD4 68                    pla   
2087 ADD5 29 00 FF              and   #$FF00
2088 ADD8 09 FE 00              ora   #^Irq_Heart
2089 ADDB EB                    xba   
2090 ADDC 8F 32 00 E1           sta   >Irq_VBL+2               ; install addrm & addrh
2091 ADE0 8B                    phb   
2092 ADE1 E2 20                 sep   #$20                     ; 8 bit 'm'
2093 ADE3 A5 0B                 lda   Vptr+2                   ; make pointer to task header
2094 ADE5 48                    pha   
2095 ADE6 AB                    plb   
2096 ADE7 C2 30                 rep   #$30                     ; 16 bit 'm'
2097 ADE9 A5 09                 lda   Vptr
2098 ADEB AA                    tax   
2099 ADEC BD 06 00              lda   |6,x                     ; check task header signature
2100 ADEF C9 5A A5              cmp   #$A55A
2101 ADF2 F0 06                 beq   QueOK                    ; no problem with new task
2102 ADF4              BadQue                                  ; 
2103 ADF4 A2 04 03              ldx   #$0304                   ; flag bad queue signature
2104 ADF7 82 75 00              brl   HdrErr
2105 ADFA              QueOK                                   ; 
2106 ADFA AF D8 00 E1           lda   >HBptr                   ; check if task in queue
2107 ADFE C5 09                 cmp   Vptr
2108 AE00 D0 0D                 bne   DoFirst                  ; if not, install it
2109 AE02 AF DA 00 E1           lda   >HBptr+2
2110 AE06 C5 0B                 cmp   Vptr+2
2111 AE08 D0 05                 bne   DoFirst
2112 AE0A A2 03 03              ldx   #taskInstlErr            ; else flag task error
2113 AE0D 80 60                 bra   HdrErr
2114 AE0F              DoFirst                                 ; 
2115 AE0F AF D8 00 E1           lda   >HBptr                   ; get heartbeat vector
2116 AE13 0F DA 00 E1           ora   >HBptr+2                 ; is it the first one
2117 AE17 D0 29                 bne   GrowChain                ; nope
2118 AE19 A5 09                 lda   VPtr                     ; get addrl
2119 AE1B 8F D8 00 E1           sta   >HBptr                   ; set the first one
2120 AE1F A5 0B                 lda   VPtr+2
2121 AE21 8F DA 00 E1           sta   >HBptr+2
2122 AE25 E2 20                 sep   #$20                     ; 8 bit m
2123 AE27 AF DA 00 E1           lda   >HBptr+2                 ; point at next entry
2124 AE2B 48                    pha   
2125 AE2C AB                    plb   
2126 AE2D C2 20                 rep   #$20                     ; 16 bit m
2127 AE2F AF D8 00 E1           lda   >HBptr
2128 AE33 AA                    tax   
2129 AE34
2130 AE34              SetLast                                 ; 
2131 AE34 A9 00 00              lda   #0
2132 AE37 9D 00 00              sta   |0,x                     ; set last link flag
2133 AE3A 9D 02 00              sta   |2,x
2134 AE3D
2135 AE3D              ExitHB                                  ; 
2136 AE3D AB                    plb   
2137 AE3E 28                    plp                            ;
2138 AE3F 4C 0E FC              jmp   EndCall4
2139 AE42
2140 AE42              GrowChain                               ; 
2141 AE42 E2 20                 sep   #$20                     ; 8 bit m
2142 AE44 AF DA 00 E1           lda   >HBptr+2                 ; point at first entry
2143 AE48 48                    pha   
2144 AE49 AB                    plb   
2145 AE4A C2 20                 rep   #$20                     ; 16 bit m
2146 AE4C AF D8 00 E1           lda   >HBptr
2147 AE50 AA                    tax   
2148 AE51
2149 AE51              ChkChain                                ; 
2150 AE51 BD 06 00              lda   |6,x                     ; check queue signature
2151 AE54 C9 5A A5              cmp   #$A55A
2152 AE57 F0 05                 beq   QueueOK                  ; no problem
2153 AE59 A2 05 00              ldx   #5                       ; else flag queue trashed
2154 AE5C 80 11                 bra   HdrErr
2155 AE5E              QueueOK                                 ; 
2156 AE5E BD 00 00              lda   |0,x                     ; check if task already exists
2157 AE61 C5 09                 cmp   vptr
2158 AE63 D0 0F                 bne   taskok                   ; it's not the same task
2159 AE65 BD 02 00              lda   |2,x
2160 AE68 C5 0B                 cmp   vptr+2
2161 AE6A D0 08                 bne   taskok                   ; it's not the same task
2162 AE6C
2163 AE6C A2 03 03              ldx   #taskInstlErr            ; task error
2164 AE6F              HdrErr                                  ; 
2165 AE6F AB                    plb                            ; clean up stack
2166 AE70 28                    plp   
2167 AE71 4C 11 FC              jmp   ErrOut4
2168 AE74
2169 AE74              TaskOK                                  ; 
2170 AE74 BD 00 00              lda   |0,x                     ; is this the end of the queue
2171 AE77 1D 02 00              ora   |2,x
2172 AE7A F0 0F                 beq   GrowHere                 ; yes, now insert next task
2173 AE7C E2 20                 sep   #$20                     ; 8 bit 'm' to move down queue
2174 AE7E BD 02 00              lda   |2,x                     ; point at next one
2175 AE81 48                    pha   
2176 AE82 C2 20                 rep   #$20                     ; 16 bit m
2177 AE84 BD 00 00              lda   |0,x
2178 AE87 AA                    tax   
2179 AE88 AB                    plb   
2180 AE89 80 C6                 bra   ChkChain                 ; search for last one
2181 AE8B
2182 AE8B              GrowHere                                ; 
2183 AE8B A5 0B                 lda   vptr+2                   ; insert link address
2184 AE8D 9D 02 00              sta   |2,x
2185 AE90 A5 09                 lda   vptr
2186 AE92 9D 00 00              sta   |0,x
2187 AE95 AA                    tax                            ; point at next link
2188 AE96 E2 20                 sep   #$20                     ; 8 bit m
2189 AE98                       longa off
2190 AE98 A5 0B                 lda   Vptr+2
2191 AE9A 48                    pha   
2192 AE9B AB                    plb   
2193 AE9C C2 20                 rep   #$20                     ; 16 bit m
2194 AE9E                       longa on
2195 AE9E 80 94                 bra   SetLast                  ; set last link flag
2196 AEA0
2197 AEA0                       ENDP 
2198 AEA0
2199 AEA0
2200 AEA0
2201 AEA0              ****************************************************************
2202 AEA0              *
2203 AEA0              * Delete System Heartbeat Vector
2204 AEA0              *   Input     LongWord     Address
2205 AEA0              *
2206 AEA0              * Change History
2207 AEA0              *
2208 AEA0              * 26 Jul 88	Steven Glass
2209 AEA0              *
2210 AEA0              * Try and turn off vbl interrupts.
2211 AEA0              *
2212 AEA0              ****************************************************************
2213 AEA0              DelHeart PROC 
2214 AEA0                       import KillIntsIfCan 
2215 AEA0
2216 AEA0              OrigDir  equ   1
2217 AEA0              RTL1     equ   OrigDir+2
2218 AEA0              RTL2     equ   RTL1+3
2219 AEA0              Vptr     equ   RTL2+3
2220 AEA0
2221 AEA0 0B                    phd   
2222 AEA1 3B                    tsc                            ; turn stack into zp
2223 AEA2 5B                    tcd   
2224 AEA3 08                    php                            ; save interrupt enable status
2225 AEA4 78                    sei                            ; no interrupts for now
2226 AEA5 8B                    phb   
2227 AEA6 E2 20                 sep   #$20                     ; 8 bit m
2228 AEA8                       longa off
2229 AEA8 A9 E1                 lda   #^HBptr                  ; point at link addr
2230 AEAA 48                    pha   
2231 AEAB AB                    plb   
2232 AEAC C2 20                 rep   #$20                     ; 16 bit m
2233 AEAE                       longa on
2234 AEAE A2 D8 00              ldx   #HBptr**$FFFF
2235 AEB1 BD 00 00              lda   |0,x                     ; is queue empty ?
2236 AEB4 1D 02 00              ora   |2,x
2237 AEB7 F0 2E                 beq   DelErr0
2238 AEB9 C2 20                 rep   #$20                     ; 16 bit 'm'
2239 AEBB BD 00 00              lda   |0,x                     ; is the first one it ?
2240 AEBE C5 09                 cmp   vptr
2241 AEC0 D0 27                 bne   notfirst
2242 AEC2 E2 20                 sep   #$20                     ; 8 bit 'm'
2243 AEC4 BD 02 00              lda   |2,x
2244 AEC7 C5 0B                 cmp   vptr+2
2245 AEC9 D0 1E                 bne   notfirst
2246 AECB 8B                    phb                            ; save current queue pointer
2247 AECC DA                    phx   
2248 AECD 48                    pha   
2249 AECE C2 20                 rep   #$20                     ; 16 bit 'm'
2250 AED0 BD 00 00              lda   |0,x                     ; point at task
2251 AED3 AA                    tax   
2252 AED4 AB                    plb   
2253 AED5 BD 02 00              lda   |2,x                     ; get task's link pointer
2254 AED8 A8                    tay   
2255 AED9 BD 00 00              lda   |0,x
2256 AEDC FA                    plx                            ; restore queue pointer
2257 AEDD AB                    plb   
2258 AEDE 9D 00 00              sta   |0,x                     ; make new first link
2259 AEE1 98                    tya   
2260 AEE2 9D 02 00              sta   |2,x
2261 AEE5 80 5A                 bra   DelDone                  ; all done
2262 AEE7
2263 AEE7              DelErr0                                 ; 
2264 AEE7 80 6F                 bra   DelErr
2265 AEE9
2266 AEE9              notfirst                                ; 
2267 AEE9 E2 20                 sep   #$20                     ; 8 bit 'm'
2268 AEEB BD 02 00              lda   |2,x
2269 AEEE 48                    pha                            ; point at first link
2270 AEEF C2 20                 rep   #$20
2271 AEF1 BD 00 00              lda   |0,x
2272 AEF4 AA                    tax   
2273 AEF5 AB                    plb   
2274 AEF6              DelSrch                                 ; 
2275 AEF6 BD 06 00              lda   |6,x                     ; check task signature
2276 AEF9 C9 5A A5              cmp   #$A55A
2277 AEFC F0 08                 beq   QueueOK                  ; no problem
2278 AEFE A2 05 03              ldx   #queueDmgdErr            ; else queue error
2279 AF01 AB                    plb   
2280 AF02 28                    plp   
2281 AF03 4C 11 FC              jmp   ErrOut4
2282 AF06              QueueOK                                 ; 
2283 AF06 BD 00 00              lda   |0,x                     ; is this the last link ?
2284 AF09 1D 02 00              ora   |2,x
2285 AF0C F0 4A                 beq   DelErr                   ; yes, didnt find kaka
2286 AF0E
2287 AF0E BD 00 00              lda   |0,x                     ; is the next link the target
2288 AF11 C5 09                 cmp   Vptr
2289 AF13 D0 34                 bne   DelSrch0                 ; no
2290 AF15 BD 02 00              lda   |2,x
2291 AF18 C5 0B                 cmp   Vptr+2
2292 AF1A D0 2D                 bne   DelSrch0                 ; no
2293 AF1C 8B                    phb                            ; save current link ptr
2294 AF1D DA                    phx   
2295 AF1E E2 20                 sep   #$20                     ; 8 bit m
2296 AF20                       longa off
2297 AF20 BD 02 00              lda   |2,x                     ; get next link addr
2298 AF23 48                    pha   
2299 AF24 C2 20                 rep   #$20                     ; 16 bit m
2300 AF26                       longa on
2301 AF26 BD 00 00              lda   |0,x
2302 AF29 AA                    tax   
2303 AF2A AB                    plb   
2304 AF2B BD 00 00              lda   |0,x                     ; now get 2nd like addr
2305 AF2E 85 09                 sta   Vptr                     ; stuff on stack
2306 AF30 BD 02 00              lda   |2,x
2307 AF33 85 0B                 sta   Vptr+2
2308 AF35 FA                    plx                            ; restore link ptr
2309 AF36 AB                    plb   
2310 AF37 A5 09                 lda   Vptr                     ; now patch over previous link
2311 AF39 9D 00 00              sta   |0,x
2312 AF3C A5 0B                 lda   Vptr+2
2313 AF3E 9D 02 00              sta   |2,x
2314 AF41              DelDone                                 ; 
2315 AF41
2316 AF41 20 71 AF              jsr   KillIntsIfCan
2317 AF44
2318 AF44 AB                    plb   
2319 AF45 28                    plp                            ; restore interrupt enble
2320 AF46 4C 0E FC              jmp   EndCall4
2321 AF49
2322 AF49
2323 AF49              DelSrch0                                ; 
2324 AF49 E2 20                 sep   #$20                     ; 8 bit m
2325 AF4B                       longa off
2326 AF4B BD 02 00              lda   |2,x                     ; get next link addr
2327 AF4E 48                    pha   
2328 AF4F C2 20                 rep   #$20                     ; 16 bit m
2329 AF51                       longa on
2330 AF51 BD 00 00              lda   |0,x
2331 AF54 AA                    tax   
2332 AF55 AB                    plb   
2333 AF56 80 9E                 bra   DelSrch                  ; continue search
2334 AF58
2335 AF58
2336 AF58              DelErr                                  ; 
2337 AF58 AB                    plb   
2338 AF59 28                    plp   
2339 AF5A A2 06 03              ldx   #taskNtFdErr             ; task not found error
2340 AF5D 4C 11 FC              jmp   ErrOut4
2341 AF60
2342 AF60
2343 AF60                       ENDP 
2344 AF60
2345 AF60              ****************************************************************
2346 AF60              *
2347 AF60              * Clear Heartbeat Interrupt chain
2348 AF60              *
2349 AF60              * Change History
2350 AF60              *
2351 AF60              * 26 Jul 88	Steven Glass
2352 AF60              *
2353 AF60              * Try and turn off vbl interrupts.
2354 AF60              *
2355 AF60              ****************************************************************
2356 AF60              ClrHeart PROC 
2357 AF60                       import KillIntsIfCan 
2358 AF60
2359 AF60
2360 AF60 A9 00 00              lda   #0
2361 AF63 8F D8 00 E1           sta   >HBptr                   ; clear out the links
2362 AF67 8F DA 00 E1           sta   >HBptr+2
2363 AF6B
2364 AF6B 20 71 AF              jsr   KillIntsIfCan
2365 AF6E
2366 AF6E
2367 AF6E 4C DF FB              jmp   oEndCall0
2368 AF71                       ENDP 
2369 AF71
2370 AF71
2371 AF71              ****************************************************************
2372 AF71              *
2373 AF71              KillIntsIfCan PROC 
2374 AF71              *
2375 AF71              * This routine turns off VBL interrupts if it is safe to do so.
2376 AF71              * It is safe to turn them off under the following conditions:
2377 AF71              *
2378 AF71              *   1) No heartbeat tasks are installed.
2379 AF71              *   2) The heartbeat interrupt vector points to our interrupt
2380 AF71              *      handler.
2381 AF71              *   3) the mouse is not running in vbl interrupt mode.
2382 AF71              *
2383 AF71              *
2384 AF71              * Inputs:
2385 AF71              *	none
2386 AF71              *
2387 AF71              * Outputs:
2388 AF71              *	none
2389 AF71              *
2390 AF71              * External Refs:
2391 AF71                       import IRQ_Heart 
2392 AF71              *
2393 AF71              * Entry Points:
2394 AF71              *	none
2395 AF71              *
2396 AF71                       longa on                       ; mode
2397 AF71                       longi on
2398 AF71              *
2399 AF71              ****************************************************************
2400 AF71 AF D8 00 E1           lda   >HBPtr
2401 AF75 0F DA 00 E1           ora   >HBPtr+2
2402 AF79 D0 30                 bne   CannotTurnOff
2403 AF7B
2404 AF7B AF 31 00 E1           lda   >IRQ_VBL+1
2405 AF7F C9 AC AF              cmp   #IRQ_Heart
2406 AF82 D0 27                 bne   CannotTurnOff
2407 AF84
2408 AF84 AF 32 00 E1           lda   >IRQ_VBL+2
2409 AF88 C9 AF FE              cmp   #>IRQ_Heart
2410 AF8B D0 1E                 bne   CannotTurnOff
2411 AF8D
2412 AF8D 48                    pha   
2413 AF8E 48                    pha   
2414 AF8F 48                    pha   
2415 AF90 A2 03 17 22           _ReadMouse 
2416 AF97 68                    pla   
2417 AF98 FA                    plx   
2418 AF99 FA                    plx   
2419 AF9A B0 05                 bcs   CanTurnOff
2420 AF9C 29 08 00              and   #%0000000000001000
2421 AF9F D0 0A                 bne   CannotTurnOff
2422 AFA1
2423 AFA1              CanTurnOff  
2424 AFA1 F4 03 00              PushWord #vblDisable 
2425 AFA4 A2 03 23 22           _IntSource 
2426 AFAB
2427 AFAB 60           CannotTurnOff rts   
2428 AFAC
2429 AFAC                       ENDP 
2430 AFAC
2431 AFAC
2432 AFAC              ****************************************************************
2433 AFAC              *
2434 AFAC              * HeartBeat Interrupt Handler
2435 AFAC              *
2436 AFAC              * Dispatches to this handler are made in response to VBL
2437 AFAC              * interrupts.   This handler will increment the Tick Counter,
2438 AFAC              * and then each task in the heartbeat interrupt queue will
2439 AFAC              * have its counter decremented.   If a zero value results, the
2440 AFAC              * associated handler will be called.   It is the task's
2441 AFAC              * responsibility to reset the count each time it is called.
2442 AFAC              *
2443 AFAC              * Chain looks like.....
2444 AFAC              *
2445 AFAC              * HBptr --> link address --> link address --> $0000
2446 AFAC              *           Counter          Counter          counter
2447 AFAC              *           Signature        Signature        Signature
2448 AFAC              *           (code)           (code)           (code)
2449 AFAC              *
2450 AFAC              *
2451 AFAC              * Change History
2452 AFAC              *
2453 AFAC              * 31 March 88	Steven Glass
2454 AFAC              *
2455 AFAC              * Moved the clearing of the interrupt source from the last
2456 AFAC              * thing done to the first thing done.  This is to prevent
2457 AFAC              * this interrupt from clearing other interrupts that are
2458 AFAC              * cleared at the same address.
2459 AFAC              *
2460 AFAC              ****************************************************************
2461 AFAC              IRQ_Heart PROC EXPORT 
2462 AFAC
2463 AFAC              ;-----------------------------------------------------------
2464 AFAC              ;
2465 AFAC              ; Start by turning off the interrupt source.  Then we can 
2466 AFAC              ; go on and run all the installed tasks.
2467 AFAC              ;
2468 AFAC              ;
2469 AFAC 8F 47 C0 00           sta   >ClrVBLint               ; turn off interrupt source
2470 AFB0
2471 AFB0
2472 AFB0
2473 AFB0 C2 30                 rep   #$30                     ; off to 16 bit land
2474 AFB2 AF DC 00 E1           lda   >TickCnt                 ; increment tick counter
2475 AFB6 1A                    inc   a
2476 AFB7 8F DC 00 E1           sta   >TickCnt
2477 AFBB D0 09                 bne   TickDone
2478 AFBD AF DE 00 E1           lda   >TickCnt+2
2479 AFC1 1A                    inc   a
2480 AFC2 8F DE 00 E1           sta   >TickCnt+2
2481 AFC6
2482 AFC6              TickDone                                ; 
2483 AFC6
2484 AFC6 C2 30                 rep   #$30                     ; off to 16 bit land
2485 AFC8 AF D8 00 E1           lda   >HBptr                   ; is heart beat chain empty
2486 AFCC AA                    tax   
2487 AFCD 0F DA 00 E1           ora   >HBptr+2
2488 AFD1 F0 65                 beq   NoChain1                 ; yes
2489 AFD3
2490 AFD3 8B                    phb   
2491 AFD4 E2 20                 sep   #$20                     ; 8 bit m
2492 AFD6 AF DA 00 E1           lda   >HBptr+2                 ; point at link
2493 AFDA 48                    pha   
2494 AFDB AB                    plb   
2495 AFDC C2 20                 rep   #$20                     ; 16 bit m
2496 AFDE
2497 AFDE              NextHB                                  ;
2498 AFDE DA                    phx                            ;
2499 AFDF 22 B2 01 E1           _MidiInputPoll                 ; Poll Midi before each task.
2500 AFE3 FA                    plx   
2501 AFE4
2502 AFE4 BD 06 00              lda   |6,x                     ; check task signature
2503 AFE7 C9 5A A5              cmp   #$A55A
2504 AFEA F0 10                 beq   QueueOK                  ; looks ok to me
2505 AFEC F4 08 03              pea   hbQueueBadErr            ; heartbeat queue error
2506 AFEF F4 00 00              pea   $0000                    ; Heartbeat queue death message
2507 AFF2 F4 00 00              pea   $0000
2508 AFF5 A2 03 15 22           _SysFailMgr                    ; off to the system death handler
2509 AFFC
2510 AFFC              QueueOK                                 ; 
2511 AFFC BD 04 00              lda   |4,x                     ; if cnt = 0, ignore this task
2512 AFFF F0 1B                 beq   NextQueue
2513 B001 DE 04 00              dec   |4,x                     ; else decrement task counter
2514 B004 D0 16                 bne   NextQueue                ; if task cnt not zero, don't execute
2515 B006 8B                    phb                            ; save environment prior to dispatch
2516 B007 DA                    phx   
2517 B008 4B                    phk                            ; here's where we come back to
2518 B009 F4 15 B0              pea   HBentry-1
2519 B00C 8B                    phb                            ; and here's where were going to
2520 B00D 18                    clc   
2521 B00E 8A                    txa   
2522 B00F 69 07 00              adc   #7
2523 B012 48                    pha   
2524 B013 E2 30                 sep   #$30                     ; dispatch is native, 8 bit m/x
2525 B015 6B                    rtl                            ; and this does the dispatch
2526 B016
2527 B016              HBentry                                 ; 
2528 B016
2529 B016 18                    clc                            ; native mode, 16 bit m/x
2530 B017 FB                    xce   
2531 B018 C2 30                 rep   #$30
2532 B01A FA                    plx                            ; restore queue pointer
2533 B01B AB                    plb   
2534 B01C
2535 B01C              NextQueue                               ; 
2536 B01C
2537 B01C BD 00 00              lda   |0,x                     ; is this the last link ?
2538 B01F 1D 02 00              ora   |2,x
2539 B022 F0 0F                 beq   NoChain                  ; yes
2540 B024 E2 20                 sep   #$20                     ; 8 bit m
2541 B026 BD 02 00              lda   |2,x                     ; get next link addr
2542 B029 48                    pha   
2543 B02A C2 20                 rep   #$20
2544 B02C BD 00 00              lda   |0,x
2545 B02F AA                    tax   
2546 B030 AB                    plb   
2547 B031 80 AB                 bra   NextHB                   ; traverse the chain
2548 B033
2549 B033
2550 B033              NoChain                                 ; 
2551 B033
2552 B033 22 B2 01 E1           _MIDIInputPoll                 ; Poll one last time just to be safe.
2553 B037 AB                    plb   
2554 B038
2555 B038              NoChain1                                ; 
2556 B038
2557 B038 E2 30                 sep   #$30                     ; off to 8 bit land
2558 B03A 18                    clc                            ; flag that interrupt was handled !
2559 B03B 6B                    rtl   
2560 B03C
2561 B03C
2562 B03C                       ENDP 
2563 B03C
2564 B03C                       title 'System Death Manager'
2565 B03C              ****************************************************************
2566 B03C              *
2567 B03C              * System Death Manager     (ErrCode : integer; MsgPtr : long)
2568 B03C              *     Input     Word     Error Code
2569 B03C              *     Input     LongWord Pointer to ascii
2570 B03C              *
2571 B03C              * Change History
2572 B03C              *
2573 B03C              * 08 Dec 88	Steven Glass
2574 B03C              *
2575 B03C              * Check for NIL pointer to string was wrong, ored low word with
2576 B03C              * low word to see if nil.  If string was at beginning of bank,
2577 B03C              * it would not have worked.
2578 B03C              *
2579 B03C              ****************************************************************
2580 B03C              SysDeathMgr PROC 
2581 B03C
2582 B03C
2583 B03C              RTL1     equ   1
2584 B03C              RTL2     equ   RTL1+3
2585 B03C              Ptr      equ   RTL2+3
2586 B03C              ErrCode  equ   Ptr+4
2587 B03C
2588 B03C 18                    clc   
2589 B03D A3 07                 lda   Ptr,s
2590 B03F 03 09                 ora   Ptr+2,s                  ; Default
2591 B041 D0 01                 bne   DSysD                    ; yes
2592 B043 38                    sec                            ; else user msg
2593 B044
2594 B044              DSysD                                   ;       
2595 B044 8B                    phb                            ; clean 3 bytes of stack
2596 B045 68                    pla   
2597 B046 68                    pla   
2598 B047
2599 B047 5C 1C 00 E1           jmp   >SysDMgrV                ; off through SysDeath vector
2600 B04B
2601 B04B              ; and never come back.
2602 B04B
2603 B04B                       ENDP 
2604 B04B
2605 B04B
2606 B04B                       title 'GetAddress'
2607 B04B              ****************************************************************
2608 B04B              *
2609 B04B              * Return Interrupt Status Address
2610 B04B              *
2611 B04B              * Input     word         refnum
2612 B04B              * Input     LongWord     Don't care
2613 B04B              *
2614 B04B              * Output    LongWord     Pointer
2615 B04B              *
2616 B04B              * Modification History
2617 B04B              *
2618 B04B              *    May 6, 1986	See 5 lines changed below.
2619 B04B              *
2620 B04B              ****************************************************************
2621 B04B              GetAddr  PROC 
2622 B04B
2623 B04B              RTL1     equ   1
2624 B04B              RTL2     equ   RTL1+3
2625 B04B              RefNum   equ   RTL2+3
2626 B04B              Ptr      equ   RefNum+2
2627 B04B
2628 B04B A3 07                 lda   RefNum,s                 ; get ref #
2629 B04D 0A                    asl   a                        ; and make an index
2630 B04E 0A                    asl   a
2631 B04F C9 3C 00              cmp   #MaxRef                  ; index out of range ?
2632 B052 90 06                 bcc   GetAddr0                 ; nope
2633 B054 A2 01 03              ldx   #badInputErr             ; error is bad input parm.
2634 B057 4C FC FB              jmp   oErrOut2                 ; uses oErrOut SEG 6 May 86
2635 B05A
2636 B05A              GetAddr0                                ; 
2637 B05A AA                    tax                            ; get param. addr
2638 B05B BF 6A B0 FE           lda   >Ptbl,x                  ; abs long,x addressing SEG 6 May 86
2639 B05F 83 09                 sta   Ptr,s
2640 B061 BF 6C B0 FE           lda   >Ptbl+2,x                ; abs long,x addressing SEG 6 May 86
2641 B065 83 0B                 sta   Ptr+2,s                  ; missing +2 SEG 6 May 86
2642 B067 4C F7 FB              jmp   oEndCall2                ; uses oEndCall SEG 6 May 86
2643 B06A
2644 B06A              Ptbl                                    ; 
2645 B06A C3 00 E1 00           DC L:irq_intflag               ; status of INTFLAG at IRQ
2646 B06E C4 00 E1 00           DC L:irq_datareg               ; status of DATREG at IRQ
2647 B072 C7 00 E1 00           DC L:irq_ser1                  ; user interrupt info
2648 B076 C8 00 E1 00           DC L:irq_ser2                  ; user interrupt info
2649 B07A C9 00 E1 00           DC L:irq_aptlkhi               ; user interrupt info
2650 B07E DC 00 E1 00           DC L:TickCnt                   ; longword tick count value
2651 B082 CA 00 E1 00           DC L:irq_volume                ; volume used during IRQ time
2652 B086 CB 00 E1 00           DC L:irq_active                ; <> 0 if called during IRQ
2653 B08A CC 00 E1 00           DC L:irq_soundd                ; sound data at irq
2654 B08E 08 01 E1 00           DC L:irq_a                     ; registers at break
2655 B092 E1 00 E1 00           DC L:evmgrdata                 ; event manager data
2656 B096 E0 00 E1 00           DC L:mouseslot                 ; the little squeeker is here
2657 B09A B8 02 E1 00           DC L:LowXClamp                 ; 8 bytes of mouse clamp data
2658 B09E D0 1D E1 00           DC L:AbsClamps                 ; 8 bytes of absolute device clamp
2659 B0A2 04 01 E1 00           DC L:SerFlag                   ; something for mike/fern
2660 B0A6              ;                                       ; added 6 Mar 87 by Ray, Mike, Steve
2661 B0A6              ;                                       ; fern and witnessed by Dan O.
2662 B0A6              PtblEnd                                 ; 
2663 B0A6
2664 B0A6              MaxRef   equ   PtblEnd-Ptbl
2665 B0A6
2666 B0A6
2667 B0A6                       ENDP 
2668 B0A6
2669 B0A6
2670 B0A6                       title 'Mouse Tools'
2671 B0A6              ****************************************************************
2672 B0A6              *
2673 B0A6              *        Mouse Tool Sets for Mars
2674 B0A6              *
2675 B0A6              ****************************************************************
2676 B0A6              *
2677 B0A6              *        Copyright (C) 1985-1987
2678 B0A6              *        Apple Computer, Inc.
2679 B0A6              *        All Rights Reserved
2680 B0A6              *
2681 B0A6              ****************************************************************
2682 B0A6
2683 B0A6
2684 B0A6              ****************************************************************
2685 B0A6              ;
2686 B0A6              setdbtoe1 PROC 
2687 B0A6              ;
2688 B0A6 F4 E1 E1              pea   $e1e1                    ;change data bank to $e1
2689 B0A9 AB                    plb                            ;dummy pull
2690 B0AA AB                    plb                            ;set data bank to $e1
2691 B0AB 60                    rts   
2692 B0AC
2693 B0AC                       ENDP 
2694 B0AC
2695 B0AC                       EJECT 
2696 B0AC              *******************************************************************************
2697 B0AC              *
2698 B0AC              ReadMouseJ PROC 
2699 B0AC              *
2700 B0AC              * Description: This call will function identically to read mouse except that
2701 B0AC              *              it will allow journaling to take place.
2702 B0AC              *
2703 B0AC              *             Screen holes, buttons and movement status
2704 B0AC              *             bits updated; interrupt status bits are cleared
2705 B0AC              *             If data not contaminated, then first read $c024
2706 B0AC              *             return X position data (ADB low byte), second
2707 B0AC              *             reads return Y position data (ADB high byte)
2708 B0AC              *
2709 B0AC              *             |MseStat ($077c): bit7, previously but1 was up/down (0/1)
2710 B0AC              *	           bit6, movement interrupt
2711 B0AC              *	           bit5, button 0/1 interrupt
2712 B0AC              *	           bit4, vbl interrupt
2713 B0AC              *	           bit3, currently but1 is up/down (0/1)
2714 B0AC              *	           bit2, x/y moved since last READMOUSE
2715 B0AC              *	           bit1, previously but0 was up/down (0/1)
2716 B0AC              *	           bit0, currently but0 is up/down (0/1)
2717 B0AC              *
2718 B0AC              * Input  word: don't care
2719 B0AC              * Input  word: don't care
2720 B0AC              * Input  word: don't care
2721 B0AC              * Output word: X position
2722 B0AC              * Output word: Y position
2723 B0AC              * Output word: Status & Mode
2724 B0AC              *
2725 B0AC              * External Refs:
2726 B0AC                       Import AltTRdMouse 
2727 B0AC              *
2728 B0AC              *******************************************************************************
2729 B0AC              *
2730 B0AC                       longa on
2731 B0AC                       longi on
2732 B0AC
2733 B0AC              ;
2734 B0AC              ; stack structure
2735 B0AC              ;
2736 B0AC              DBreg    equ   1
2737 B0AC              Preg     equ   DBreg+1
2738 B0AC              RTL1     equ   Preg+1
2739 B0AC              RTL2     equ   RTL1+3
2740 B0AC              StatMode equ   RTL2+3
2741 B0AC              YPos     equ   StatMode+2
2742 B0AC              XPos     equ   YPos+2
2743 B0AC              ;
2744 B0AC 08                    php                            ;save interrupt status
2745 B0AD 78                    sei                            ;disable interrupt
2746 B0AE 8B                    phb                            ;save data bank
2747 B0AF 20 A6 B0              jsr   setdbtoe1                ;change data bank to $00
2748 B0B2              ;
2749 B0B2              ; First, check the journaling flag, if its zero, then simply call ReadMouse direct
2750 B0B2              ; and go no further.
2751 B0B2 AF E1 00 E1           lda   >JournalFlag
2752 B0B6 D0 03                 bne   rm2010
2753 B0B8 82 44 00              brl   AltTRdMouse              ; if its zero, then let read mouse handle this
2754 B0BB              ;
2755 B0BB              ; Next, check to see if the event manager is active, if it is, then we can continue,
2756 B0BB              ; if it isn't well, just exit...
2757 B0BB              rm2010    
2758 B0BB 48                    pha                            ; room for result
2759 B0BC A2 06 06 22           _EMStatus 
2760 B0C3 68                    pla   
2761 B0C4 D0 03                 bne   rm2OK                    ; if its true, then its ok to go on
2762 B0C6 82 36 00              brl   AltTRdMouse              ; if the event manager is off then let ReadMouse handle this
2763 B0C9              ;
2764 B0C9              rm2OK     
2765 B0C9              ; If we get this far, we know that the event manager is active and that journaling is turned on.
2766 B0C9
2767 B0C9 48                    pha                            ; call the real read mouse to get the current mouse data
2768 B0CA 48                    pha   
2769 B0CB 48                    pha   
2770 B0CC A2 03 33 22           _ReadMouse2 
2771 B0D3
2772 B0D3 68                    pla                            ; get the current mouse data from the call
2773 B0D4 7A                    ply   
2774 B0D5 FA                    plx   
2775 B0D6 83 09                 sta   StatMode,s               ; and save them into our record
2776 B0D8 98                    tya   
2777 B0D9 83 0B                 sta   yPos,s                   ; on the stack for journaling to use.
2778 B0DB 8A                    txa   
2779 B0DC 83 0D                 sta   xPos,s
2780 B0DE              ;
2781 B0DE              ; Now that our result is set properly, we must call the journaling routine so that it will save
2782 B0DE              ; these new bytes for us. Or load in whatever it should be for playback
2783 B0DE              ; First create the address of our data on the stack so we can pass it
2784 B0DE 3B                    tsc                            ; get the current stack pointer
2785 B0DF 18                    clc   
2786 B0E0 69 09 00              adc   #StatMode                ; add in the proper offset
2787 B0E3 AA                    tax                            ; and save it in <X> for later
2788 B0E4
2789 B0E4 AF E1 00 E1           lda   >JournalFlag             ; first push the flag on the stack
2790 B0E8 48                    pha   
2791 B0E9 F4 06 00              pea   $0006                    ; journal code for ReadMouse (Also the data size...hmmm...)
2792 B0EC F4 00 00              pea   $0000                    ; now push the address of our data, (its on the stack...)
2793 B0EF DA                    phx                            ; push low word of data buffer
2794 B0F0 22 E3 00 E1           jsl   JournalPtr               ; and call the journaling routine
2795 B0F4              ;
2796 B0F4              ; Journaling is all finished, and so should we be... so simply exit
2797 B0F4
2798 B0F4 AB                    plb                            ;restore data bank
2799 B0F5 28                    plp                            ;restore interrupt state during entry
2800 B0F6 4C DF FB              jmp   oEndCall0                ;exit tool with good MouseRead
2801 B0F9
2802 B0F9                       EndP 
2803 B0F9
2804 B0F9              ****************************************************************
2805 B0F9              *
2806 B0F9              * ReadMouse - Read Mouse Position
2807 B0F9              *             Screen holes, buttons and movement status
2808 B0F9              *             bits updated; interrupt status bits are cleared
2809 B0F9              *             If data not contaminated, then first read $c024
2810 B0F9              *             return X position data (ADB low byte), second
2811 B0F9              *             reads return Y position data (ADB high byte)
2812 B0F9              *
2813 B0F9              *             |MseStat ($077c): bit7, previously but1 was up/down (0/1)
2814 B0F9              *             bit6, movement interrupt
2815 B0F9              *             bit5, button 0/1 interrupt
2816 B0F9              *             bit4, vbl interrupt
2817 B0F9              *             bit3, currently but1 is up/down (0/1)
2818 B0F9              *             bit2, x/y moved since last READMOUSE
2819 B0F9              *             bit1, previously but0 was up/down (0/1)
2820 B0F9              *             bit0, currently but0 is up/down (0/1)
2821 B0F9              *
2822 B0F9              * Input  word: don't care
2823 B0F9              * Input  word: don't care
2824 B0F9              * Input  word: don't care
2825 B0F9              * Output word: X position
2826 B0F9              * Output word: Y position
2827 B0F9              * Output word: Status & Mode
2828 B0F9              *
2829 B0F9              ****************************************************************
2830 B0F9              *
2831 B0F9              TRdMou   PROC 
2832 B0F9                       Export AltTRdMouse 
2833 B0F9                       longa on
2834 B0F9                       longi on
2835 B0F9              ;
2836 B0F9              ; stack structure
2837 B0F9              ;
2838 B0F9              DBreg    equ   1
2839 B0F9              Preg     equ   DBreg+1
2840 B0F9              RTL1     equ   Preg+1
2841 B0F9              RTL2     equ   RTL1+3
2842 B0F9              StatMode equ   RTL2+3
2843 B0F9              YPos     equ   StatMode+2
2844 B0F9              XPos     equ   YPos+2
2845 B0F9              ;
2846 B0F9 08                    php                            ;save interrupt status
2847 B0FA 78                    sei                            ;disable interrupt
2848 B0FB 8B                    phb                            ;save data bank
2849 B0FC 20 A6 B0              jsr   setdbtoe1                ;change data bank to $00
2850 B0FF              ;
2851 B0FF              AltTRdMouse  
2852 B0FF                       longa off
2853 B0FF                       longi off
2854 B0FF E2 30                 sep   #$30                     ;off to 8-bit land
2855 B101 20 E1 B1              jsr   GetMdata                 ;read in mouse data from keygloo
2856 B104 90 10                 bcc   RealData                 ;'c' = 0 if real live data
2857 B106 AD 96 01              lda   |MseStat                 ;Fake data if here to get state history
2858 B109 49 90                 eor   #$90                     ;was 0=up -- after eor then 0=down
2859 B10B AA                    tax                            ;save in 'x'
2860 B10C 29 80                 and   #$80                     ;mask for current button0 state
2861 B10E A8                    tay   
2862 B10F 8A                    txa   
2863 B110 29 10                 and   #$10                     ;
2864 B112 0A                    asl   a                        ;move to msb
2865 B113 0A                    asl   a
2866 B114 0A                    asl   a
2867 B115 AA                    tax   
2868 B116              RealData                                ; 
2869 B116 A9 20                 lda   #$20                     ;anticipate no movement
2870 B118 1C 96 01              trb   |MseStat                 ;reset to no movement first
2871 B11B 98                    tya                            ;get back y data from GetMdata
2872 B11C 29 3F                 and   #$3f                     ;mask off but0 and direction bit
2873 B11E 48                    pha                            ;save in stack
2874 B11F 8A                    txa                            ;get back x data from GetMdata
2875 B120 29 3F                 and   #$3f                     ;mask off but1 and direction bit
2876 B122 03 01                 ora   1,s                      ;ora together x/y data byte
2877 B124 F0 05                 beq   NoMove                   ;both x/y =0, no movement
2878 B126 A9 20                 lda   #$20                     ;else set movement bit
2879 B128 0C 96 01              tsb   |MseStat                 ;set movement status bit
2880 B12B              ;
2881 B12B              Nomove                                  ;movement status bit already reset
2882 B12B 68                    pla                            ;clean up stack
2883 B12C AD 96 01              lda   |MseStat                 ;get current buttons status
2884 B12F 48                    pha                            ;save temporarily
2885 B130 29 2E                 and   #$2e                     ;reset bits 7,6,4,1, buttons bits
2886 B132 8D 96 01              sta   |MseStat                 ; i.e. button 1/0 all up first
2887 B135 68                    pla                            ;recall current buttons status
2888 B136 29 90                 and   #$90                     ;mask for last current buto/but1
2889 B138 0A                    asl   a                        ;shift last current but0 to 'c'
2890 B139 90 09                 bcc   LstBut0Off               ;bra if last current but0 is off
2891 B13B F0 0D                 beq   But0on1off               ;bra here for last current but0 on
2892 B13D              ;                                       ; and but1 off
2893 B13D A9 41                 lda   #$41                     ;get here if both last current buttons
2894 B13F              ;                                       ; state were1, i.e. buttons pressed
2895 B13F              SetHole                                 ; 
2896 B13F 0C 96 01              tsb   |MseStat                 ;set it for screen hole
2897 B142 80 0A                 bra   NewData                  ;bra to update for new states being
2898 B144              ;                                       ; read in by GetMdata
2899 B144              ;
2900 B144              LstBut0Off                              ; 
2901 B144 F0 08                 beq   NewData                  ;bra for both off
2902 B146 A9 01                 lda   #$01                     ;else but1 on, down
2903 B148 80 F5                 bra   SetHole                  ;update screen hole but1 stat
2904 B14A              ;
2905 B14A              But0on1off                              ; 
2906 B14A A9 40                 lda   #$40                     ;set but0 on
2907 B14C 80 F1                 bra   SetHole                  ;update screen hole but0 stat
2908 B14E              ;
2909 B14E              NewData                                 ; 
2910 B14E 98                    tya                            ;get new but0 back
2911 B14F 2A                    rol   a                        ;save but0 status in 'c'
2912 B150 8A                    txa                            ;get new but1 back, bit7
2913 B151              ;
2914 B151              ; enter here with new buttons status, but0 = c, but1 = N (bit7)
2915 B151              ; on=down=0, off=up=1, same to ADB spev but opposite to |MseStat !!!
2916 B151              ;
2917 B151 B0 09                 bcs   But0off                  ;bra if new but0 stat = 1, off
2918 B153 30 0D                 bmi   But1off                  ;bra here for but0 = on, but1 = off
2919 B155 A9 90                 lda   #$90                     ;get here for both on, update it
2920 B157              UpdateHole                              ; 
2921 B157 0C 96 01              tsb   |MseStat                 ;update screen holes with newly stat
2922 B15A 80 0A                 bra   AnyMove                  ;continue to handler any new movement
2923 B15C              ;
2924 B15C              But0off                                 ; 
2925 B15C 30 08                 bmi   AnyMove                  ;bra if both buttons off
2926 B15E A9 10                 lda   #$10                     ;get here for but1 on only
2927 B160 80 F5                 bra   UpdateHole               ;update it
2928 B162              ;
2929 B162              But1off                                 ; 
2930 B162 A9 80                 lda   #$80                     ;get here for but0 on only
2931 B164 80 F1                 bra   UpdateHole               ;update it
2932 B166              ;
2933 B166              AnyMove                                 ;Handling mouse movements
2934 B166 8A                    txa                            ;get back x-pos new detla
2935 B167 29 7F                 and   #$7f                     ;mask off button1 status, already done
2936 B169 AA                    tax                            ;temp store direction and movement
2937 B16A 0A                    asl   a                        ;direction bit to msb
2938 B16B 10 07                 bpl   PosXmov                  ;bra for positive x direction move
2939 B16D 8A                    txa                            ;else neg x move, make 2's
2940 B16E 09 80                 ora   #$80                     ;set 2's data
2941 B170 A2 FF                 ldx   #$ff                     ;set high byte to 2's also
2942 B172 80 03                 bra   NegXMov                  ;bra to handle this neg move
2943 B174              ;
2944 B174              PosXmov                                 ; 
2945 B174 8A                    txa                            ;pos x move, make high byte also +
2946 B175 A2 00                 ldx   #$00
2947 B177              ;
2948 B177              NegXMov                                 ; 
2949 B177              PosNeg                                  ; 
2950 B177 DA                    phx                            ;push hi byte of delta x (word) on stk
2951 B178 48                    pha                            ;push lo byte of delta x on stack
2952 B179 98                    tya                            ;process delta y stuff
2953 B17A 29 7F                 and   #$7f                     ;ignore button0 status, already handled
2954 B17C A8                    tay                            ;store delta y without but0 status
2955 B17D 0A                    asl   a                        ;shift direction bit to msb
2956 B17E 10 07                 bpl   PosYMov                  ;bra for pos y movement
2957 B180 98                    tya                            ;get back delta y
2958 B181 09 80                 ora   #$80                     ;negative y movement, make 2's
2959 B183 A0 FF                 ldy   #$ff                     ;set high byte also
2960 B185 80 03                 bra   NegYMOv                  ;
2961 B187              PosYMov                                 ; 
2962 B187 98                    tya                            ;pos y movement, then make hi byte '+'
2963 B188 A0 00                 ldy   #$00
2964 B18A              ;
2965 B18A              NegYMov                                 ; 
2966 B18A 5A                    phy                            ;push hi byte of delta y on stack
2967 B18B 48                    pha                            ;push lo byte of delta y on stack
2968 B18C              ;
2969 B18C AD 93 01              lda   |HighAbsy                ;read back previous value and
2970 B18F              ;                                       ; update with the current value
2971 B18F 8D 95 01              sta   |MseSpare                ;save the previous value temporarily
2972 B192              ;                                       ; for 'YclampTest'
2973 B192 68                    pla                            ;get back lo byte of delta y from stack
2974 B193 18                    clc                            ;clear carry for the following adding
2975 B194 6D 91 01              adc   |LowAbsy                 ;add in new value for low byte abs y
2976 B197 8D 91 01              sta   |LowAbsy                 ;update the screen hole also
2977 B19A              ;
2978 B19A 68                    pla                            ;get back high byte of delta y
2979 B19B 6D 93 01              adc   |HighAbsy                ;add in new value for high byte abs y
2980 B19E 8D 93 01              sta   |HighAbsy                ;update screen hole also
2981 B1A1 20 12 B2              jsr   YclampTest               ;test y against clamp
2982 B1A4              ;
2983 B1A4 AD 92 01              lda   |HighAbsx                ;process delta x stuff
2984 B1A7 8D 95 01              sta   |MseSpare
2985 B1AA              ;
2986 B1AA 68                    pla                            ;get back lo byte of delta x from stack
2987 B1AB 18                    clc                            ;make sure 'c'=0
2988 B1AC 6D 90 01              adc   |LowAbsx                 ;add in new value for low byte of x
2989 B1AF 8D 90 01              sta   |LowAbsx                 ;update screen hole also
2990 B1B2              ;
2991 B1B2 68                    pla                            ;get back high byte of delat x
2992 B1B3 6D 92 01              adc   |HighAbsx                ;add in new value for high byte of x
2993 B1B6 8D 92 01              sta   |HighAbsx                ;update screen hole also
2994 B1B9 20 FD B1              jsr   XclampTest               ;test x against clamp
2995 B1BC              ;
2996 B1BC AD 92 01              lda   |HighAbsx                ;after proper clamps testing, read
2997 B1BF              ;                                       ; it and set properly for the toos call
2998 B1BF 83 0E                 sta   Xpos+1,s
2999 B1C1 AD 90 01              lda   |LowAbsx
3000 B1C4 83 0D                 sta   Xpos,s
3001 B1C6 AD 93 01              lda   |HighAbsy
3002 B1C9 83 0C                 sta   Ypos+1,s
3003 B1CB AD 91 01              lda   |LowAbsy
3004 B1CE 83 0B                 sta   Ypos,s
3005 B1D0 AD 96 01              lda   |MseStat                 ;get status
3006 B1D3 83 0A                 sta   StatMode+1,s             ;move status to stack for tools call
3007 B1D5 AD 97 01              lda   |MseMode                 ;get mouse mode
3008 B1D8 83 09                 sta   StatMode,s               ;move mode to stack
3009 B1DA              ;
3010 B1DA C2 30                 rep   #$30                     ;must exit with 16-bit m/x
3011 B1DC AB                    plb                            ;restore data bank
3012 B1DD 28                    plp                            ;restore interrupt state during entry
3013 B1DE 4C DF FB              jmp   oEndCall0                ;exit tool with good MouseRead
3014 B1E1              ;
3015 B1E1              ; How about error reading ??????????   ErrorCode ???????
3016 B1E1              ;
3017 B1E1                       ENTRY GetMData 
3018 B1E1              GetMdata                                ;
3019 B1E1 AD 27 C0              lda   kmstatus                 ;test if data available
3020 B1E4 10 15                 bpl   NotAvail                 ;bra if not available, set 'c'
3021 B1E6 6A                    ror   a                        ;set 'c'=0, if data ok bit1=0
3022 B1E7 6A                    ror   a                        ; i.e. data not contaminated
3023 B1E8 AD 24 C0              lda   MouseData                ;read in mouse data register, $c024
3024 B1EB AA                    tax   
3025 B1EC B0 0D                 bcs   NotAvail                 ;c=1 if data is contaminated
3026 B1EE AD 27 C0              lda   kmstatus                 ;verify Y ardware has X data ready
3027 B1F1 29 02                 and   #$02                     ;bit1=1, Y pos data available
3028 B1F3 F0 06                 beq   NotAVail
3029 B1F5 AD 24 C0              lda   MouseData                ;read in Y position data
3030 B1F8 A8                    tay                            ;store for calling routine
3031 B1F9 18                    clc                            ;good reading of mouse data
3032 B1FA 60                    rts                            ;return to caller
3033 B1FB              NotAvail                                ; 
3034 B1FB 38                    sec                            ;not a good reading
3035 B1FC 60                    rts   
3036 B1FD              ;
3037 B1FD              **************************************************************************
3038 B1FD              *
3039 B1FD              * Clamping is done after the delta has been added to the absolute value.
3040 B1FD              * The new absolute values are tested against the current clamp values.
3041 B1FD              *
3042 B1FD              **************************************************************************
3043 B1FD              *
3044 B1FD              XclampTest                              ; 
3045 B1FD A0 00                 ldy   #$00                     ;y=0 for Xdata, y=$01 for Ydata
3046 B1FF BB                    tyx                            ;x=0 for Xdata, x=$02 for Ydata
3047 B200 EB                    xba                            ;high byte of data to hi byte of 'A'
3048 B201 B9 90 01              lda   |LowAbsx,y               ;read lo byte of data to lo byte of 'A'
3049 B204 EB                    xba                            ;swap hi and low byte of 'A'
3050 B205 A8                    tay                            ;y=high byte of data
3051 B206 50 05                 bvc   NoOverflow               ;no overflow then all's fine
3052 B208 2C 97 01              bit   |MseMode                 ;chk which test flag in use
3053 B20B 80 14                 bra   YclampTst0               ;continue this way
3054 B20D              NoOverflow                              ; 
3055 B20D 2C 97 01              bit   |MseMode                 ;set up N and V for later
3056 B210 80 1D                 bra   ClampTest                ;continue this way
3057 B212              ;
3058 B212              YclampTest                              ; 
3059 B212 A0 01                 ldy   #$01                     ;y=0 for Xdata, y=$01 for Ydata
3060 B214 A2 02                 ldx   #$02                     ;x=0 for Xdata, y=$02 for Ydata
3061 B216 EB                    xba                            ;high byte of y data to hi byte of 'A'
3062 B217 B9 90 01              lda   |LowAbsx,y               ;read lo byte of y data to lo byte 'A'
3063 B21A EB                    xba                            ;swap hi and low byte of 'A'
3064 B21B A8                    tay                            ;y=high byte of y data
3065 B21C 50 0E                 bvc   YclampTst2               ;No overflow then all's fine
3066 B21E 2C 94 01              bit   |MseInfo                 ;chk which test flag in use, Info set
3067 B221              ;                                       ; in InitTool
3068 B221              YclampTst0                              ; 
3069 B221 30 07                 bmi   Chk2or3                  ;either 2 or 3 if -
3070 B223 50 22                 bvc   MaxClamp                 ;Test 0 if v=0
3071 B225 98                    tya                            ;test 1 if v=1
3072 B226 30 1F                 bmi   MaxClamp                 ;if - was + before
3073 B228 10 34                 bpl   MinClamp                 ;if + was - before
3074 B22A              Chk2or3                                 ; 
3075 B22A 50 32                 bvc   MinClamp                 ;test 2 if v=0
3076 B22C              YclampTst2                              ; 
3077 B22C 2C 94 01              bit   |MseInfo                 ;setup N and V for later
3078 B22F              ;
3079 B22F              ClampTest                               ; 
3080 B22F 08                    php                            ;save status
3081 B230 98                    tya                            ;is it + or -
3082 B231 30 26                 bmi   NegNum                   ;bra if -
3083 B233 28                    plp                            ;value is +
3084 B234 30 0F                 bmi   Must2or3                 ;must be 2 or 3
3085 B236 50 41                 bvc   MinMax                   ;must be test 0]
3086 B238                       longa on
3087 B238                       longi on
3088 B238 C2 30                 rep   #$30                     ;off to 16-bit land
3089 B23A EB                    xba                            ;put high data back to hi byte of 'A'
3090 B23B DD BC 02              cmp   |HiXclamp,x              ;test against high clamp
3091 B23E                       longa off
3092 B23E                       longi off
3093 B23E E2 30                 sep   #$30                     ;back of 8-bit land
3094 B240 F0 02                 beq   OkValue                  ;bra if equal to max clamp, ok
3095 B242 B0 03                 bcs   MaxClamp                 ;> maxclamp is not ok
3096 B244              OkValue                                 ; 
3097 B244 60                    rts                            ;back to caller
3098 B245              Must2or3                                ; 
3099 B245 70 32                 bvs   MinMax                   ;do regular min/max test
3100 B247              ;
3101 B247              MaxClamp                                ; 
3102 B247 9B                    txy                            ;test whether x or y data change
3103 B248 F0 02                 beq   XChange                  ;bra for Xdata, x=y=0
3104 B24A A0 01                 ldy   #$01                     ;else set for Ydata, y=$01
3105 B24C              Xchange                                 ; 
3106 B24C BD BC 02              lda   |HiXclamp,x
3107 B24F 99 90 01              sta   |LowAbsx,y               ;Modify user data to max clamp value
3108 B252 BD BD 02              lda   |HiXclamp+1,x
3109 B255              MaxClamp2                               ; 
3110 B255 99 92 01              sta   |HighAbsx,y              ;save as new abs hi value
3111 B258 60                    rts                            ;back to caller
3112 B259              ;
3113 B259              NegNum                                  ; 
3114 B259 28                    plp                            ;bit7 to N / bit6 to V
3115 B25A 30 1D                 bmi   MinMax                   ;must be 2 or 3
3116 B25C 70 10                 bvs   Testm1                   ;must be test 1
3117 B25E              ;
3118 B25E              MinClamp                                ;must be test 0
3119 B25E 9B                    txy                            ;test whether x or y data change
3120 B25F F0 02                 beq   XChange1                 ;x=y=0 for Xdata
3121 B261 A0 01                 ldy   #$01                     ;else set for Ydata
3122 B263              Xchange1                                ; 
3123 B263 BD B8 02              lda   |LowXclamp,x
3124 B266 99 90 01              sta   |LowAbsx,y               ;Modify user data to min clamp value
3125 B269 BD B9 02              lda   |LowXclamp+1,x
3126 B26C 80 E7                 bra   Maxclamp2                ;exit this way
3127 B26E              ;
3128 B26E              Testm1                                  ; 
3129 B26E EB                    xba                            ;put high byte in hi byte of 'A'
3130 B26F                       longa on
3131 B26F                       longi on
3132 B26F C2 30                 rep   #$30                     ;off to 16 bit land
3133 B271 DD B8 02              cmp   |LowXclamp,x             ;test against min clamp
3134 B274                       longa off
3135 B274                       longi off
3136 B274 E2 30                 sep   #$30                     ;back to 8 bit land
3137 B276 90 E6                 bcc   MinClamp                 ;< min clamp then use min clamp
3138 B278 60                    rts                            ;ok value, back to caller
3139 B279              ;
3140 B279              MinMax                                  ;do regular min/max testing
3141 B279 98                    tya                            ;pick up value to test
3142 B27A 30 17                 bmi   MinMax0                  ;current valur is -
3143 B27C AD 95 01              lda   |MseSpare                ;what was previous abs sign
3144 B27F 10 17                 bpl   MinMax1                  ;previous was +
3145 B281              SpecTest                                ; 
3146 B281 38                    sec                            ;set carry to subtract
3147 B282 9B                    txy                            ;make proper y index
3148 B283 F0 02                 beq   Xxdata
3149 B285 A0 01                 ldy   #$01                     ;set for ydata
3150 B287              Xxdata                                  ; 
3151 B287 F9 92 01              sbc   |HighAbsx,y              ;subtract current abs hi byte
3152 B28A 70 0C                 bvs   MinMax1                  ;v=1 then all's fine
3153 B28C 2C 95 01              bit   |MseSpare                ;test sign
3154 B28F 10 CD                 bpl   MinClamp                 ;+ then use min clamp
3155 B291 30 B4                 bmi   MaxClamp                 ;- then use max clamp
3156 B293              MinMax0                                 ; 
3157 B293 AD 95 01              lda   |MseSpare                ;test previous bi byte for sign
3158 B296 10 E9                 bpl   SpecTest                 ;previous was +
3159 B298              ;
3160 B298              MinMax1                                 ; 
3161 B298 9B                    txy                            ;make proper y index
3162 B299 F0 02                 beq   Xxxdata
3163 B29B A0 01                 ldy   #$01
3164 B29D              Xxxdata                                 ; 
3165 B29D B9 92 01              lda   |HighAbsx,y              ;get current abs hi byte
3166 B2A0                       longa on
3167 B2A0                       longi on
3168 B2A0 C2 30                 rep   #$30                     ;off to 16 bit land
3169 B2A2 EB                    xba                            ;put high byte into hi byte of 'A'
3170 B2A3 DD BC 02              cmp   |HiXclamp,x
3171 B2A6                       longa off
3172 B2A6                       longi off
3173 B2A6 E2 30                 sep   #$30                     ;back to 8 bit land
3174 B2A8 F0 02                 beq   OkValue2                 ;= is ok
3175 B2AA B0 9B                 bcs   MaxClamp                 ;> than max then use max clamp value
3176 B2AC              OkValue2                                ; 
3177 B2AC C2 30                 rep   #$30                     ;off to 16 bit land
3178 B2AE DD B8 02              cmp   |LowXclamp,x             ;test against min clamp
3179 B2B1 E2 30                 sep   #$30                     ;back to 8 bit land
3180 B2B3 90 A9                 bcc   MinClamp                 ;< min clamp then use min clamp value
3181 B2B5 60                    rts                            ;back to caller
3182 B2B6
3183 B2B6                       ENDP 
3184 B2B6
3185 B2B6
3186 B2B6              *************************************************************
3187 B2B6              *
3188 B2B6              * InitMouse - init mouse clamp values to $0000 and $03ff,
3189 B2B6              *             set mouse position to 0,0 and also clear
3190 B2B6              *             mouse mode and status
3191 B2B6              *
3192 B2B6              *  Input : word, mouseslot (miscellaneous tool)
3193 B2B6              *          If mouse is going to be always active, then there
3194 B2B6              *          is not necessary to have such input, the following
3195 B2B6              *          routine doesn't take care of this input word but
3196 B2B6              *          maintain compatibility with miscellaneous tool and
3197 B2B6              *          therefore exits with oEndCall02
3198 B2B6              *
3199 B2B6              *************************************************************
3200 B2B6              *
3201 B2B6              InitGlue PROC 
3202 B2B6
3203 B2B6                       longa on
3204 B2B6                       longi on
3205 B2B6              ;
3206 B2B6              ; The stack is not affected by this call
3207 B2B6              ;
3208 B2B6 08                    php                            ;save interrupt state
3209 B2B7 78                    sei                            ;disable interrupt
3210 B2B8 8B                    phb                            ;save data bank
3211 B2B9 20 A6 B0              jsr   setdbtoe1                ;change data bank to $00
3212 B2BC              ;
3213 B2BC A9 00 00              lda   #$0000                   ;16 bit land
3214 B2BF 8D B8 02              sta   |LowXclamp               ;reset low clamps to 00
3215 B2C2 8D BA 02              sta   |LowYclamp               ;
3216 B2C5 A9 FF 03              lda   #$03ff                   ;reset high clamps to$3ff
3217 B2C8 8D BC 02              sta   |HiXclamp
3218 B2CB 8D BE 02              sta   |HiYclamp
3219 B2CE                       longa off
3220 B2CE                       longi off
3221 B2CE E2 30                 sep   #$30                     ;off to 8 bit land
3222 B2D0 9C 90 01              stz   |LowAbsx                 ;set screen holes to 00
3223 B2D3 9C 91 01              stz   |LowAbsy
3224 B2D6 9C 92 01              stz   |HighAbsx
3225 B2D9 9C 93 01              stz   |HighAbsy
3226 B2DC
3227 B2DC A9 04                 lda   #$04                     ;??? assume mouse at slot4
3228 B2DE 8F E0 00 E1           sta   mouseslot
3229 B2E2
3230 B2E2 22 93 B4 FE           jsl   InitFlag                 ;must set up clamp flags
3231 B2E6                       longa on                       ;exit with 16 bit land a must
3232 B2E6                       longi on
3233 B2E6 C2 30                 rep   #$30
3234 B2E8 AB                    plb                            ;restore data bank
3235 B2E9 28                    plp                            ;restore interrupt state
3236 B2EA 4C F7 FB              jmp   oEndcall2
3237 B2ED
3238 B2ED                       ENDP 
3239 B2ED
3240 B2ED              ***********************************************************
3241 B2ED              *
3242 B2ED              * SetMouse - set mouse mode, |MseMode
3243 B2ED              *
3244 B2ED              * Input  word: |MseMode
3245 B2ED              *
3246 B2ED              *            bit7/6, for X clmaping flags
3247 B2ED              *            bit5/4, reserved
3248 B2ED              *            bit3, Interrupt on VBL
3249 B2ED              *            bit2, Interrupt on next VBL if button pressed
3250 B2ED              *            bit1, Interrupt on next CBL if mouse is moved
3251 B2ED              *            bit0, Mouse button off/on (0/1)
3252 B2ED              *
3253 B2ED              ***********************************************************
3254 B2ED              *
3255 B2ED              TSetMou  PROC 
3256 B2ED
3257 B2ED                       longa on
3258 B2ED                       longi on
3259 B2ED
3260 B2ED              ;
3261 B2ED              ; stack structure
3262 B2ED              ;
3263 B2ED              DBreg    equ   1
3264 B2ED              Preg     equ   DBreg+1
3265 B2ED              RTL1     equ   Preg+3                   ;rtl for tool dispatcher
3266 B2ED              RTL2     equ   RTL1+3                   ;rtl for application caller
3267 B2ED              ModeUser equ   RTL2+1                   ;mode set by application
3268 B2ED              ;
3269 B2ED              ErrMode  equ   $1d01                    ;Illegal mode error code
3270 B2ED              ;
3271 B2ED 08                    php                            ;save interrupt status
3272 B2EE 78                    sei                            ;disable interrupt
3273 B2EF 8B                    phb                            ;save data bank
3274 B2F0 20 A6 B0              jsr   setdbtoe1                ;change data bank to $00
3275 B2F3 A3 09                 lda   ModeUser,s               ;get input mode
3276 B2F5              ;
3277 B2F5                       longa off
3278 B2F5                       longi off
3279 B2F5 E2 30                 sep   #$30                     ;8-bit m/x
3280 B2F7 A8                    tay                            ;temp store the mode
3281 B2F8 29 F0                 and   #$f0                     ;chk for legal mode
3282 B2FA D0 37                 bne   BadMode                  ;bra if illegal mode
3283 B2FC
3284 B2FC 98                    tya                            ;get back mode
3285 B2FD 6A                    ror   a                        ;test mouse on/off bit
3286 B2FE 08                    php                            ;c=1=enable mouse and z=0=turn ints on
3287 B2FF A9 0F                 lda   #$0f                     ;reset bits 0,1,2,3
3288 B301 1C 97 01              trb   |MseMode
3289 B304 98                    tya                            ;recall user mode nibble
3290 B305 0C 97 01              tsb   |MseMode                 ;put new mode in lo nibble
3291 B308 29 08                 and   #$08                     ;make irq.mousvbl=0 if no VBL to user
3292 B30A 8D D7 00              sta   |irq_MousVbl             ;make irq.mousvbl <>0 if VBL to user
3293 B30D 28                    plp                            ;what should be done?
3294 B30E 90 0C                 bcc   DisMouse                 ;bra to disable mouse
3295 B310 98                    tya                            ;recall mode byte
3296 B311 29 06                 and   #$06                     ;bit2=button int, bit1=movement bit
3297 B313 F0 07                 beq   DisMouse                 ;if =0 then no mouse ints except VBL
3298 B315
3299 B315 A9 40                 lda   #$40                     ;else only bit3<>0, alter it in gloo
3300 B317 0C 27 C0              tsb   |kmstatus                ;alter the interrupt bit in keygloo
3301 B31A 80 05                 bra   EndSet
3302 B31C              ;
3303 B31C              DisMouse                                ; 
3304 B31C A9 40                 lda   #$40                     ;alter the bit in Kmstatus
3305 B31E 1C 27 C0              trb   |kmstatus
3306 B321              ;
3307 B321              EndSet                                  ; 
3308 B321 98                    tya                            ;see if we should turn on VBL ints too
3309 B322 29 08                 and   #$08                     ;bit3, interrupt on VBL
3310 B324 F0 03                 beq   EndSet1                  ;exit if not enabled
3311 B326 0C 41 C0              tsb   |inten                   ;enable VBL interrupt
3312 B329              ;
3313 B329              EndSet1                                 ; 
3314 B329 20 E1 B1              jsr   GetMdata                 ;reset keygloo mouse information
3315 B32C                       longa on
3316 B32C                       longi on
3317 B32C C2 30                 rep   #$30                     ;16-bit m/x exits a must
3318 B32E AB                    plb                            ;restore data bank register
3319 B32F 28                    plp                            ;restore interrupt state
3320 B330 4C F7 FB              jmp   oEndcall2                ;exit tool by adjusting stack ptr
3321 B333              ;
3322 B333              BadMode                                 ; 
3323 B333                       longa on
3324 B333                       longi on
3325 B333 C2 30                 rep   #$30                     ;16 bit m/x exits a must
3326 B335 A9 01 1D              lda   #ErrMode
3327 B338 AB                    plb   
3328 B339 28                    plp   
3329 B33A 38                    sec                            ;c=1 error mode 
3330 B33B 4C FC FB              jmp   oErrout2
3331 B33E              ;
3332 B33E                       ENDP 
3333 B33E
3334 B33E              ********************************************************************
3335 B33E              *
3336 B33E              * HomeMouse - set mouse to upper-left corner of clamping window
3337 B33E              *             or saying position mouse at minimum clamp position
3338 B33E              *
3339 B33E              ********************************************************************
3340 B33E              *
3341 B33E              HomeGlue PROC 
3342 B33E
3343 B33E                       longa on
3344 B33E                       longi on
3345 B33E              ;
3346 B33E              ; The stack is not affected by this call, from toolcall point of view
3347 B33E              ;
3348 B33E 08                    php                            ;save interrupt state on entry
3349 B33F 78                    sei                            ;disable interrupt
3350 B340 8B                    phb                            ;save data bank register
3351 B341 20 A6 B0              jsr   setdbtoe1                ;change data bank register to $00
3352 B344                       longa off
3353 B344                       longi off
3354 B344 E2 30                 sep   #$30                     ;off to 8 bit land
3355 B346 AD B8 02              lda   |LowXclamp
3356 B349 8D 92 01              sta   |HighAbsx
3357 B34C AD B9 02              lda   |LowXclamp+1
3358 B34F 8D 90 01              sta   |LowAbsx
3359 B352 AD BA 02              lda   |LowYclamp
3360 B355 8D 93 01              sta   |HighAbsy
3361 B358 AD BB 02              lda   |LowYclamp+1
3362 B35B 8D 91 01              sta   |LowAbsy
3363 B35E              ;
3364 B35E              HomeExit                                ; 
3365 B35E 20 E1 B1              jsr   GetMdata                 ;exit via reset keygloo mouse info
3366 B361                       longa on
3367 B361                       longi on
3368 B361 C2 30                 rep   #$30                     ;off to 16 bit land
3369 B363 AB                    plb                            ;restore data bank
3370 B364 28                    plp                            ;restore interrupt state
3371 B365 4C DF FB              jmp   oEndCall0                ;exit the tool
3372 B368
3373 B368                       ENDP 
3374 B368
3375 B368              *******************************************************************
3376 B368              *
3377 B368              * ClearMouse - Reset buttons, movement and interrupt status to 0.
3378 B368              *              Set screen holes to $0000.
3379 B368              *
3380 B368              ********************************************************************
3381 B368              *
3382 B368              ClearGlue PROC 
3383 B368
3384 B368                       longa on
3385 B368                       longi on
3386 B368              ;
3387 B368              ; stacks from the tool call are not affected
3388 B368              ; no input or output parameters are required
3389 B368              ;
3390 B368 08                    php                            ;save interrupt state
3391 B369 78                    sei                            ;disable interrupt
3392 B36A 8B                    phb                            ;save data bank
3393 B36B 20 A6 B0              jsr   setdbtoe1                ;change data bank to $00
3394 B36E              ;
3395 B36E                       longa off
3396 B36E                       longi off
3397 B36E E2 30                 sep   #$30                     ;off to 8 bit land
3398 B370 9C 90 01              stz   |LowAbsx                 ;clear screen holes
3399 B373 9C 91 01              stz   |LowAbsy
3400 B376 9C 92 01              stz   |HighAbsx
3401 B379 9C 93 01              stz   |HighAbsy
3402 B37C 9C 96 01              stz   |MseStat                 ;clear mouse status also
3403 B37F 20 E1 B1              jsr   GetMdata                 ;reset keygloo mouse information also
3404 B382              ;
3405 B382                       longa on
3406 B382                       longi on
3407 B382 C2 30                 rep   #$30                     ;off to 16 bit land
3408 B384 AB                    plb                            ;restore data bank
3409 B385 28                    plp                            ;restore interrupt state
3410 B386 4C DF FB              jmp   oEndCall0                ;exit with c=0, A=0
3411 B389
3412 B389                       ENDP 
3413 B389
3414 B389              ***************************************************************
3415 B389              *
3416 B389              * ClampMouse - set mouse bounds in a window and then set
3417 B389              *              mouse positions to the minimum clamp values
3418 B389              *
3419 B389              * Input  word: X axis minimum clamp
3420 B389              * Input  word: X axis maximum clamp
3421 B389              * Input  word: Y axis minimum clamp
3422 B389              * Input  word: Y axis maximum clamp
3423 B389              *
3424 B389              ***************************************************************
3425 B389              *
3426 B389              TClmpMou PROC 
3427 B389
3428 B389
3429 B389                       longa on
3430 B389                       longi on
3431 B389              ;
3432 B389              ; stack structure
3433 B389              ;
3434 B389              DBreg    equ   1
3435 B389              Preg     equ   DBreg+1
3436 B389              RTL1     equ   Preg+1
3437 B389              RTL2     equ   RTL1+3
3438 B389              YMaxLo   equ   RTL2+3
3439 B389              YMaxHi   equ   YMaxLo+1
3440 B389              YMinLo   equ   YMaxHi+1
3441 B389              YMinHi   equ   YMinLo+1
3442 B389              XMaxLo   equ   YMinHi+1
3443 B389              XMaxHi   equ   XMaxLo+1
3444 B389              XMinLo   equ   XMaxHi+1
3445 B389              XMinHi   equ   XMinLo+1
3446 B389              ;
3447 B389 08                    php                            ;save interrupt state
3448 B38A 78                    sei   
3449 B38B 8B                    phb                            ;save data bank register
3450 B38C 20 A6 B0              jsr   setdbtoe1                ;change data bank reg to $00
3451 B38F              ;
3452 B38F A3 09                 lda   YMaxLo,s                 ;move clamp values from stack to clamp
3453 B391              ;                                       ; locations in RAM $e1 bank for event
3454 B391              ;                                       ; manager
3455 B391 8D BE 02              sta   |HiYclamp                ; 16 bit land
3456 B394 A3 0B                 lda   YMinLo,s
3457 B396 8D BA 02              sta   |LowYclamp
3458 B399 A3 0D                 lda   XMaxLo,s
3459 B39B 8D BC 02              sta   |HiXclamp
3460 B39E A3 0F                 lda   XMinLo,s
3461 B3A0 8D B8 02              sta   |LowXclamp
3462 B3A3 22 93 B4 FE           jsl   InitFlag                 ;update clamp flags
3463 B3A7
3464 B3A7                       longa on
3465 B3A7                       longi on
3466 B3A7 C2 30                 rep   #$30                     ;off to 16 bit land
3467 B3A9 F4 00 00              pea   $0000
3468 B3AC F4 00 00              pea   $0000
3469 B3AF F4 00 00              pea   $0000
3470 B3B2 4B                    phk                            ;dummy 3 bytes
3471 B3B3 62 04 00              per   clmpxit-1                ;part of 3 dummy bytes
3472 B3B6 22 F9 B0 FE           jsl   >TRdMou                  ;execute ReadMouse to reflect new clmps
3473 B3BA 6B                    rtl                            ;remove 3 dummy bytes and go to next
3474 B3BB
3475 B3BB              clmpxit                                 ; 
3476 B3BB 68                    pla                            ;remove 3 more words from ReadMouse
3477 B3BC 68                    pla   
3478 B3BD 68                    pla   
3479 B3BE
3480 B3BE AB                    plb                            ;restore data bank
3481 B3BF 28                    plp                            ;restore interrupt state during entry
3482 B3C0 4C 39 FC              jmp   oEndCall8                ;exit the tool
3483 B3C3
3484 B3C3                       ENDP 
3485 B3C3
3486 B3C3              ******************************************************************
3487 B3C3              *
3488 B3C3              * GetClamp - Read the current clamp values
3489 B3C3              *
3490 B3C3              * Input  word: don't care
3491 B3C3              * Input  word: don't care
3492 B3C3              * Input  word: don't care
3493 B3C3              * Input  word: don't care
3494 B3C3              * Output word: Y maximum clamp
3495 B3C3              * Output word: Y mimimum clamp
3496 B3C3              * Output word: X Maximum clamp
3497 B3C3              * Output word: X minimum clamp
3498 B3C3              *
3499 B3C3              ******************************************************************
3500 B3C3              *
3501 B3C3              TGetClamp PROC 
3502 B3C3
3503 B3C3                       longa on
3504 B3C3                       longi on
3505 B3C3              ;
3506 B3C3              ; stack structure
3507 B3C3              ; no change for data bank register
3508 B3C3              ;
3509 B3C3                       DefineStack 
3510 B3C3              Preg     byte 
3511 B3C3              Breg     byte 
3512 B3C3              RTL1     block 3 
3513 B3C3              RTL2     block 3 
3514 B3C3              MaxY     word 
3515 B3C3              MinY     word 
3516 B3C3              MaxX     word 
3517 B3C3              MinX     word 
3518 B3C3              ;
3519 B3C3 08                    php                            ;save interrupt state
3520 B3C4 78                    sei                            ;disable interrupt
3521 B3C5 8B                    phb                            ;save data bank register
3522 B3C6 20 A6 B0              jsr   setdbtoe1
3523 B3C9 AD BE 02              lda   |HiYclamp                ;move clamp values to stack
3524 B3CC 83 09                 sta   MaxY,s
3525 B3CE AD BA 02              lda   |LowYclamp
3526 B3D1 83 0B                 sta   MinY,s
3527 B3D3 AD BC 02              lda   |HiXclamp
3528 B3D6 83 0D                 sta   MaxX,s
3529 B3D8 AD B8 02              lda   |LowXclamp
3530 B3DB 83 0F                 sta   MinX,s
3531 B3DD AB                    plb                            ;restore data bank register
3532 B3DE 28                    plp                            ;restore interrupt
3533 B3DF
3534 B3DF 4C DF FB              jmp   oEndCall0                ;exit tool
3535 B3E2
3536 B3E2                       ENDP 
3537 B3E2
3538 B3E2              ************************************************************
3539 B3E2              *
3540 B3E2              * PosMouse - set mouse position to user-defined position
3541 B3E2              *
3542 B3E2              * Input  word: X position
3543 B3E2              * Input  word: Y position
3544 B3E2              *
3545 B3E2              ************************************************************
3546 B3E2              *
3547 B3E2              TPosMou  PROC 
3548 B3E2
3549 B3E2                       longa on
3550 B3E2                       longi on
3551 B3E2              ;
3552 B3E2              ; stack structure
3553 B3E2              ;
3554 B3E2              DBreg    equ   1
3555 B3E2              Preg     equ   DBreg+1
3556 B3E2              RTL1     equ   Preg+1
3557 B3E2              RTL2     equ   RTL1+3
3558 B3E2              Ypos     equ   RTL2+3
3559 B3E2              Xpos     equ   Ypos+2
3560 B3E2              ;
3561 B3E2 08                    php                            ;save interrupt state
3562 B3E3 78                    sei                            ;disable interrupt
3563 B3E4 8B                    phb                            ;save data bank register
3564 B3E5 20 A6 B0              jsr   setdbtoe1
3565 B3E8                       longa off
3566 B3E8                       longi off
3567 B3E8 E2 30                 sep   #$30                     ;off to 8 bit land
3568 B3EA A3 0C                 lda   Xpos+1,s                 ;move position to screen holes
3569 B3EC 8D 92 01              sta   |HighAbsx
3570 B3EF A3 0B                 lda   Xpos,s
3571 B3F1 8D 90 01              sta   |LowAbsx
3572 B3F4 A3 0A                 lda   Ypos+1,s
3573 B3F6 8D 93 01              sta   |HighAbsy
3574 B3F9 A3 09                 lda   Ypos,s
3575 B3FB 8D 91 01              sta   |LowAbsy
3576 B3FE 20 E1 B1              jsr   GetMdata                 ;also reset keygloo mouse information
3577 B401                       longa on
3578 B401                       longi on
3579 B401 C2 30                 rep   #$30                     ;back to 16 bit land for exit
3580 B403 AB                    plb                            ;restore data bank
3581 B404 28                    plp                            ;restore interrupt state
3582 B405 4C 0D FC              jmp   oEndCall4
3583 B408
3584 B408                       ENDP 
3585 B408
3586 B408              **************************************************************
3587 B408              *
3588 B408              * ServeMouse - Service mouse interrupt
3589 B408              *              Update interrupt status bit at screen hole ($077c)
3590 B408              *              to show current status
3591 B408              *
3592 B408              * Input  word: Space, don't care
3593 B408              * Output word: Interrupt status
3594 B408              **************************************************************
3595 B408              *
3596 B408              TServMou PROC 
3597 B408
3598 B408                       longa on
3599 B408                       longi on
3600 B408              ;
3601 B408              ; stack structure
3602 B408              ;
3603 B408              DBreg    equ   1
3604 B408              Preg     equ   DBreg+1
3605 B408              RTL1     equ   Preg+1
3606 B408              RTL2     equ   RTL1+3
3607 B408              IntStat  equ   RTL2+3
3608 B408
3609 B408
3610 B408 08                    php                            ;save interrupt status on entry
3611 B409 78                    sei                            ;disable interrupt
3612 B40A 8B                    phb                            ;save data bank
3613 B40B 20 A6 B0              jsr   setdbtoe1                ;change data bank to $00
3614 B40E                       longa off
3615 B40E                       longi off
3616 B40E E2 30                 sep   #$30                     ;off to 8-bit land
3617 B410 A9 0E                 lda   #$0e                     ;reset bit3, VBL interrupt
3618 B412              ;                                       ;      bit2, Button 0/1 interrupt
3619 B412              ;                                       ;      bit1, Movement interrupt
3620 B412 1C 96 01              trb   |MseStat                 ;cause to reset
3621 B415 AD C3 00              lda   |irq_Intflag             ;test VBL enabled/active status flag
3622 B418 A8                    tay                            ;temp store
3623 B419 29 08                 and   #$08                     ;bit3 = 1, if vbl interrupted
3624 B41B F0 0B                 beq   NotVbl                   ;bra if not vbl interrupt, don't reset
3625 B41D 8D 47 C0              sta   |ClrVblint               ;else disable vbl interrupt, $c047
3626 B420 98                    tya                            ;get back intflag
3627 B421 29 F7                 and   #$f7                     ; to clr the vbl interrupt stat
3628 B423 8D C3 00              sta   |irq_Intflag             ; clear it
3629 B426 A9 08                 lda   #$08                     ;prepare bit to update |MseStat
3630 B428
3631 B428              NotVbl                                  ; 
3632 B428 A8                    tay                            ;save status
3633 B429 0C 96 01              tsb   |MseStat                 ;update mouse state screen hole
3634 B42C 2C 27 C0              bit   |kmstatus                ;chk for mouse info in gloo
3635 B42F 50 08                 bvc   MseIntdis                ;bra if mouse interrupts noe enabled
3636 B431 10 06                 bpl   MseIntdis                ;bra if ints enabled but mse didn't int
3637 B433 A9 0E                 lda   #$0e                     ;chk what's ints status
3638 B435 A8                    tay                            ; set 'y' non-zero for exit from here
3639 B436 0C 96 01              tsb   |MseStat                 ;Update |MseStat, $077c
3640 B439
3641 B439              MseIntdis                               ; 
3642 B439 98                    tya                            ;test if mousey interrupt or not
3643 B43A AD 96 01              lda   |MseStat                 ;finally read back the new status
3644 B43D 83 09                 sta   IntStat,s                ;store to proper location in stack
3645 B43F                                                      ; for application to read it
3646 B43F AB                    plb                            ;restore data bank register
3647 B440 28                    plp                            ;restore interrupt status
3648 B441 98                    tya                            ;test if mousey interrupt or not
3649 B442 F0 03                 beq   NotMseInt                ;bra for not mousey type interrupt
3650 B444 18                    clc                            ;maintain compatibility for firmware call
3651 B445 80 01                 bra   ExitSerMse
3652 B447
3653 B447              NotMseInt                               ;
3654 B447 38                    sec                            ;maintain compatibility for firmware call
3655 B448              ExitSerMse                              ;
3656 B448                       longa on
3657 B448                       longi on
3658 B448 C2 30                 rep   #$30                     ;off to 16-bit land a must
3659 B44A 4C DF FB              jmp   oEndcall0                ;exit the tool
3660 B44D
3661 B44D                       ENDP 
3662 B44D
3663 B44D              ****************************************************************
3664 B44D              *
3665 B44D              * GetAbsclamp - get	absolute clamp values
3666 B44D              *
3667 B44D              * Input  word: Space for result
3668 B44D              * Input  word: Space for result
3669 B44D              * Input  word: Space for result
3670 B44D              * Input  word: Space for result
3671 B44D              *	            <----- sp
3672 B44D              * Output word: X minimum clamp
3673 B44D              * Output word: X maximum clamp
3674 B44D              * Output word: Y minimum clamp
3675 B44D              * Output word: Y maximum clamp
3676 B44D              *	            <----- sp
3677 B44D              *
3678 B44D              ***************************************************************
3679 B44D              ;
3680 B44D              GetAbsClamp PROC 
3681 B44D
3682 B44D                       longa on
3683 B44D                       longi on
3684 B44D
3685 B44D              ;
3686 B44D              ; stack structure
3687 B44D              ;
3688 B44D              RTL1     equ   1
3689 B44D              RTL2     equ   RTL1+3
3690 B44D              MaxY     equ   RTL2+3
3691 B44D              MinY     equ   MaxY+2
3692 B44D              MaxX     equ   MinY+2
3693 B44D              MinX     equ   MaxX+2
3694 B44D
3695 B44D AF D0 1D E1           lda   >AbsClamps               ;move clamps to stack
3696 B451 83 0D                 sta   MinX,s
3697 B453 AF D2 1D E1           lda   >AbsClamps+2
3698 B457 83 09                 sta   MinY,s
3699 B459 AF D4 1D E1           lda   >AbsClamps+4
3700 B45D 83 0B                 sta   MaxX,s
3701 B45F AF D6 1D E1           lda   >AbsClamps+6
3702 B463 83 07                 sta   MaxY,s
3703 B465
3704 B465 4C DF FB              jmp   oEndCall0
3705 B468
3706 B468                       ENDP 
3707 B468
3708 B468              ********************************************************************
3709 B468              *
3710 B468              * SetAbsclamp - set absolute device clamp values
3711 B468              *
3712 B468              * Input  word: X axis minimum clamp
3713 B468              * Input  word: X axis maximum clamp
3714 B468              * Input  word: Y axis minimum clamp
3715 B468              * Input  word: Y axis maximum clamp
3716 B468              *	               <----- sp
3717 B468              *
3718 B468              ********************************************************************
3719 B468              *
3720 B468              SetAbsClamp PROC 
3721 B468
3722 B468                       longa on
3723 B468                       longi on
3724 B468
3725 B468              ;
3726 B468              ; stack structure
3727 B468              ;
3728 B468              RTL1     equ   1
3729 B468              RTL2     equ   RTL1+3
3730 B468              Ymax     equ   RTL2+3
3731 B468              Ymin     equ   Ymax+2
3732 B468              Xmax     equ   Ymin+2
3733 B468              Xmin     equ   Xmax+2
3734 B468
3735 B468 A3 0D                 lda   Xmin,s                   ;move clamps from stack to its area
3736 B46A 8F D0 1D E1           sta   >AbsClamps
3737 B46E A3 09                 lda   Ymin,s
3738 B470 8F D2 1D E1           sta   >AbsClamps+2
3739 B474 A3 0B                 lda   Xmax,s
3740 B476 8F D4 1D E1           sta   >AbsClamps+4
3741 B47A A3 07                 lda   Ymax,s
3742 B47C 8F D6 1D E1           sta   >AbsClamps+6
3743 B480
3744 B480 4C 39 FC              jmp   oEndCall8                ;exit tool by adjusting stack ptr
3745 B483
3746 B483                       ENDP 
3747 B483
3748 B483              *********************************************************************
3749 B483              *
3750 B483              * BasicInit - An unofficial tool to set up the clamp flags when
3751 B483              *             calling from BASICMOUSE.
3752 B483              * InitFlag  - The flags are returned in bits 6, 7 of 'A'.
3753 B483              *             Called during power up, InitMouse, ClampMouse and
3754 B483              *             BASICMOUSE (firmware).
3755 B483              *
3756 B483              * The following is a break down of what the clamping flags mean.  The
3757 B483              * X flag is in bits 6, 7 of |MseMode byte and the Y flag is in bits 6, 7
3758 B483              * of the Info byte.
3759 B483              *
3760 B483              *   Hi nibble  Lo nibble   Comments
3761 B483              *--------------------------------------------------------------------
3762 B483              *   for X
3763 B483              *    A: 00xx   xxxx        both x clamps are +
3764 B483              *       01xx   xxxx        min is - / max is +
3765 B483              *       10xx   xxxx        both x clamps are -
3766 B483              *       11xx   xxxx        min is + / max is -
3767 B483              *                          absolute clamping
3768 B483              *
3769 B483              *   for Y
3770 B483              *    A: 00xx   xxxx       both y clamps are +
3771 B483              *       01xx   xxxx       min is - / max is +
3772 B483              *       10xx   xxxx       both y clamps are -
3773 B483              *       11xx   xxxx       min is + / max is -
3774 B483              *                         absolute clamping
3775 B483              *
3776 B483              ***********************************************************************
3777 B483              *
3778 B483              MyBasicInit PROC                        ;support entry for BASICMOUSE
3779 B483
3780 B483                       longa on
3781 B483                       longi on
3782 B483              ;
3783 B483              ; The stack is not affected by this call.  Only BASICMOUSE is an external
3784 B483              ; call to this tool, all others are internal call in the tool.
3785 B483              ;
3786 B483 8B                    phb                            ;save data bank register
3787 B484 20 A6 B0              jsr   setdbtoe1                ;change data bank to $00
3788 B487                       longa off
3789 B487                       longi off
3790 B487 E2 30                 sep   #$30                     ;off to 8 bit land
3791 B489 22 93 B4 FE           jsl   >InitFlag
3792 B48D              ;
3793 B48D                       longa on
3794 B48D                       longi on
3795 B48D AB                    plb   
3796 B48E C2 30                 rep   #$30                     ;exit with 16 bit land
3797 B490 4C DF FB              jmp   oEndCall0                ;exit from BASICMOUSE call
3798 B493
3799 B493
3800 B493              InitFlag PROC 
3801 B493              ;
3802 B493                       longa off
3803 B493                       longi off                      ;enter w/ 8 bit mode
3804 B493 E2 30                 sep   #$30
3805 B495              ;
3806 B495 A2 00                 ldx   #$00                     ;$00 for x-axis clamping
3807 B497 A9 C0                 lda   #$c0                     ;ready to clear bits 6, 7
3808 B499 1C 97 01              trb   |MseMode                 ;reset it
3809 B49C 1C 94 01              trb   |MseInfo                 ;reset it
3810 B49F 20 FC B4              jsr   TstSwap4                 ;go set a flag, return in 'A'
3811 B4A2 0C 97 01              tsb   |MseMode                 ;set appropriate bits
3812 B4A5 20 17 B5              jsr   TstClampVal8             ;do hi byte test
3813 B4A8 B0 07                 bcs   XOK                      ;x ok now test y
3814 B4AA 2C 97 01              bit   |MseMode                 ;pick up flags in N and V
3815 B4AD 22 C1 B4 FE           jsl   >TstSwap                 ;go test it
3816 B4B1              ;
3817 B4B1              XOK                                     ; 
3818 B4B1 A2 02                 ldx   #$02                     ;$02 for y-axis clamping
3819 B4B3 20 FC B4              jsr   TstSwap4                 ;go set a flag
3820 B4B6 0C 94 01              tsb   |MseInfo                 ;set appropriate bits
3821 B4B9 20 17 B5              jsr   TstClampVal8             ;do hi byte test
3822 B4BC B0 3D                 bcs   Tstclrts                 ;exit with 'c'=1
3823 B4BE 2C 94 01              bit   |MseInfo                 ;else pick up flags and test
3824 B4C1              ;
3825 B4C1              TstSwap                                 ;swap clamp values
3826 B4C1 70 38                 bvs   Tstclrts                 ;no swap if flag = 0 or 1
3827 B4C3 10 02                 bpl   PosNegnum                ;'+' only if 2 pos # entered
3828 B4C5 E2 40                 sep   #$40                     ;'v'=1 if 2 neg # entered
3829 B4C7              PosNegnum                               ; 
3830 B4C7                       longa on
3831 B4C7                       longi on
3832 B4C7 C2 30                 rep   #$30                     ;off to 16 bit land
3833 B4C9 BD B8 02              lda   |LowXclamp,x
3834 B4CC 70 20                 bvs   JustSwap                 ;'v'=0 then just swap
3835 B4CE 89 00 FF              bit   #$ff00                   ;else test if illegal '-' number
3836 B4D1 D0 1B                 bne   JustSwap                 ;do regular swap
3837 B4D3 89 80 00              bit   #$0080                   ;test for illegal '-' number
3838 B4D6 F0 16                 beq   JustSwap                 ;do regular swap
3839 B4D8 09 00 FF              ora   #$ff00                   ;else extend sign to hi byte
3840 B4DB 9D B8 02              sta   |LowXclamp,x             ;resave modified clamp
3841 B4DE              ;
3842 B4DE                       longa off
3843 B4DE                       longi off
3844 B4DE E2 30                 sep   #$30                     ;back to 8 bit land
3845 B4E0 A9 40                 lda   #$40                     ;change bit 6,7 (00) to (01)
3846 B4E2 E0 02                 cpx   #$02                     ;2 if change info else change |MseMode
3847 B4E4 D0 04                 bne   ChMseMode                ;
3848 B4E6 0C 94 01              tsb   |MseInfo                 ;set bit 6
3849 B4E9 6B                    rtl   
3850 B4EA              ;
3851 B4EA              ChMseMode                               ; 
3852 B4EA 0C 97 01              tsb   |MseMode                 ;set bit 6
3853 B4ED 6B                    rtl   
3854 B4EE              ;
3855 B4EE              JustSwap                                ; 
3856 B4EE                       longa on
3857 B4EE                       longi on                       ;enter with 16 bit m/x
3858 B4EE A8                    tay                            ;save in y
3859 B4EF BD BC 02              lda   |HiXclamp,x              ;high clamp swap with low clamp
3860 B4F2 9D B8 02              sta   |LowXclamp,x
3861 B4F5 98                    tya                            ;for indirect, bridge...
3862 B4F6 9D BC 02              sta   |HiXclamp,x
3863 B4F9                       longa off
3864 B4F9                       longi off
3865 B4F9 E2 30                 sep   #$30                     ;back to 8 bit land
3866 B4FB              ;
3867 B4FB              Tstclrts                                ; 
3868 B4FB 6B                    rtl                            ;back to caller
3869 B4FC              ;
3870 B4FC              TstSwap4                                ; 
3871 B4FC BD BD 02              lda   |HiXclamp+1,x            ;get hi clamp hi byte
3872 B4FF 08                    php                            ;save for later
3873 B500 BD B9 02              lda   |LowXclamp+1,x           ;get low clamp hi byte
3874 B503 30 09                 bmi   LowclampNeg              ;bra if low clamp -
3875 B505 28                    plp                            ;what about hi clamp hi byte
3876 B506 30 03                 bmi   Flag3                    ;if - set flag 3
3877 B508 A9 00                 lda   #$00                     ;must set flag to 0
3878 B50A 60                    rts                            ;return to internal call
3879 B50B              ;
3880 B50B              Flag3                                   ; 
3881 B50B A9 C0                 lda   #$c0                     ;flag = 3
3882 B50D 60                    rts   
3883 B50E              ;
3884 B50E              LowclampNeg                             ; 
3885 B50E 28                    plp                            ;what was sign of hi byte
3886 B50F 30 03                 bmi   Flag2                    ;if - then use flag 2
3887 B511 A9 40                 lda   #$40                     ;flag = 1
3888 B513 60                    rts   
3889 B514              ;
3890 B514              Flag2                                   ; 
3891 B514 A9 80                 lda   #$80                     ;flag = 2
3892 B516 60                    rts   
3893 B517              ;
3894 B517              TstClampval8                            ; 
3895 B517                       longa on
3896 B517                       longi on
3897 B517 C2 30                 rep   #$30                     ;off to 16 bit land
3898 B519 BD BC 02              lda   |HiXclamp,x              ;test hi clamp
3899 B51C DD B8 02              cmp   |LowXclamp,x             ; against low clamp
3900 B51F                       longa off
3901 B51F                       longi off
3902 B51F E2 30                 sep   #$30                     ;back to 8 bit land
3903 B521 60                    rts   
3904 B522              ;
3905 B522                       ENDP 
3906 B522
3907 B522
3908 B522
3909 B522                       title 'FWEntry'
3910 B522              ****************************************************************
3911 B522              *
3912 B522              * Full Native Dispatch to Firmware
3913 B522              *
3914 B522              * Input     Word  Entry point - 1
3915 B522              *
3916 B522              * This routine dispatches from full native mode to an emulation
3917 B522              * mode entry point.   The 8 bit A,X and Y registers will be
3918 B522              * passed through to the target routine.   A,X and Y will also
3919 B522              * be returned to the application from the target routine.
3920 B522              * If the dispatch is in the address range of $C0xx-$C7xx, then
3921 B522              * the dispatcher must determine if the slot to be accessed is
3922 B522              * internal or external.  If external, then the system speed is
3923 B522              * kicked down to slow mode.
3924 B522              *
3925 B522              ****************************************************************
3926 B522
3927 B522
3928 B522              FwEntry  PROC EXPORT 
3929 B522
3930 B522              DirReg   equ   1
3931 B522              OrigState equ   DirReg+2
3932 B522              OrigCya  equ   OrigState+1
3933 B522              OrigDbr  equ   OrigCya+1
3934 B522              OrigAReg equ   OrigDbr+1
3935 B522              EntryWord equ   OrigAReg+1
3936 B522              RetAddr1 equ   EntryWord+2
3937 B522
3938 B522 E2 30                 sep   #$30                     ; 8 bit m/x
3939 B524                       longa off
3940 B524                       longi off
3941 B524 48                    pha                            ; save processor environment
3942 B525 8B                    phb   
3943 B526 A9 00                 lda   #0
3944 B528 48                    pha   
3945 B529 AB                    plb   
3946 B52A AD 36 C0              lda   |CyaReg                  ; save current system speed
3947 B52D 48                    pha   
3948 B52E AD 68 C0              lda   |StateReg
3949 B531 48                    pha   
3950 B532 A9 08                 lda   #%00001000
3951 B534 8D 68 C0              sta   |StateReg
3952 B537 0B                    phd   
3953 B538 3B                    tsc   
3954 B539 5B                    tcd   
3955 B53A DA                    phx                            ; save $Cn
3956 B53B C2 20                 rep   #$20                     ; 16 bit 'm'
3957 B53D A5 07                 lda   EntryWord                ; get dispatch page
3958 B53F 1A                    inc   a                        ; adjust to absolute entry point
3959 B540 EB                    xba                            ; get high byte entry point
3960 B541 E2 20                 sep   #$20                     ; 8 bit 'm'
3961 B543 C9 C8                 cmp   #$C8                     ; $C000 < EntryPoint < $C800 ?
3962 B545 B0 2A                 bge   NotIO                    ; no
3963 B547 29 F0                 and   #$F0
3964 B549 C9 C0                 cmp   #$C0
3965 B54B D0 24                 bne   NotIO                    ; if not in $Cxxx space
3966 B54D C2 20                 rep   #$20                     ; 16 bit 'm'
3967 B54F A5 07                 lda   EntryWord                ; get dispatch page
3968 B551 1A                    inc   a                        ; adjust to absolute entry point
3969 B552 EB                    xba                            ; want $Cn
3970 B553 E2 20                 sep   #$20                     ; 8 bit 'm'
3971 B555 29 07                 and   #$07                     ; determine the slot were going to
3972 B557 C9 03                 cmp   #$03                     ; is it slot 3?
3973 B559 D0 08                 bne   NotSlot3                 ; no
3974 B55B AF 17 C0 00           lda   >RDC3ROM                 ; is slot 3 internal or external ?
3975 B55F 29 80                 and   #%10000000               ; mask excess bits
3976 B561 80 0B                 bra   SetSpeed                 ; if external, set slow!
3977 B563              NotSlot3                                ; 
3978 B563 AA                    tax   
3979 B564 AD 2D C0              lda   |SltRomSel               ; now get slot rom selection
3980 B567              SlowChk                                 ; 
3981 B567 6A                    ror   a                        ; get internal/external to 'c'
3982 B568 CA                    dex   
3983 B569 10 FC                 bpl   SlowChk
3984 B56B A9 00                 lda   #0                       ; get ready to set system speed
3985 B56D 6A                    ror   a                        ; bit 7 = not speed
3986 B56E              SetSpeed                                ; 
3987 B56E 1C 36 C0              trb   |CyaReg                  ; set the system speed
3988 B571              NotIO                                   ; 
3989 B571 FA                    plx                            ; restore $Cn
3990 B572 C2 30                 rep   #$30                     ; 16 bit m/x
3991 B574                       longa on
3992 B574                       longi on
3993 B574
3994 B574              ****************************************************************
3995 B574              *
3996 B574              * This saves the states of the 8 bit X and Y while
3997 B574              * we play around with switching the stack from native
3998 B574              * mode to emulation mode.   If the native stack is not in
3999 B574              * page $01, then the 16 bit stack pointer must be saved while
4000 B574              * the stack pointer is reset to Main memory stack page $01XX.
4001 B574              * Then the 16 bit native mode stack pointer is saved on the
4002 B574              * emulation mode stack. It's strange, but neccessary.
4003 B574              *
4004 B574              ****************************************************************
4005 B574
4006 B574 8A                    txa                            ; get 8 bit X
4007 B575 EB                    xba                            ; save it
4008 B576 E2 20                 sep   #$20                     ; 8 bit 'm'
4009 B578 98                    tya                            ; now get 8 bit Y
4010 B579 C2 20                 rep   #$20                     ; 16 bit 'm'
4011 B57B AA                    tax                            ; now X really has both X and Y
4012 B57C 3B                    tsc                            ; get current stack pointer
4013 B57D A8                    tay                            ; and save in Y register
4014 B57E E2 20                 sep   #$20                     ; 8 bit 'm'
4015 B580                       longa off
4016 B580 EB                    xba                            ; check if stack is in page $01
4017 B581 3A                    dec   a
4018 B582 F0 0A                 beq   AlreadyPG1               ; if page 1, then don't get it
4019 B584 A9 01                 lda   #1                       ; stack will be in page 1
4020 B586 EB                    xba   
4021 B587 AF 00 01 01           lda   >MNEMSTKPTR              ; get low byte of stack pointer
4022 B58B C2 20                 rep   #$20                     ; 16 bit 'm'
4023 B58D                       longa on
4024 B58D 1B                    tcs                            ; set the page 1 stack pointer
4025 B58E              AlreadyPG1                              ; 
4026 B58E 5A                    phy                            ; and save the 16 bit stack pointer
4027 B58F C2 20                 rep   #$20                     ; 16 bit 'm'
4028 B591 8A                    txa                            ; get back both X and Y
4029 B592 E2 30                 sep   #$30                     ; 8 bit 'm' & 'x'
4030 B594 A8                    tay                            ; now restore Y
4031 B595 EB                    xba                            ; and then restore X
4032 B596 AA                    tax   
4033 B597 0B                    phd                            ; save current direct register
4034 B598 F4 AE B5              pea   FWRET-1                  ; save return address
4035 B59B AD 15 C0              lda   |RDCXROM                 ; save FE bank evironment
4036 B59E 48                    pha   
4037 B59F C2 20                 rep   #$20                     ; 16 bit 'm'
4038 B5A1 A5 07                 lda   EntryWord                ; save dispatch address
4039 B5A3 48                    pha   
4040 B5A4 E2 30                 sep   #$30                     ; 8 bit m/x
4041 B5A6                       longa off
4042 B5A6                       longi off
4043 B5A6 A5 06                 lda   OrigAReg                 ; get entry 'A' reg
4044 B5A8 F4 00 00              pea   $0000                    ; set direct register to $0000
4045 B5AB 2B                    pld   
4046 B5AC 82 1F 00              brl   ToMainSide               ; here we go
4047 B5AF
4048 B5AF              FWRET                                   ; 
4049 B5AF 2B                    pld                            ; restore direct page
4050 B5B0 85 07                 sta   EntryWord                ; save 'A' on return from firmware
4051 B5B2 08                    php                            ; save 'P' on return from firmware
4052 B5B3 68                    pla   
4053 B5B4 85 08                 sta   EntryWord+1
4054 B5B6 C2 30                 rep   #$30                     ; 16 bit 'x' and 'm'
4055 B5B8 68                    pla                            ; get native mode stack pointer
4056 B5B9 1B                    tcs                            ; and reset the stack pointer
4057 B5BA E2 30                 sep   #$30                     ; 8 bit 'm' and 'x'
4058 B5BC 2B                    pld                            ; restore direct register
4059 B5BD 68                    pla                            ; restore state
4060 B5BE 8D 68 C0              sta   |StateReg
4061 B5C1 68                    pla                            ; restore system speed
4062 B5C2 8D 36 C0              sta   |CyaReg
4063 B5C5 AB                    plb                            ; restore Data Bank Register
4064 B5C6 E2 30                 sep   #$30                     ; 8 bit 'm' and 'x'
4065 B5C8                       longa on
4066 B5C8                       longi on
4067 B5C8 68                    pla                            ; clean entry acc. off stack
4068 B5C9 68                    pla                            ; A reg = value from firmware call
4069 B5CA 28                    plp                            ; P reg = value from firmware call
4070 B5CB C2 30                 rep   #$30                     ; back to 16 bit land
4071 B5CD 60                    rts   
4072 B5CE
4073 B5CE
4074 B5CE
4075 B5CE                       ENDP 
4076 B5CE
4077 B5CE
4078 B5CE
4079 B5CE              ****************************************************************
4080 B5CE              *
4081 B5CE              * This routine used to dispatch to mainside
4082 B5CE              *
4083 B5CE              * ENTRY   :  Rom Enabled
4084 B5CE              *            Native Mode
4085 B5CE              *            8 Bit m/x
4086 B5CE              *            Stack = RDSLOTCXROM
4087 B5CE              *            Dispatch Address-1 (MSB)
4088 B5CE              *            Dispatch Address-1 (LSB)
4089 B5CE              *
4090 B5CE              * EXIT    :  Fast Mode
4091 B5CE              *
4092 B5CE              *
4093 B5CE              ****************************************************************
4094 B5CE              ToMainSide PROC 
4095 B5CE
4096 B5CE                       longa off                      ; start off in 8 bit mode
4097 B5CE                       longi off
4098 B5CE EB                    xba                            ;Preserve 'A' in 'B'
4099 B5CF 8A                    txa                            ;preserve 'X' in 'A'
4100 B5D0 C2 30                 rep   #$30                     ;off to 16 bit land
4101 B5D2                       longa on
4102 B5D2                       longi on
4103 B5D2
4104 B5D2 FA                    plx                            ;save routine address in 'X'
4105 B5D3 4B                    phk                            ;Return bank
4106 B5D4 F4 F7 B5              pea   FEBankRts-1              ;Return address in bank FE
4107 B5D7 F4 D3 F8              pea   MainExit-1               ;Exit point in main monitor ROM
4108 B5DA DA                    phx                            ;Routine to execute back to stack
4109 B5DB E2 30                 sep   #$30                     ;back to 8 bit land
4110 B5DD                       longa off
4111 B5DD                       longi off
4112 B5DD AA                    tax                            ;Restore 'X' from 'A'
4113 B5DE EB                    xba                            ;Restore 'A' from 'B'
4114 B5DF
4115 B5DF              ToMainSid2                              ; 
4116 B5DF EB                    xba                            ;Save 'A' value
4117 B5E0 AF 36 C0 00           lda   >CyaReg                  ;save speed
4118 B5E4 29 7F                 and   #$7F                     ;slow down system
4119 B5E6 0F 38 01 E1           ora   >SystemSpd               ;System speed mask
4120 B5EA 8F 36 C0 00           sta   >CyaReg                  ;
4121 B5EE EB                    xba                            ;Restore user 'A' value
4122 B5EF 8B                    phb                            ;Data bank register is new program bank
4123 B5F0 F4 B4 F8              pea   MainSide-1               ;Main ROM area entry point
4124 B5F3 8F 06 C0 00           sta   >SetSlotCXRom            ;disable internal CxROM
4125 B5F7 6B                    rtl                            ;go to mainside
4126 B5F8
4127 B5F8              FEBankRts                               ; 
4128 B5F8 E2 30                 sep   #$30
4129 B5FA EB                    xba                            ;save user's 'A' value
4130 B5FB 8B                    phb   
4131 B5FC F4 00 00              pea   0
4132 B5FF AB                    plb   
4133 B600 AB                    plb   
4134 B601 A9 80                 lda   #$80                     ;go fast in here
4135 B603 0C 36 C0              tsb   |CyaReg                  ;
4136 B606 A3 02                 lda   2,s                      ; get rom select
4137 B608 10 07                 bpl   SetExtRom                ; if external
4138 B60A 8D 07 C0              sta   |SetIntCxROM             ;Restore bank FE operating environment
4139 B60D              OKforExit                               ; 
4140 B60D AB                    plb   
4141 B60E 68                    pla   
4142 B60F EB                    xba   
4143 B610 60                    rts                            ;Back to bank $FF caller
4144 B611              SetExtRom                               ; 
4145 B611 8D 06 C0              sta   |SetSlotCXROM
4146 B614 80 F7                 bra   OKforExit
4147 B616
4148 B616                       ENDP 
4149 B616
4150 B616
4151 B616
4152 B616                       title 'ID Tag Manager'
4153 B616              *********************************************************************
4154 B616              *
4155 B616              * This tool is used to insert, delete and inquire status
4156 B616              * regarding an ID tag.  The ID tag is used to mark segments
4157 B616              * as belonging to a specific application.
4158 B616              *
4159 B616              * GetNewID
4160 B616              *     Input     Word     Space for result
4161 B616              *     Input     Word     ID tag (Type and Aux)
4162 B616              *     Output    Word     ID tag (Full tag returned)
4163 B616              *
4164 B616              * DeleteID
4165 B616              *     Input     Word     ID tag (Type and Main)
4166 B616              *
4167 B616              * StatusID
4168 B616              *     Input     Word     ID tag (Type and Main)
4169 B616              *
4170 B616              * ID tag structure is shown below.....
4171 B616              *  ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___ ___
4172 B616              * |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
4173 B616              * | F | E | D | C | B | A | 9 | 8 | 7 | 6 | 5 | 4 | 3 | 2 | 1 | 0 |
4174 B616              * |___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|___|
4175 B616              *   |___|___|___| |___|___|___|   |___|___|___|___|___|___|___|
4176 B616              *     |               |               |
4177 B616              *   Type Field Aux ID Field    Main ID Field
4178 B616              *
4179 B616              *  Type = 0  Memory Manager
4180 B616              *         1  Application
4181 B616              *         2  Controlling Program (Finder, Shell, etc.)
4182 B616              *         3  ProDOS
4183 B616              *         4  Tool Kits..................Not managed here.
4184 B616              *         5  Desk Accessories
4185 B616              *         6  Run Time Libraries
4186 B616              *         7  System loader..............Not managed here
4187 B616              *         8  Firmware / System Function
4188 B616              *         9  Tool Locator...............Not managed here.
4189 B616              *         A  Setup File
4190 B616              *         B  Undefined
4191 B616              *         C  Undefined
4192 B616              *         D  Undefined
4193 B616              *         E  Undefined
4194 B616              *         F  Undefined
4195 B616              *
4196 B616              * Change History
4197 B616              *
4198 B616              * 13 Nov 88	Steven Glass
4199 B616              *
4200 B616              * No longer manage ID 4000, 7000 or 9000. (These are used
4201 B616              * throughout the system without anyone reserving them.  so we
4202 B616              * return error when someone trys to reserve them).
4203 B616              *
4204 B616              * Also removed unnecessary Hlock and hUnlock calls.
4205 B616              *
4206 B616              *
4207 B616              *********************************************************************
4208 B616              GetNewID PROC 
4209 B616                       longa on
4210 B616                       longi on
4211 B616
4212 B616              taglist  equ   1
4213 B616              size     equ   taglist+4
4214 B616              SrchTag  equ   size+2
4215 B616              SrchCnt  equ   SrchTag+2
4216 B616              OrigDBR  equ   SrchCnt+2
4217 B616              OrigDir  equ   OrigDBR+1
4218 B616              rtl1     equ   OrigDir+2
4219 B616              rtl2     equ   rtl1+3
4220 B616              UserTag  equ   rtl2+3
4221 B616              IDTag    equ   UserTag+2
4222 B616              Bounds   equ   LastTag
4223 B616
4224 B616                       DefineStack 
4225 B616              s_Rtl1   block 3 
4226 B616              s_Rtl2   block 3 
4227 B616              s_UserTag word 
4228 B616              s_result word 
4229 B616
4230 B616 A3 07                 lda   s_UserTag,s
4231 B618 29 00 F0              and   #$F000
4232 B61B C9 00 40              cmp   #$4000
4233 B61E F0 0A                 beq   NoCanDo
4234 B620
4235 B620 C9 00 70              cmp   #$7000
4236 B623 F0 05                 beq   NoCanDo
4237 B625
4238 B625 C9 00 90              cmp   #$9000
4239 B628 D0 06                 bne   CanDo
4240 B62A
4241 B62A A2 01 03     NoCanDo  ldx   #BadInputErr
4242 B62D 4C FC FB              jmp   oErrOut2
4243 B630
4244 B630
4245 B630              CanDo     
4246 B630
4247 B630
4248 B630 0B                    phd                            ; environment
4249 B631 8B                    phb   
4250 B632 A9 00 00              lda   #0                       ; init space to 0
4251 B635 48                    pha                            ; space for search counter
4252 B636 48                    pha                            ; space for search tag
4253 B637 48                    pha                            ; space for list size
4254 B638 48                    pha                            ; space for list address
4255 B639 48                    pha   
4256 B63A 3B                    tsc                            ; and turn stack into zp
4257 B63B 5B                    tcd   
4258 B63C
4259 B63C 20 2F A7              jsr   GetMTHandleSize
4260 B63F 85 05                 sta   size                     ; save current size
4261 B641 85 09                 sta   srchcnt                  ; initialize search counter
4262 B643 1A                    inc   a                        ; grow for a word entry in list
4263 B644 1A                    inc   a
4264 B645 20 45 A7              jsr   SetMTHandleSize
4265 B648 20 15 A7              jsr   MTderef                  ; dereference the handle
4266 B64B 86 01                 stx   taglist                  ; set tag list address
4267 B64D 84 03                 sty   taglist+2                ; ready for direct-indirect-indexed
4268 B64F              *
4269 B64F              * Search for a hole in the tag list with the requested type.
4270 B64F              * The search routine ignores the AUX field.  Post processing
4271 B64F              * of the IDTAG returned from the search must check for a
4272 B64F              * nonzero MAIN field before returning the tag to the requestor.
4273 B64F              * Only the TYPE and MAIN fields in the IDTAG are maintained in
4274 B64F              * the IDTAG list.  IDTAGS with a MAIN field set to zero are
4275 B64F              * invalid and not maintained in the list.  IDTAGS with a TYPE
4276 B64F              * field of zero are not maintained in the list.  This means that
4277 B64F              * the maximum number of tags maintained in the list is 3825 IDTAGS
4278 B64F              * or 15*255.  Since tags are word wide, the maximum length of the
4279 B64F              * list is 7650 bytes ($1DE2).
4280 B64F              *
4281 B64F A4 05                 ldy   size                     ; decrement remaining list size
4282 B651 F0 04                 beq   emptylist
4283 B653 88                    dey                            ; to point at last entry
4284 B654 88                    dey   
4285 B655 84 05                 sty   size                     ; point at top of list
4286 B657              emptylist                               ; 
4287 B657 A5 14                 lda   UserTag                  ; get callers ID
4288 B659 29 00 F0              and   #$F000                   ; keep only relevant parms
4289 B65C 1A                    inc   a                        ; make initial tag = $NX01
4290 B65D 85 07                 sta   SrchTag                  ; set search tag
4291 B65F 29 00 F0              and   #$F000                   ; and check requested type
4292 B662 D0 05                 bne   TypeOK
4293 B664 A2 01 03              ldx   #badInputErr             ; bad input parm
4294 B667 80 3F                 bra   NoParmErr
4295 B669              TypeOK                                  ; 
4296 B669 A5 14                 lda   UserTag                  ; get callers ID
4297 B66B 29 00 0F              and   #$0F00                   ; preserve AUX
4298 B66E 85 14                 sta   UserTag
4299 B670 C0 00 00              cpy   #0                       ; any tags in list?
4300 B673 F0 1C                 beq   NewTag                   ; no
4301 B675              FindLast                                ; 
4302 B675 B7 01                 lda   [taglist],y              ; else get tag from list
4303 B677 29 FF F0              and   #$F0FF                   ; is it same as search tag
4304 B67A C5 07                 cmp   SrchTag
4305 B67C F0 09                 beq   SameTag                  ; yes
4306 B67E C0 00 00              cpy   #0                       ; was this the last list entry?
4307 B681 F0 0E                 beq   NewTag                   ; yes
4308 B683 88                    dey                            ; point at next list entry
4309 B684 88                    dey   
4310 B685 80 EE                 bra   findlast                 ; and loop to check
4311 B687              SameTag                                 ; 
4312 B687 E6 07                 inc   SrchTag                  ; set next possibility
4313 B689 A4 05                 ldy   size                     ; point at last list entry
4314 B68B C6 09                 dec   SrchCnt                  ; how many more searches
4315 B68D C6 09                 dec   SrchCnt
4316 B68F D0 E4                 bne   FindLast                 ; at least this one
4317 B691              NewTag                                  ; 
4318 B691 A5 07                 lda   SrchTag                  ; Get unassigned tag
4319 B693 05 14                 ora   UserTag                  ; add in the AUX
4320 B695 85 16                 sta   IDtag                    ; save for caller
4321 B697 A4 05                 ldy   size                     ; point at top of tag list
4322 B699 C8                    iny   
4323 B69A C8                    iny   
4324 B69B 97 01                 sta   [taglist],y              ; store into list
4325 B69D A2 00 00              ldx   #0                       ; assume no error
4326 B6A0 29 FF 00              and   #$00FF                   ; check tag in bounds
4327 B6A3 D0 03                 bne   NoParmErr                ; assumed right !
4328 B6A5 A2 0B 03              ldx   #idTagNtAvlErr           ; else tag not available
4329 B6A8              NoParmErr                               ; 
4330 B6A8 68                    pla                            ; clean off tag list address
4331 B6A9 68                    pla   
4332 B6AA 68                    pla                            ; clean off size
4333 B6AB 68                    pla                            ; clean off search tag
4334 B6AC 68                    pla                            ; clean off search count
4335 B6AD AB                    plb                            ; restore data bank
4336 B6AE 2B                    pld                            ; restore direct page
4337 B6AF E0 00 00              cpx   #$0000
4338 B6B2 D0 03                 bne   TagError                 ; if out of bounds
4339 B6B4 4C F7 FB              jmp   oEndCall2
4340 B6B7
4341 B6B7              TagError                                ; 
4342 B6B7 DA                    phx                            ; save error code
4343 B6B8 20 2F A7              jsr   GetMTHandleSize
4344 B6BB 3A                    dec   a                        ; reduce size by a word
4345 B6BC 3A                    dec   a
4346 B6BD 20 45 A7              jsr   SetMTHandleSize
4347 B6C0 FA                    plx                            ; restore error code
4348 B6C1
4349 B6C1 4C FC FB              jmp   oErrOut2
4350 B6C4
4351 B6C4                       ENDP 
4352 B6C4
4353 B6C4
4354 B6C4
4355 B6C4
4356 B6C4
4357 B6C4
4358 B6C4              ****************************************************************
4359 B6C4              *
4360 B6C4              DeleteID PROC 
4361 B6C4              *
4362 B6C4              * Removes the specified ID from the IDTagList
4363 B6C4              *
4364 B6C4              *
4365 B6C4              * Inputs:
4366 B6C4              *	word : id to remove
4367 B6C4              *
4368 B6C4              * Outputs:
4369 B6C4              *	none
4370 B6C4              *
4371 B6C4              * External Refs:
4372 B6C4              *	none
4373 B6C4              *
4374 B6C4              * Entry Points:
4375 B6C4              *	none
4376 B6C4              *
4377 B6C4                       longa on                       ; mode
4378 B6C4                       longi on
4379 B6C4              *
4380 B6C4              ****************************************************************
4381 B6C4
4382 B6C4                       longa on
4383 B6C4                       longi on
4384 B6C4
4385 B6C4              TagList  equ   1                        ; tag list address
4386 B6C4              size     equ   taglist+4                ; ID list size
4387 B6C4              DeleteCnt equ   size+2                  ; list size
4388 B6C4              OrigDBR  equ   DeleteCnt+2              ; saved data bank reg
4389 B6C4              OrigDir  equ   OrigDBR+1                ; saved direct reg
4390 B6C4              rtl1     equ   OrigDir+2
4391 B6C4              rtl2     equ   rtl1+3
4392 B6C4              IDtag    equ   rtl2+3                   ; ID tag (type and aux)
4393 B6C4
4394 B6C4 0B                    phd                            ; save direct page
4395 B6C5 8B                    phb                            ; save data bank
4396 B6C6 A9 00 00              lda   #0                       ; init space with zero
4397 B6C9 48                    pha                            ; space for tag list address
4398 B6CA 48                    pha   
4399 B6CB 48                    pha                            ; space for size
4400 B6CC 48                    pha                            ; delete counter
4401 B6CD 3B                    tsc                            ; turn stack into zp
4402 B6CE 5B                    tcd   
4403 B6CF A5 12                 lda   IDtag                    ; get ID tag
4404 B6D1 29 FF F0              and   #$F0FF                   ; Type and Main parms only
4405 B6D4 85 12                 sta   IDtag
4406 B6D6
4407 B6D6 20 2F A7              jsr   GetMTHandleSize
4408 B6D9 85 05                 sta   size
4409 B6DB 20 15 A7              jsr   MTderef                  ; dereference the handle
4410 B6DE 86 01                 stx   taglist                  ; set tag list address
4411 B6E0 84 03                 sty   taglist+2
4412 B6E2              *
4413 B6E2              * search for and delete the requested tag
4414 B6E2              *
4415 B6E2 A5 05                 lda   size                     ; any list entries?
4416 B6E4 F0 26                 beq   deletedone               ; no
4417 B6E6 A0 00 00              ldy   #0                       ; point at base of list
4418 B6E9              FindID                                  ; 
4419 B6E9 B7 01                 lda   [taglist],y              ; get id from list
4420 B6EB 29 FF F0              and   #$F0FF                   ; Type and Main parms only
4421 B6EE C5 12                 cmp   IDtag                    ; check against target
4422 B6F0 F0 08                 beq   FoundIt
4423 B6F2 C8                    iny                            ; point at next list entry
4424 B6F3 C8                    iny   
4425 B6F4 C4 05                 cpy   size                     ; done all entries?
4426 B6F6 D0 F1                 bne   FindID                   ; no, keep looking
4427 B6F8 F0 12                 beq   deletedone               ; yes, no id found
4428 B6FA              FoundIt                                 ; 
4429 B6FA E6 07                 inc   DeleteCnt                ; bump deleted counter
4430 B6FC              DeleteIt                                ; 
4431 B6FC C4 05                 cpy   size                     ; done ?
4432 B6FE F0 0C                 beq   DeleteDone               ; yes
4433 B700 C8                    iny   
4434 B701 C8                    iny   
4435 B702 B7 01                 lda   [taglist],y              ; move remaining list down
4436 B704 88                    dey   
4437 B705 88                    dey   
4438 B706 97 01                 sta   [taglist],y
4439 B708 C8                    iny                            ; point at next list entry
4440 B709 C8                    iny   
4441 B70A 80 F0                 bra   DeleteIt                 ; move entire list
4442 B70C              DeleteDone                              ; 
4443 B70C 06 07                 asl   DeleteCnt                ; count bytes not words
4444 B70E
4445 B70E 20 2F A7              jsr   GetMTHandleSize
4446 B711 38                    sec   
4447 B712 E5 07                 sbc   DeleteCnt                ; word wide entries that were
4448 B714 20 45 A7              jsr   SetMTHandleSize
4449 B717
4450 B717 68                    pla                            ; clean off tag list address
4451 B718 68                    pla   
4452 B719 68                    pla                            ; clean up size
4453 B71A 68                    pla                            ; clean up delete count
4454 B71B AB                    plb   
4455 B71C 4C F8 FB              jmp   EndCall2
4456 B71F
4457 B71F                       ENDP 
4458 B71F
4459 B71F
4460 B71F
4461 B71F
4462 B71F
4463 B71F              ****************************************************************
4464 B71F              *
4465 B71F              StatusID PROC 
4466 B71F              *
4467 B71F              * Indicates whether or not the specified user id is active.
4468 B71F              * If the ID is in the list of reserved ID's, no error is
4469 B71F              * returned.  If the ID is not in the list, the idTagNtAvlErr is
4470 B71F              * returned.
4471 B71F              *
4472 B71F              * This seems kind of silly I know, but what can I say.  I
4473 B71F              * have to maintain this code, not justify it.
4474 B71F              *
4475 B71F              *
4476 B71F              * Inputs:
4477 B71F              *	word : UserID to check.
4478 B71F              *
4479 B71F              * Outputs:
4480 B71F              *	none
4481 B71F              *
4482 B71F              * External Refs:
4483 B71F              *	none
4484 B71F              *
4485 B71F              * Entry Points:
4486 B71F              *	none
4487 B71F              *
4488 B71F                       longa on                       ; mode
4489 B71F                       longi on
4490 B71F              *
4491 B71F              ****************************************************************
4492 B71F
4493 B71F                       longa on
4494 B71F                       longi on
4495 B71F
4496 B71F              taglist  equ   1
4497 B71F              size     equ   taglist+4
4498 B71F              OrigDBR  equ   size+2
4499 B71F              OrigDir  equ   OrigDBR+1
4500 B71F              rtl1     equ   OrigDir+2
4501 B71F              rtl2     equ   rtl1+3
4502 B71F              IDtag    equ   rtl2+3
4503 B71F
4504 B71F 0B                    phd                            ; save direct page
4505 B720 8B                    phb                            ; save DBR
4506 B721 A9 00 00              lda   #0                       ; start by getting local space on stack and zeroing it
4507 B724 48                    pha                            ; space for tag list ptr
4508 B725 48                    pha   
4509 B726 48                    pha                            ; space for size
4510 B727 3B                    tsc                            ; turn stack into zp
4511 B728 5B                    tcd   
4512 B729
4513 B729 20 2F A7              jsr   GetMTHandleSize
4514 B72C 85 05                 sta   size
4515 B72E 20 15 A7              jsr   MTderef                  ; dereference the handle
4516 B731 86 01                 stx   taglist                  ; set tag list address
4517 B733 84 03                 sty   taglist+2
4518 B735              *
4519 B735              * now search for ID	tag
4520 B735              *
4521 B735 A5 10                 lda   IDtag                    ; get search tag
4522 B737 29 FF F0              and   #$F0FF                   ; Main & Type only
4523 B73A 85 10                 sta   IDtag
4524 B73C A0 00 00              ldy   #0                       ; point at base of list
4525 B73F              FindID                                  ; 
4526 B73F C4 05                 cpy   size                     ; done ?
4527 B741 F0 0D                 beq   SrchDone                 ; no ID tag found
4528 B743 B7 01                 lda   [taglist],y              ; check for tag
4529 B745 29 FF F0              and   #$F0FF                   ; type and main only
4530 B748 C5 10                 cmp   IDtag
4531 B74A F0 06                 beq   FoundIt                  ; ID is active
4532 B74C C8                    iny                            ; point at next list entry
4533 B74D C8                    iny   
4534 B74E 80 EF                 bra   FindID                   ; and keep looking
4535 B750              SrchDone                                ; 
4536 B750 64 05                 stz   size                     ; set not found flag
4537 B752              FoundIt                                 ; 
4538 B752 68                    pla                            ; clean up tag list address
4539 B753 68                    pla   
4540 B754 68                    pla                            ; clean off size
4541 B755 AB                    plb   
4542 B756 C9 00 00              cmp   #0                       ; was ID found?
4543 B759 F0 03                 beq   IDinact                  ; if did not find tag
4544 B75B 4C F8 FB              jmp   EndCall2
4545 B75E
4546 B75E              IDinact                                 ; 
4547 B75E A2 0B 03              ldx   #idTagNtAvlErr           ; no id for input parm
4548 B761 4C FB FB              jmp   ErrOut2
4549 B764
4550 B764                       ENDP 
4551 B764
4552 B764
4553 B764                       title 'IRQ Stuff'
4554 B764              ****************************************************************
4555 B764              *
4556 B764              * This tool call is used to enable interrupt sources or other
4557 B764              * special functions such as keyboard buffering
4558 B764              *
4559 B764              * Change History
4560 B764              *
4561 B764              * 13 Feb 87    Ray Montagne
4562 B764              *
4563 B764              *    Keyboard interrupts did not enable the VBL interrupt
4564 B764              *    source.  Now it does!
4565 B764              *
4566 B764              ****************************************************************
4567 B764              IntSrc   PROC 
4568 B764
4569 B764              KeyTaskHdr equ   $E1014C
4570 B764              KeyTaskCnt equ   KeyTaskHdr+4
4571 B764              KeyTaskSig equ   KeyTaskCnt+2
4572 B764              KeyTaskJmp equ   KeyTaskSig+2
4573 B764
4574 B764                       longa on
4575 B764                       longi on
4576 B764
4577 B764 A3 07                 lda   7,s                      ; get reference #
4578 B766 0A                    asl   a                        ; make index
4579 B767 AA                    tax   
4580 B768 E0 20 00              cpx   #$0020                   ; check tool reference
4581 B76B B0 12                 bge   DsptchErr                ; oops!!!
4582 B76D F4 77 B7              pea   DsptchRet-1              ; push return address
4583 B770 BF 85 B7 FE           lda   >Disptch,x               ; and then dispatch address
4584 B774 48                    pha   
4585 B775 E2 30                 sep   #$30                     ; off to 8 bit land for dispatch
4586 B777                       longa off
4587 B777                       longi off
4588 B777 60                    rts                            ; do dispatch
4589 B778
4590 B778              DsptchRet                               ; 
4591 B778 C2 30                 rep   #$30                     ;back to 16 bit land
4592 B77A                       longa on
4593 B77A                       longi on
4594 B77A B0 03                 bcs   DsptchErr                ; if error, then go here
4595 B77C 4C F7 FB              jmp   oEndCall2                ; all done
4596 B77F              DsptchErr                               ; 
4597 B77F A2 01 03              ldx   #badInputErr             ; Parameter error occured
4598 B782 4C FC FB              jmp   oErrOut2                 ; error exit
4599 B785
4600 B785              Disptch                                 ; 
4601 B785 A4 B7                 DC W:EnblKbd-1                 ; enable keyboard interrupts
4602 B787 F8 B7                 DC W:DsblKbd-1                 ; disable keyboart int
4603 B789 0E B8                 DC W:EnblVbl-1                 ; enable vertical blanking interrupts
4604 B78B 19 B8                 DC W:DsblVbl-1                 ; disable VBL int
4605 B78D 24 B8                 DC W:EnblQtr-1                 ; enable quarter second interrupt
4606 B78F 2F B8                 DC W:DsblQtr-1                 ; disable quarter second int
4607 B791 3A B8                 DC W:EnblSec-1                 ; enable 1 second int
4608 B793 45 B8                 DC W:DsblSec-1                 ; disable 1 second int
4609 B795 7C B8                 DC W:EnblBuf-1                 ; enable keyboard buffering
4610 B797 7D B8                 DC W:DsblBuf-1                 ; disable keyboard buffering
4611 B799 7E B8                 DC W:EnblDat-1                 ; enable keymicro data int
4612 B79B 89 B8                 DC W:DsblDat-1                 ; disable keymicro data int
4613 B79D 50 B8                 DC W:EnblScan-1                ; enable scan line int
4614 B79F 5B B8                 DC W:DsblScan-1                ; disable scan line int
4615 B7A1 66 B8                 DC W:EnblExt-1                 ; enable external VGC int
4616 B7A3 71 B8                 DC W:DsblExt-1                 ; disable external VGC int
4617 B7A5
4618 B7A5              EnblKbd                                 ; 
4619 B7A5                       longa off
4620 B7A5 A9 80                 lda   #%10000000               ; set KBD IRQ flag
4621 B7A7 8F D4 0F E1           sta   >KBDIRQFLAG
4622 B7AB C2 30                 rep   #$30                     ; to 16 bit land
4623 B7AD                       longa on
4624 B7AD                       longi on
4625 B7AD A9 01 00              lda   #1                       ; initialize task count
4626 B7B0 8F 50 01 E1           sta   >KeyTaskCnt
4627 B7B4 A9 5A A5              lda   #$A55A                   ; and set task signature
4628 B7B7 8F 52 01 E1           sta   >KeyTaskSig
4629 B7BB A9 E8 B7              lda   #KeyTask                 ; now set up jump to task
4630 B7BE 48                    pha   
4631 B7BF EB                    xba   
4632 B7C0 29 00 FF              and   #$FF00
4633 B7C3 09 5C 00              ora   #$005C
4634 B7C6 8F 54 01 E1           sta   >KeyTaskJmp
4635 B7CA 68                    pla   
4636 B7CB 29 00 FF              and   #$FF00
4637 B7CE 09 FE 00              ora   #^KeyTask
4638 B7D1 EB                    xba   
4639 B7D2 8F 56 01 E1           sta   >KeyTaskJmp+2
4640 B7D6 F4 E1 00              pea   $00E1                    ; pointer to KBD task
4641 B7D9 F4 4C 01              pea   $014C
4642 B7DC A2 03 12 22           _SetHeartBeat                  ; install keyboard task
4643 B7E3 E2 30                 sep   #$30
4644 B7E5 18                    clc   
4645 B7E6 80 27                 bra   ENBLVbl                  ; changed 13 Feb 87 RBM
4646 B7E8
4647 B7E8              KeyTask                                 ;       
4648 B7E8                       longa off
4649 B7E8                       longi off
4650 B7E8 A9 01                 lda   #$01                     ; reset task count
4651 B7EA 8F 50 01 E1           sta   >KeyTaskCnt
4652 B7EE AF 00 C0 00           lda   >KBD                     ; read keyboard data
4653 B7F2 10 04                 bpl   NoKBDirq                 ; if no key, no dispatch
4654 B7F4 5C 3C 00 E1           jmp   >IRQ_KBD
4655 B7F8              NoKBDirq                                ; 
4656 B7F8 6B                    rtl   
4657 B7F9
4658 B7F9
4659 B7F9              DsblKbd                                 ; 
4660 B7F9                       longa off
4661 B7F9 A9 00                 lda   #%00000000               ; clear KBD IRQ flag
4662 B7FB 8F D4 0F E1           sta   >KBDIRQFLAG
4663 B7FF C2 30                 rep   #$30                     ; to 16 bit land
4664 B801                       longa on
4665 B801                       longi on
4666 B801 F4 E1 00              pea   $00E1                    ; pointer to KBD task
4667 B804 F4 4C 01              pea   $014C
4668 B807 A2 03 13 22           _DelHeartBeat 
4669 B80E 60                    rts   
4670 B80F
4671 B80F              EnblVbl                                 ; 
4672 B80F                       longa off
4673 B80F                       longi off
4674 B80F AF 41 C0 00           lda   >INTEN                   ; get mega interrupt reg
4675 B813 09 08                 ora   #%00001000               ; enable VBL interrupts
4676 B815 8F 41 C0 00           sta   >INTEN
4677 B819 60                    rts   
4678 B81A
4679 B81A              DsblVbl                                 ; 
4680 B81A AF 41 C0 00           lda   >INTEN                   ; get mega interrupt reg
4681 B81E 29 F7                 and   #%11110111               ; disable VBL interrupts
4682 B820 8F 41 C0 00           sta   >INTEN
4683 B824 60                    rts   
4684 B825
4685 B825              EnblQtr                                 ; 
4686 B825 AF 41 C0 00           lda   >INTEN                   ; get mega interrupt reg
4687 B829 09 10                 ora   #%00010000               ; enable 1/4 sec interrupt
4688 B82B 8F 41 C0 00           sta   >INTEN
4689 B82F 60                    rts   
4690 B830
4691 B830              DsblQtr                                 ; 
4692 B830 AF 41 C0 00           lda   >INTEN                   ; get mega interrupt reg
4693 B834 29 EF                 and   #%11101111               ; disable 1/4 sec interrupt
4694 B836 8F 41 C0 00           sta   >INTEN
4695 B83A 60                    rts   
4696 B83B
4697 B83B              EnblSec                                 ; 
4698 B83B AF 23 C0 00           lda   >VGCINT                  ; get VGC interrupt reg
4699 B83F 09 04                 ora   #%00000100               ; enable 1 sec interrupt
4700 B841 8F 23 C0 00           sta   >VGCINT
4701 B845 60                    rts   
4702 B846
4703 B846              DsblSec                                 ; 
4704 B846 AF 23 C0 00           lda   >VGCINT                  ; get VGC interrupt reg
4705 B84A 29 FB                 and   #%11111011               ; disable 1 sec interrupt
4706 B84C 8F 23 C0 00           sta   >VGCINT
4707 B850 60                    rts   
4708 B851
4709 B851              EnblScan                                ; 
4710 B851 AF 23 C0 00           lda   >VGCINT                  ; get VGC interrupt reg
4711 B855 09 02                 ora   #%00000010               ; enable scan line interrupt
4712 B857 8F 23 C0 00           sta   >VGCINT
4713 B85B 60                    rts   
4714 B85C
4715 B85C              DsblScan                                ; 
4716 B85C AF 23 C0 00           lda   >VGCINT                  ; get VGC interrupt reg
4717 B860 29 FD                 and   #%11111101               ; disable scan line interrupt
4718 B862 8F 23 C0 00           sta   >VGCINT
4719 B866 60                    rts   
4720 B867
4721 B867              EnblExt                                 ; 
4722 B867 AF 23 C0 00           lda   >VGCINT                  ; get VGC interrupt reg
4723 B86B 09 01                 ora   #%00000001               ; enable external VGC interrupt
4724 B86D 8F 23 C0 00           sta   >VGCINT
4725 B871 60                    rts   
4726 B872
4727 B872              DsblExt                                 ; 
4728 B872 AF 23 C0 00           lda   >VGCINT                  ; get VGC interrupt reg
4729 B876 29 FE                 and   #%11111110               ; disable external VGC interrupt
4730 B878 8F 23 C0 00           sta   >VGCINT
4731 B87C 60                    rts   
4732 B87D
4733 B87D              EnblBuf                                 ; 
4734 B87D 60                    rts   
4735 B87E
4736 B87E              DsblBuf                                 ; 
4737 B87E 60                    rts   
4738 B87F
4739 B87F
4740 B87F              EnblDat                                 ; 
4741 B87F AF 27 C0 00           lda   >KMStatus                ; get Keyboard u cmd/status
4742 B883 09 10                 ora   #%00010000               ; enable data interrupts
4743 B885 8F 27 C0 00           sta   >KMStatus
4744 B889 60                    rts   
4745 B88A
4746 B88A              DsblDat                                 ; 
4747 B88A AF 27 C0 00           lda   >KMStatus                ; get Keyboard u cmd/status
4748 B88E 29 EF                 and   #%11101111               ; disable data interrupts
4749 B890 8F 27 C0 00           sta   >KMStatus
4750 B894 60                    rts   
4751 B895
4752 B895
4753 B895                       ENDP 
4754 B895
4755 B895
4756 B895
4757 B895
4758 B895                       title 'GetTick'
4759 B895              **************************************************************
4760 B895              *
4761 B895              *     Returns current tick count value
4762 B895              *
4763 B895              ****************************************************************
4764 B895              GetTick  PROC 
4765 B895                       longa on
4766 B895                       longi on
4767 B895
4768 B895              IRQstate equ   1
4769 B895              rtl1     equ   IRQstate+1
4770 B895              rtl2     equ   rtl1+3
4771 B895              LowTick  equ   rtl2+3
4772 B895              HiTick   equ   LowTick+2
4773 B895
4774 B895 08                    php                            ; save interrupt status
4775 B896 78                    sei                            ; and disable for now
4776 B897 AF DC 00 E1           lda   >TickCnt                 ; move tick count to stack
4777 B89B 83 08                 sta   LowTick,s
4778 B89D AF DE 00 E1           lda   >TickCnt+2
4779 B8A1 83 0A                 sta   HiTick,s
4780 B8A3 28                    plp                            ; restore interrupt status
4781 B8A4 4C DF FB              jmp   oEndCall0
4782 B8A7
4783 B8A7                       ENDP 
4784 B8A7
4785 B8A7
4786 B8A7
4787 B8A7                       title 'FWEntry'
4788 B8A7              ****************************************************************
4789 B8A7              *
4790 B8A7              * Firmware Entry Points
4791 B8A7              *
4792 B8A7              * This function requires two words of input as follows
4793 B8A7              *
4794 B8A7              *     Input     Word     Room for result
4795 B8A7              *     Input     Word     Room for result
4796 B8A7              *     Input     Word     Room for result
4797 B8A7              *     Input     Word     Room for result
4798 B8A7              *     Input     Word     Accumulator value (low byte)
4799 B8A7              *     Input     Word     X register value  (low byte)
4800 B8A7              *     Input     Word     Y register value  (low byte)
4801 B8A7              *     Input     Word     Address of Apple// entry point
4802 B8A7              *     Output    Word     Y register  (low byte)
4803 B8A7              *     Output    Word     X register  (low byte)
4804 B8A7              *     Output    Word     A register  (low byte)
4805 B8A7              *     Output    Word     6502 status (low byte)
4806 B8A7              *
4807 B8A7              * Modification History
4808 B8A7              *
4809 B8A7              *     9 Mar 87   Ray Montagne
4810 B8A7              *
4811 B8A7              *     Processor status was comming off stack in wrong byte of word.
4812 B8A7              *
4813 B8A7              *     12 Mar 87  Ray Montagne
4814 B8A7              *
4815 B8A7              *     Steve buggered my code by puting an and #$00CF in the wrong
4816 B8A7              *     spot.  So I fixed it!!!
4817 B8A7              *
4818 B8A7              *     17 Nov 88  Konstantin Othmer
4819 B8A7              *
4820 B8A7              *     Added calls to slot arbiter so that the default slot configuration
4821 B8A7              *     is selected anytime a call is made to the Cn00 space.  
4822 B8A7              * NOTE:  This does not effect the text tools since they call fwentry directly.
4823 B8A7              *
4824 B8A7              ****************************************************************
4825 B8A7              MonEntry PROC 
4826 B8A7
4827 B8A7              dir      equ   1
4828 B8A7              ret1     equ   dir+2
4829 B8A7              ret2     equ   ret1+3
4830 B8A7              fwep     equ   ret2+3
4831 B8A7              yin      equ   fwep+2
4832 B8A7              xin      equ   yin+2
4833 B8A7              ain      equ   xin+2
4834 B8A7              yout     equ   ain+2
4835 B8A7              xout     equ   yout+2
4836 B8A7              aout     equ   xout+2
4837 B8A7              pout     equ   aout+2
4838 B8A7
4839 B8A7                       longa on
4840 B8A7                       longi on
4841 B8A7
4842 B8A7 0B                    phd                            ; turn stack into zp
4843 B8A8 3B                    tsc   
4844 B8A9 5B                    tcd   
4845 B8AA              ;
4846 B8AA              ; Are we in Cn00 Space?
4847 B8AA              ;
4848 B8AA
4849 B8AA A5 09                 lda   fwep
4850 B8AC C9 00 C0              cmp   #$C000
4851 B8AF 90 0F                 bcc   NotInC000
4852 B8B1 C9 FF C7              cmp   #$C7FF
4853 B8B4 B0 0A                 bcs   NotInC000
4854 B8B6
4855 B8B6              ;
4856 B8B6              ; Set slots to default configuration and put old config. on stack
4857 B8B6              ;
4858 B8B6              InC000    
4859 B8B6 A9 00 02              lda   #$0200                   ;request default configuration
4860 B8B9 22 08 02 E1           jsl   slot_arbiter             ;
4861 B8BD DA                    phx                            ;save original configuration
4862 B8BE 80 08                 bra   SlotDone
4863 B8C0
4864 B8C0              ;
4865 B8C0              ; Don't change configuration. Get current and put on stack to be symmetrical with
4866 B8C0              ;   above case.  
4867 B8C0              ;
4868 B8C0              NotInC000  
4869 B8C0 A9 00 80              lda   #$8000                   ;Get current configuration but don't change
4870 B8C3 22 08 02 E1           jsl   slot_arbiter             ;anything.
4871 B8C7 DA                    phx                            ;save original configuration
4872 B8C8
4873 B8C8              SlotDone  
4874 B8C8 A5 09                 lda   fwep                     ; get fw entry point address
4875 B8CA 3A                    dec   a                        ; adjust for dispatch to FW
4876 B8CB F4 D7 B8              pea   fwdsptch-1               ; push return address
4877 B8CE 48                    pha                            ; push dispatch address
4878 B8CF A4 0B                 ldy   yin                      ; set up register inputs
4879 B8D1 A6 0D                 ldx   xin
4880 B8D3 A5 0F                 lda   ain
4881 B8D5 82 4A FC              brl   fwentry                  ; do dispatch
4882 B8D8
4883 B8D8              fwdsptch                                ; 
4884 B8D8 08                    php                            ; save returned parameters
4885 B8D9 29 FF 00              and   #$00FF                   ; truncate to byte
4886 B8DC 85 15                 sta   aout                     ; store output parmeters
4887 B8DE 86 13                 stx   xout
4888 B8E0 84 11                 sty   yout
4889 B8E2 A3 01                 lda   1,s                      ; get FW 6502 status
4890 B8E4 29 C7 00              and   #$00C7                   ; truncate to byte
4891 B8E7 EB                    xba                            ; put processor status in high byte
4892 B8E8 85 17                 sta   pout                     ; and store as output parm
4893 B8EA C2 20                 rep   #$20                     ; 16 bit 'm'
4894 B8EC 28                    plp                            ; clean up stack
4895 B8ED FA                    plx                            ;get old configuration
4896 B8EE 08                    php                            ;
4897 B8EF              ; 
4898 B8EF              ; Restore old slot configuration which is stored on stack
4899 B8EF              ;
4900 B8EF A9 00 03              lda   #$0300                   ;restore to configuration in x reg
4901 B8F2 22 08 02 E1           jsl   slot_arbiter
4902 B8F6 28                    plp   
4903 B8F7 4C 3A FC              jmp   EndCall8                 ; pulls d and cleans up stack
4904 B8FA
4905 B8FA                       ENDP 
4906 B8FA
4907 B8FA
4908 B8FA
4909 B8FA
4910 B8FA
4911 B8FA                       title 'Pack and Unpack bytes'
4912 B8FA              ************************************************************************
4913 B8FA              *                                                                      *
4914 B8FA              *  FUNCION PackBytes(VAR PicPtr : POINTER;                             *
4915 B8FA              *  VAR PicSize: INTEGER;                                               *
4916 B8FA              *      BufPtr : POINTER;                                               *
4917 B8FA              *      BufSize: INTEGER) : INTEGER;                                    *
4918 B8FA              *                                                                      *
4919 B8FA              *  Params:  PicPtr - Pointer to start of picture area to be packed     *
4920 B8FA              *           PicSize- Total size to be packed                           *
4921 B8FA              *           BufPtr - Start of output buffer to pack into               *
4922 B8FA              *           BufSize- Maximum space available for packed picture        *
4923 B8FA              *                                                                      *
4924 B8FA              *  Returns: PackBytes return value: Number of packed bytes generated   *
4925 B8FA              *           PicPtr: updated to end of last byte used from picture      *
4926 B8FA              *           PicSize: reduced by number of bytes of picture processed   *
4927 B8FA              *                                                                      *
4928 B8FA              *  FUNCTION UnPackBytes(    BufPtr : POINTER;                          *
4929 B8FA              *         BufSize: INTEGER;                                            *
4930 B8FA              *     VAR PicPtr : POINTER;                                            *
4931 B8FA              *     VAR PicSize: INTEGER) : INTEGER;                                 *
4932 B8FA              *                                                                      *
4933 B8FA              *  Params:  BufPtr - pointer to area containing packed data            *
4934 B8FA              *           BufSize- max size of area containing packed data           *
4935 B8FA              *           PicPtr - Pointer to start of area to unpack into           *
4936 B8FA              *           PicSize- Maximum space available for unpacked picture      *
4937 B8FA              *                                                                      *
4938 B8FA              *  Returns: UnPackBytes return Value: Actual number of bytes unpacked  *
4939 B8FA              *           PicPtr: Updated to one past end of last byte unpacked      *
4940 B8FA              *           PicSize: reduced by number of bytes of picture generated   *
4941 B8FA              *                                                                      *
4942 B8FA              *        ------------------------------------------------------        *
4943 B8FA              *                                                                      *
4944 B8FA              *  Sample Calls:                                                       *
4945 B8FA              *                                                                      *
4946 B8FA              *        picsize:=$7d00;                                               *
4947 B8FA              *        bufsize:=$400;                                                *
4948 B8FA              *        REPEAT                                                        *
4949 B8FA              *          HowMuch:=PackBytes(PicPtr,PicSize,BufPtr,BufSize);          *
4950 B8FA              *          Write(f,bufptr,howmuch);                                    *
4951 B8FA              *        UNTIL picsize=0;                                              *
4952 B8FA              *                                                                      *
4953 B8FA              *                                                                      *
4954 B8FA              *        {***}                                                         *
4955 B8FA              *                                                                      *
4956 B8FA              *                                                                      *
4957 B8FA              *        OpenFile;                                                     *
4958 B8FA              *        Mark:=StartofFile;                                            *
4959 B8FA              *        PicSize:=$7d00;                                               *
4960 B8FA              *        BufSize:=$400;                                                *
4961 B8FA              *        REPEAT                                                        *
4962 B8FA              *          SetFileMark(Mark);                                          *
4963 B8FA              *          Read(f,BufPtr,Bufsize);                                     *
4964 B8FA              *          HowMuch:=UnPackBytes(BufPtr,BufSize,PicPtr,PicSize);        *
4965 B8FA              *          Mark:=Mark+HowMuch;                                         *
4966 B8FA              *        UNTIL ( (PicSize=0) OR EOF(f) );                              *
4967 B8FA              *                                                                      *
4968 B8FA              *     -----------------------------------------------------------      *
4969 B8FA              *                                                                      *
4970 B8FA              *    Packed data incription format:                                    *
4971 B8FA              *                                                                      *
4972 B8FA              *        %00xxxxxx : (xxxxxx : 0->63) = 1 to 64 bytes follow -         *
4973 B8FA              *                                              All Different           *
4974 B8FA              *                                                                      *
4975 B8FA              *        %01xxxxxx : (xxxxxx : 1,2,3,5,6,7) = 1,2,3,5,6,7 repeats -    *
4976 B8FA              *                                              of next byte            *
4977 B8FA              *                                                                      *
4978 B8FA              *        %10xxxxxx : (xxxxxx : 0->63) = 1 to 64 repeats -              *
4979 B8FA              *                                              of next 4 bytes         *
4980 B8FA              *                                                                      *
4981 B8FA              *        %11xxxxxx : (xxxxxx : 0->63) = 1 to 64 times 4 repeats -      *
4982 B8FA              *                                              of next byte            *
4983 B8FA              *                                                                      *
4984 B8FA              *    -----------------------------------------------------------       *
4985 B8FA              *                                                                      *
4986 B8FA              *  Written By: Eagle I. Berns                                          *
4987 B8FA              *                                                                      *
4988 B8FA              *  Modification History:                                               *
4989 B8FA              *                                                                      *
4990 B8FA              *  10-DEC-85   EIB                      First coding begun             *
4991 B8FA              *   5-Mar-87   SEG                      Error code returned is now 0   *
4992 B8FA              *                                       in both Pack and Unpack        *
4993 B8FA              *                                                                      *
4994 B8FA              ************************************************************************
4995 B8FA
4996 B8FA
4997 B8FA              ************************************************************************
4998 B8FA              * Main Packbits entry                                                  *
4999 B8FA              ************************************************************************
5000 B8FA
5001 B8FA              PACKBYTES PROC 
5002 B8FA
5003 B8FA              from     equ   1
5004 B8FA              to       equ   from+4
5005 B8FA              endbuf   equ   TO+4
5006 B8FA              prev     equ   endbuf+4
5007 B8FA              count    equ   prev+4
5008 B8FA              lf       equ   count+2
5009 B8FA
5010 B8FA              Origdrct equ   lf+2
5011 B8FA
5012 B8FA              rtl1     equ   origdrct+2
5013 B8FA              rtl2     equ   rtl1+3
5014 B8FA
5015 B8FA              Bufsize  equ   rtl2+3
5016 B8FA              BufPtr   equ   Bufsize+2
5017 B8FA              PicsizeP equ   BufPtr+4
5018 B8FA              PicPtrP  equ   PicSizeP+4
5019 B8FA              Result   equ   PicPtrP+4
5020 B8FA              ;                     -> +2
5021 B8FA
5022 B8FA 0B                    phd                            ; SET UP STACK AS ZERO PAGE +PARMS
5023 B8FB 3B                    tsc   
5024 B8FC 38                    sec   
5025 B8FD E9 14 00              sbc   #ORIGDRCT-1
5026 B900 1B                    tcs   
5027 B901 5B                    tcd   
5028 B902
5029 B902 A7 27                 lda   [PICPTRP]                ; GET THE ARGS.
5030 B904 AA                    tax                            ; (PICPTRP NEEDS DE-REFERANCE)
5031 B905 A0 02 00              ldy   #2
5032 B908 B7 27                 lda   [PICPTRP],Y
5033 B90A 85 03                 sta   FROM+2
5034 B90C 86 01                 stx   FROM
5035 B90E
5036 B90E A7 23                 lda   [PICSIZEP]
5037 B910 85 11                 sta   COUNT
5038 B912
5039 B912
5040 B912 A5 1D                 lda   BUFSIZE
5041 B914 38                    sec   
5042 B915 E9 05 00              sbc   #5                       ;END LESS FIVE FOR ENDING TEST
5043 B918 18                    clc   
5044 B919 65 1F                 adc   BUFPTR
5045 B91B 85 09                 sta   ENDBUF
5046 B91D A5 21                 lda   BUFPTR+2
5047 B91F 85 07                 sta   TO+2
5048 B921 69 00 00              adc   #0
5049 B924 85 0B                 sta   ENDBUF+2
5050 B926 A5 1F                 lda   BUFPTR
5051 B928 85 05                 sta   TO
5052 B92A
5053 B92A A9 00 00              lda   #0
5054 B92D A8                    tay   
5055 B92E 97 05                 sta   [TO],Y
5056 B930 85 13                 sta   LF
5057 B932 E6 13                 inc   LF                       ; MAKE LAST<>FIRST TO BEGIN
5058 B934 A9 FF FF              lda   #$FFFF                   ; SET PREV TO INVALID
5059 B937 85 0D                 sta   PREV
5060 B939 85 0F                 sta   PREV+2
5061 B93B
5062 B93B 20 3D BB     MAINLOOP jsr   ISIT44                   ; CHECK IF MULTI-4 MATCH
5063 B93E 90 03                 bcc   CNT4S                    ; YES, OUNT THEM
5064 B940 4C D1 B9              jmp   MORECL                   ; NO, MOVE ALONG FOR MORE CHECKS
5065 B943
5066 B943              *****************************************
5067 B943              *                                       *
5068 B943              *   Now, count 4's grouping on the      *
5069 B943              *   input and store the results in the  *
5070 B943              *   output and adjusts all necessary    *
5071 B943              *   pointers. NOTE: this routine will   *
5072 B943              *   assume at least one match got you   *
5073 B943              *   in here, thus one match assumed.    *
5074 B943              *                                       *
5075 B943              *****************************************
5076 B943
5077 B943 A2 01 00     CNT4S    ldx   #1                       ; X COUNTS HOW MANY PAIRS
5078 B946 20 3D BB     CLOOP    jsr   ISIT44                   ; DO IT DO THE 4 4 MATCH
5079 B949 B0 29                 bcs   CDONE                    ; NO IT DON'T - GO FINISH UP
5080 B94B E0 40 00              cpx   #64                      ; REMEMBER, $3F MAX
5081 B94E F0 24                 beq   CDONE
5082 B950 A5 11                 lda   COUNT                    ; DON'T GO PAST END
5083 B952 F0 20                 beq   CDONE
5084 B954 38                    sec   
5085 B955 E9 04 00              sbc   #4
5086 B958 90 1A                 blt   CDONE
5087 B95A A5 01                 lda   FROM
5088 B95C 18                    clc   
5089 B95D 69 04 00              adc   #4
5090 B960 85 01                 sta   FROM
5091 B962 A5 03                 lda   FROM+2
5092 B964 69 00 00              adc   #0
5093 B967 85 03                 sta   FROM+2
5094 B969 E8                    inx                            ; BUMP THE COUNT
5095 B96A A5 11                 lda   COUNT
5096 B96C 38                    sec   
5097 B96D E9 04 00              sbc   #4
5098 B970 85 11                 sta   COUNT
5099 B972 80 D2                 bra   CLOOP
5100 B974 CA           CDONE    dex                            ; LESS ONE FOR CMD.
5101 B975 DA                    phx                            ; SAVE COUNT AWHILE
5102 B976 20 22 BB              jsr   LOOKAT4
5103 B979 F0 2B                 beq   CMAT4                    ; GOT 4'S AND THEY'RE ALL THE SAME
5104 B97B 68                    pla                            ; GET COUNT BACK FOR THIS CASE
5105 B97C 09 80 00              ora   #$80                     ; SET APPROPRIATE FLAGS
5106 B97F A0 00 00              ldy   #0
5107 B982 97 05                 sta   [TO],Y                   ; STORE COMPRESSIION TYPE WORD+COUNT
5108 B984 B7 01                 lda   [FROM],Y                 ; GET 1ST TWO BYTES TO STORE
5109 B986 C8                    iny   
5110 B987 97 05                 sta   [TO],Y                   ; STORE 1ST TWO AFTER COMMAND
5111 B989 C8                    iny   
5112 B98A B7 01                 lda   [FROM],Y                 ; GET NEXT 2 INPUTS (Y IS NEATLY OK!)
5113 B98C 85 13                 sta   LF
5114 B98E C8                    iny   
5115 B98F 97 05                 sta   [TO],Y                   ; NOW DATA IS STORED CORRECTLY
5116 B991
5117 B991 A5 05                 lda   TO                       ; 'TO' LOC BUMPS BY 5
5118 B993 85 0D                 sta   PREV
5119 B995 18                    clc   
5120 B996 69 05 00              adc   #5
5121 B999 85 05                 sta   TO
5122 B99B A5 07                 lda   TO+2
5123 B99D 85 0F                 sta   PREV+2
5124 B99F 69 00 00              adc   #0
5125 B9A2 85 07                 sta   TO+2
5126 B9A4 80 25                 bra   CJOIN                    ;GO FINISH UP
5127 B9A6 68           CMAT4    pla                            ;GET THE COUNT
5128 B9A7 09 C0 00              ora   #$C0
5129 B9AA 87 05                 sta   [TO]                     ;STORE CONTROL INFO+COUNT
5130 B9AC A0 03 00              ldy   #3
5131 B9AF B7 01                 lda   [FROM],Y                 ;GET THE BYTE THAT MATCHES
5132 B9B1 85 13                 sta   LF
5133 B9B3 A0 01 00              ldy   #1
5134 B9B6 97 05                 sta   [TO],Y                   ; STORE 2 BUT COUNT ONLY 1
5135 B9B8 A5 05                 lda   TO                       ; 'TO' LOC BUMPS BY 2
5136 B9BA 85 0D                 sta   PREV
5137 B9BC 18                    clc   
5138 B9BD 69 02 00              adc   #2
5139 B9C0 85 05                 sta   TO
5140 B9C2 A5 07                 lda   TO+2
5141 B9C4 85 0F                 sta   PREV+2
5142 B9C6 69 00 00              adc   #0
5143 B9C9 85 07                 sta   TO+2
5144 B9CB A2 04 00     CJOIN    ldx   #4                       ;'FROM' AND 'COUNT' NEED 4 BUMP STILL
5145 B9CE 4C 27 BA              jmp   BMPF
5146 B9D1
5147 B9D1 20 3D BB     MORECL   jsr   ISIT44                   ; DO WE HAVE 4-4 MATCH FROM HERE
5148 B9D4 90 06                 bcc   DOSTR2                   ; YES, GO HANDLE IT
5149 B9D6 C8                    iny   
5150 B9D7 C0 04 00              cpy   #4                       ; HAVE WE MOVED THROUGH 4
5151 B9DA 90 F5                 bcc   MORECL
5152 B9DC 5A           DOSTR2   phy   
5153 B9DD A0 00 00              ldy   #0
5154 B9E0 20 22 BB              jsr   LOOKAT4                  ; CHECK FOR SOME MATCHES
5155 B9E3 8A                    txa                            ; NUMBER OF THEM TO A
5156 B9E4 FA                    plx                            ; NO. TO DEAL WITH TO X
5157 B9E5
5158 B9E5              *****************************************
5159 B9E5              *                                       *
5160 B9E5              *   Now, add into the output stream     *
5161 B9E5              *   a spec for consecutive bytes of     *
5162 B9E5              *   from 1 to 4 (all matching) and will *
5163 B9E5              *   modify previous spec if necessary   *
5164 B9E5              *   A reg. contains max no. of the      *
5165 B9E5              *          chars we may consider.       *
5166 B9E5              *   X reg. has 1,2,3 or 4 for the num.  *
5167 B9E5              *          of matched chars.            *
5168 B9E5              *****************************************
5169 B9E5
5170 B9E5 A0 00 00              ldy   #0
5171 B9E8 48                    pha   
5172 B9E9 8A                    txa   
5173 B9EA 38                    sec   
5174 B9EB E3 01                 sbc   1,S                      ; A NOW HAS REG. X - REG Y
5175 B9ED 90 03                 blt   STU1
5176 B9EF A3 01                 lda   1,S
5177 B9F1 AA                    tax                            ; NOW, X HAS MAX REALLY TO CONSIDER
5178 B9F2 68           STU1     pla                            ; FROM EXTRA PUSH FOR ARITH.
5179 B9F3 8A                    txa                            ; STORE IT FOR CHECK ON END
5180 B9F4 C5 11                 cmp   COUNT
5181 B9F6 90 02                 blt   STU2
5182 B9F8 A6 11                 ldx   COUNT                    ; IF PAST END, USE LOWER COUNT
5183 B9FA A5 13        STU2     lda   LF                       ; CHECK IF LAST=FIRST
5184 B9FC EB                    xba   
5185 B9FD C5 13                 cmp   LF
5186 B9FF D0 59                 bne   DIFF                     ; NO, SO GO STORE DIFF. DATA
5187 BA01 A5 0F                 lda   PREV+2                   ; IS THERE A PREV
5188 BA03 C9 FF FF              cmp   #$FFFF
5189 BA06 F0 52                 beq   DIFF                     ; NOPE, SO NO MATCH
5190 BA08 B7 0D                 lda   [PREV],Y                 ; GET LAST COMMAND TO SE WHAT TO DO
5191 BA0A 29 FF 00              and   #$FF                     ; CHECK FOR COMMAND 'C0',BYTE
5192 BA0D C9 C0 00              cmp   #$C0
5193 BA10 D0 48                 bne   DIFF                     ; NOPE, SO JUST DO THESE ALONE
5194 BA12 8A                    txa                            ; GOOD ONE, SO X+4 WILL STORE TO PREV
5195 BA13 18                    clc   
5196 BA14 69 03 00              adc   #3                       ; 4 - 1 FOR CMD. OFFSET
5197 BA17 09 40 00              ora   #$40                     ; SET FLAGS INTO CMD
5198 BA1A 48                    pha                            ;  TEMP.
5199 BA1B B7 0D                 lda   [PREV],Y                 ; GET PREVIOUS
5200 BA1D 29 00 FF              and   #$FF00                   ; DATA ONLY
5201 BA20 97 0D                 sta   [PREV],Y
5202 BA22 68                    pla   
5203 BA23 17 0D                 ora   [PREV],Y                 ; WITH NEW COUNT & DATA
5204 BA25 97 0D                 sta   [PREV],Y                 ; SAVE IT
5205 BA27 8A           BMPF     txa                            ; GET COUNT
5206 BA28 18                    clc   
5207 BA29 65 01                 adc   FROM
5208 BA2B 85 01                 sta   FROM                     ;BUMP FROM BY X (AMT.)
5209 BA2D A5 03                 lda   FROM+2
5210 BA2F 69 00 00              adc   #0
5211 BA32 85 03                 sta   FROM+2
5212 BA34 DA                    phx   
5213 BA35 A5 11                 lda   COUNT
5214 BA37 38                    sec   
5215 BA38 E3 01                 sbc   1,S
5216 BA3A FA                    plx   
5217 BA3B 85 11                 sta   COUNT
5218 BA3D C9 00 00              cmp   #0
5219 BA40 D0 03                 bne   MORCHK
5220 BA42 4C E8 BA              jmp   ALLDONE
5221 BA45 A5 07        MORCHK   lda   TO+2                     ; CHECK IF PAST END OF BUFFER
5222 BA47 C5 0B                 cmp   ENDBUF+2
5223 BA49 D0 09                 bne   NOTDON
5224 BA4B A5 05                 lda   TO
5225 BA4D C5 09                 cmp   ENDBUF
5226 BA4F 90 03                 blt   NOTDON
5227 BA51 4C E8 BA              jmp   ALLDONE
5228 BA54 A0 00 00     NOTDON   ldy   #0                       ; BE SURE Y=0 WHEN WE GO BACK
5229 BA57 4C 3B B9              jmp   MAINLOOP                 ; ALL DONE, BACK TO MAIN LOOP
5230 BA5A
5231 BA5A
5232 BA5A E0 03 00     DIFF     cpx   #3                       ;IF 1 OR 2, JUST ADD
5233 BA5D 90 36                 blt   DO12
5234 BA5F F0 05                 beq   DO3                      ; IF 3, GO SET UP IT'S COMMAND
5235 BA61 A9 C0 00              lda   #$C0                     ; FOR 4, SET IT'S COMMAND
5236 BA64 80 03                 bra   JDO
5237 BA66 A9 42 00     DO3      lda   #$42
5238 BA69 48           JDO      pha                            ; SAVE IT
5239 BA6A B7 01                 lda   [FROM],Y                 ; GET THE CHAR.
5240 BA6C 29 FF 00              and   #$FF                     ; -JUST THE CHAR
5241 BA6F EB                    xba   
5242 BA70 97 05                 sta   [TO],Y
5243 BA72 68                    pla   
5244 BA73 17 05                 ora   [TO],Y                   ; NOW HAVE CMD & COUNT
5245 BA75 97 05                 sta   [TO],Y
5246 BA77 9B                    txy                            ;FOLLOWING IS TO GET LF RIGHT
5247 BA78 88                    dey   
5248 BA79 B7 01                 lda   [FROM],Y
5249 BA7B 85 13                 sta   LF
5250 BA7D A0 00 00              ldy   #0                       ;RESET Y
5251 BA80 A5 05        BMPT2    lda   TO                       ; TO:=TO+2;
5252 BA82 85 0D                 sta   PREV
5253 BA84 18                    clc   
5254 BA85 69 02 00              adc   #2
5255 BA88 85 05                 sta   TO
5256 BA8A A5 07                 lda   TO+2
5257 BA8C 85 0F                 sta   PREV+2
5258 BA8E 69 00 00              adc   #0
5259 BA91 85 07                 sta   TO+2
5260 BA93 80 92                 bra   BMPF
5261 BA95 A5 0F        DO12     lda   PREV+2                   ; CHECK FOR A PREV
5262 BA97 C9 FF FF              cmp   #$FFFF
5263 BA9A F0 3D                 beq   NEW1
5264 BA9C B7 0D                 lda   [PREV],Y                 ; CHECK PREV CMD.
5265 BA9E 29 C0 00              and   #$C0                     ; IF WAS ADD 1 CHAR, JUST ADD 1 OR 2 IN
5266 BAA1 C9 00 00              cmp   #00
5267 BAA4 D0 33                 bne   NEW1                     ; NO, GO DO NEW 1 OR 2
5268 BAA6 B7 0D                 lda   [PREV],Y                 ; CHECK IF>MAX- MAKE NEW 1 OR 2 IF SO
5269 BAA8 29 FF 00              and   #$FF
5270 BAAB C9 3F 00              cmp   #$3F
5271 BAAE F0 29                 beq   NEW1
5272 BAB0 E0 02 00              cpx   #2                       ; IF 2, & AT $3E JUST ADD 1
5273 BAB3 D0 08                 bne   OKADDIN
5274 BAB5 C9 3E 00              cmp   #$3E
5275 BAB8 D0 03                 bne   OKADDIN
5276 BABA A2 01 00              ldx   #1                       ; JUST 1, GET NEXT ONE NEXT TIME AROUND
5277 BABD 8A           OKADDIN  txa                            ; YES, ADD IN 1 OR 2
5278 BABE 18                    clc   
5279 BABF 77 0D                 adc   [PREV],Y                 ; YES, ADD 1 OR 2 IN
5280 BAC1 97 0D                 sta   [PREV],Y
5281 BAC3 B7 01                 lda   [FROM],Y
5282 BAC5 85 13                 sta   LF
5283 BAC7 97 05                 sta   [TO],Y
5284 BAC9 8A                    txa   
5285 BACA 18                    clc   
5286 BACB 65 05                 adc   TO
5287 BACD 85 05                 sta   TO
5288 BACF A5 07                 lda   TO+2
5289 BAD1 69 00 00              adc   #0
5290 BAD4 85 07                 sta   TO+2
5291 BAD6 4C 27 BA              jmp   BMPF                     ; GO BUMP FROM
5292 BAD9 B7 01        NEW1     lda   [FROM],Y                 ; GET THE DATA
5293 BADB 85 13                 sta   LF
5294 BADD 29 FF 00              and   #$FF                     ; JUST 1 CHAR
5295 BAE0 EB                    xba   
5296 BAE1 97 05                 sta   [TO],Y
5297 BAE3 A2 01 00              ldx   #1                       ; DO ONLY ONE, IF 2 GET IT NEXT TIME
5298 BAE6 80 98                 bra   BMPT2                    ; GO ADJUST POINTERS
5299 BAE8
5300 BAE8 A5 05        ALLDONE  lda   TO
5301 BAEA 38                    sec   
5302 BAEB E5 1F                 sbc   BUFPTR
5303 BAED 85 2B                 sta   RESULT                   ; SET RESULT LENGTH
5304 BAEF
5305 BAEF A5 01                 lda   FROM
5306 BAF1 38                    sec   
5307 BAF2 E7 27                 sbc   [PICPTRP]
5308 BAF4 48                    pha                            ; HOLD IT, NEED SIZE - IT
5309 BAF5 A7 23                 lda   [PICSIZEP]
5310 BAF7 38                    sec   
5311 BAF8 E3 01                 sbc   1,S
5312 BAFA 87 23                 sta   [PICSIZEP]
5313 BAFC 68                    pla   
5314 BAFD
5315 BAFD A5 01                 lda   FROM
5316 BAFF 87 27                 sta   [PICPTRP]
5317 BB01 A5 03                 lda   FROM+2
5318 BB03 A0 02 00              ldy   #2
5319 BB06 97 27                 sta   [PICPTRP],Y
5320 BB08
5321 BB08 A5 15                 lda   ORIGDRCT
5322 BB0A 5B                    tcd   
5323 BB0B A3 17                 lda   RTL1,S                   ;FIX STACK UP CORRECTLY
5324 BB0D 83 25                 sta   RESULT-6,S
5325 BB0F A3 19                 lda   RTL1+2,S
5326 BB11 83 27                 sta   RESULT-4,S
5327 BB13 A3 1B                 lda   RTL1+4,S
5328 BB15 83 29                 sta   RESULT-2,S
5329 BB17 3B                    tsc   
5330 BB18 18                    clc   
5331 BB19 69 24 00              adc   #RESULT-7
5332 BB1C 1B                    tcs   
5333 BB1D A9 00 00              lda   #0                       ; fix by SEG on 5 March 87
5334 BB20 18                    clc                            ; fix by SEG on 5 March 87
5335 BB21 6B                    rtl   
5336 BB22                       ENDP 
5337 BB22
5338 BB22
5339 BB22
5340 BB22
5341 BB22              ************************************************************************
5342 BB22              * Support routines called by packbits                                  *
5343 BB22              ************************************************************************
5344 BB22
5345 BB22              *****************************************
5346 BB22              *                                       *
5347 BB22              * Lookat4: looks at 4 bytes at [FROM],Y *
5348 BB22              *          and returns in X :           *
5349 BB22              *                                       *
5350 BB22              *       X=4 => XXXX (i.e 4 same bytes)  *
5351 BB22              *       X=3 => XXX-                     *
5352 BB22              *       X=2 => XX--                     *
5353 BB22              *       x=1 => x---                     *
5354 BB22              *                                       *
5355 BB22              * RETURN ALSO: CONDITION = IF X=4       *
5356 BB22              *              CONDITION <> IF NOT      *
5357 BB22              *                                       *
5358 BB22              *****************************************
5359 BB22
5360 BB22              Lookat4  PROC 
5361 BB22
5362 BB22              from     equ   1
5363 BB22              to       equ   from+4
5364 BB22              endbuf   equ   to+4
5365 BB22              prev     equ   endbuf+4
5366 BB22              count    equ   prev+4
5367 BB22              lf       equ   count+2
5368 BB22
5369 BB22 A2 01 00              ldx   #1                       ; INIT X TO DEFAULT NO MATCHES
5370 BB25 B7 01                 lda   [FROM],Y                 ; GET TWO BYTES TO COMPARE
5371 BB27 EB                    xba                            ; SWITCH FOR COMPARE
5372 BB28 D7 01                 cmp   [FROM],Y
5373 BB2A D0 10                 bne   LDONE                    ; NOT =, RETURN (X=1)
5374 BB2C E8                    inx   
5375 BB2D C8                    iny                            ; CHECK FOR 2ND AND 3RD MATCHING
5376 BB2E D7 01                 cmp   [FROM],Y
5377 BB30 D0 0A                 bne   LDONE                    ; NOT =, RETURN (X=2)
5378 BB32 E8                    inx   
5379 BB33 C8                    iny   
5380 BB34 D7 01                 cmp   [FROM],Y
5381 BB36 D0 04                 bne   LDONE                    ; NOT =, RETURN (X=3)
5382 BB38 E8                    inx                            ; ELSE, X=4 ALL 4 MATCH
5383 BB39 E0 04 00              cpx   #4                       ; (JUST TO SET COND. TO =)
5384 BB3C 60           LDONE    rts   
5385 BB3D                       ENDP 
5386 BB3D
5387 BB3D              *****************************************
5388 BB3D              *                                       *
5389 BB3D              * ISIT44 - Checks for two consecutive   *
5390 BB3D              *   sets of 4 matching bytes.           *
5391 BB3D              *   Returns Carry Set for no match and  *
5392 BB3D              *   Carry Clear for match.              *
5393 BB3D              *   NOTE: X register is not changed.    *
5394 BB3D              *                                       *
5395 BB3D              *****************************************
5396 BB3D
5397 BB3D              ISIT44   PROC 
5398 BB3D
5399 BB3D              from     equ   1
5400 BB3D              to       equ   from+4
5401 BB3D              endbuf   equ   to+4
5402 BB3D              prev     equ   endbuf+4
5403 BB3D              count    equ   prev+4
5404 BB3D              lf       equ   count+2
5405 BB3D
5406 BB3D 5A                    phy                            ;MUST PRESERVE
5407 BB3E B7 01                 lda   [FROM],Y                 ;1ST 2 BYTES OF FIRST 4
5408 BB40 C8                    iny                            ;BUMP BY 4
5409 BB41 C8                    iny   
5410 BB42 C8                    iny                            ;NOTE: CHECK IF PAST END ONLY IF WE
5411 BB43 C8                    iny                            ;      GET THE MATCH, ELSE, WHO CARES
5412 BB44 D7 01                 cmp   [FROM],Y                 ; 1ST 2 BYES OF NEXT 4
5413 BB46 D0 17                 bne   NOT44
5414 BB48 88                    dey   
5415 BB49 88                    dey                            ;BACK UP TO 2ND 2 OF 1ST 4
5416 BB4A B7 01                 lda   [FROM],Y
5417 BB4C C8                    iny   
5418 BB4D C8                    iny   
5419 BB4E C8                    iny   
5420 BB4F C8                    iny   
5421 BB50 D7 01                 cmp   [FROM],Y                 ;COMPARE TO 2ND 2 OF 2ND 4
5422 BB52 D0 0B                 bne   NOT44                    ;NOPE, GET OUT
5423 BB54              *
5424 BB54              * HERE, WE GOT THE MATCH, BUT BE SURE 8 BYTES REMAIN SO WE CAN DO IT
5425 BB54              *
5426 BB54 A5 11                 lda   COUNT
5427 BB56 38                    sec   
5428 BB57 E9 08 00              sbc   #8
5429 BB5A 30 03                 bmi   NOT44                    ; LESS THAN 8 , WE CANT COUNT IT
5430 BB5C 7A                    ply                            ; RESTORE Y
5431 BB5D 18                    clc                            ; ALLS WELL, RETURN CLEAR CARRY
5432 BB5E 60                    rts   
5433 BB5F 7A           NOT44    ply   
5434 BB60 38                    sec                            ; NO MATCH
5435 BB61 60                    rts   
5436 BB62                       ENDP 
5437 BB62
5438 BB62
5439 BB62
5440 BB62              ************************************************************************
5441 BB62              * Main UnPackbits entry                                                *
5442 BB62              ************************************************************************
5443 BB62
5444 BB62              UNPACKBYTES PROC 
5445 BB62
5446 BB62              from     equ   1
5447 BB62              to       equ   from+4
5448 BB62              endbuf   equ   to+4
5449 BB62              temp     equ   endbuf+4
5450 BB62              count    equ   temp+4
5451 BB62              lf       equ   count+2
5452 BB62
5453 BB62              Origdrct equ   lf+2
5454 BB62
5455 BB62              rtl1     equ   origdrct+2
5456 BB62              rtl2     equ   rtl1+3
5457 BB62
5458 BB62              PicSizeP equ   rtl2+3
5459 BB62              PicPtrP  equ   PicSizeP+4
5460 BB62              Bufsize  equ   PicPtrP+4
5461 BB62              BufPtr   equ   BufSize+2
5462 BB62              Result   equ   BufPtr+4
5463 BB62              ;                     -> +2
5464 BB62
5465 BB62 0B                    phd                            ; SET UP STACK AS ZERO PAGE +PARMS
5466 BB63 3B                    tsc   
5467 BB64 38                    sec   
5468 BB65 E9 14 00              sbc   #ORIGDRCT-1
5469 BB68 1B                    tcs   
5470 BB69 5B                    tcd   
5471 BB6A
5472 BB6A A7 21                 lda   [PICPTRP]                ; GET THE ARGS.
5473 BB6C AA                    tax                            ; (PICPTRP NEEDS DE-REFERANCE)
5474 BB6D A0 02 00              ldy   #2
5475 BB70 B7 21                 lda   [PICPTRP],Y
5476 BB72 85 07                 sta   TO+2
5477 BB74 86 05                 stx   TO
5478 BB76
5479 BB76 A7 1D                 lda   [PICSIZEP]
5480 BB78 85 11                 sta   COUNT
5481 BB7A
5482 BB7A A5 27                 lda   BUFPTR
5483 BB7C 85 01                 sta   FROM
5484 BB7E 18                    clc   
5485 BB7F 65 25                 adc   BUFSIZE
5486 BB81 85 09                 sta   ENDBUF
5487 BB83 A5 29                 lda   BUFPTR+2
5488 BB85 85 03                 sta   FROM+2
5489 BB87 69 00 00              adc   #0
5490 BB8A 85 0B                 sta   ENDBUF+2
5491 BB8C
5492 BB8C A0 00 00     DOUNPACK ldy   #0
5493 BB8F
5494 BB8F B7 01                 lda   [FROM],Y                 ; GET THE COMMAND
5495 BB91 85 0D                 sta   TEMP
5496 BB93 29 3F 00              and   #$3F
5497 BB96 AA                    tax                            ; GET COUNT ONLY INTO X
5498 BB97 E6 01                 inc   FROM                     ; BUMP TO FIRST BYTE TO TRANSFER
5499 BB99 D0 02                 bne   M1
5500 BB9B E6 03                 inc   FROM+2
5501 BB9D 24 0C        M1       bit   TEMP-1                   ; V & C BITS GIVE COMMAND
5502 BB9F 30 04                 bmi   REP4
5503 BBA1 70 0D                 bvs   REP1                     ; 01xxxxxx -> REPEAT NEXT 1 BYTE
5504 BBA3 80 08                 bra   DIFF                     ; 00xxxxxx -> ALL DIFFERENT
5505 BBA5 70 16        REP4     bvs   REP41                    ; 11xxxxxx -> REPEAT 4 OF NEXT 1 BYTE
5506 BBA7 80 1C                 bra   REP44                    ; 10xxxxxx -> REPEAT OF NEXT 4 BYTES
5507 BBA9
5508 BBA9 68           OUTP     pla   
5509 BBAA 4C 8B BC              jmp   UDONE                    ; GO FINISH UP
5510 BBAD
5511 BBAD              *****************************************
5512 BBAD              *                                       *
5513 BBAD              * DIFF : 0 ->63 IN A MEANS  1->64       *
5514 BBAD              *   DIFFERENT BYTES FOLLOW TO BE MOVED  *
5515 BBAD              *                                       *
5516 BBAD              *****************************************
5517 BBAD 48           DIFF     pha                            ; WHEN WE GO TO COMMON CODE, WE NEED
5518 BBAE              ;                                         SOMETHING STACKED (OTHER CALLS USE IT)
5519 BBAE 80 1B                 bra   JOIN
5520 BBB0
5521 BBB0              *****************************************
5522 BBB0              *                                       *
5523 BBB0              * REP1 : 1,2,3,5,6,7 REPEATS OF FOLLOW- *
5524 BBB0              *        ING BYTE.                      *
5525 BBB0              *                                       *
5526 BBB0              *****************************************
5527 BBB0
5528 BBB0
5529 BBB0 A5 0D        REP1     lda   TEMP                     ; PUT BYTE IF LOW & HIGH & ON STACK
5530 BBB2 29 00 FF              and   #$FF00
5531 BBB5 48                    pha   
5532 BBB6 EB                    xba   
5533 BBB7 03 01                 ora   1,S
5534 BBB9 83 01                 sta   1,S
5535 BBBB 80 0E                 bra   JOIN                     ; JOIN UP, X=LEN IS CORRECT STILL
5536 BBBD
5537 BBBD              *****************************************
5538 BBBD              *                                       *
5539 BBBD              * REP41 : IS SAME AS REP1 ABOVE, EXCEPT *
5540 BBBD              *         COUNT IN X MUST BE 4 TIMES >  *
5541 BBBD              *                                       *
5542 BBBD              *****************************************
5543 BBBD E8           REP41    inx   
5544 BBBE 8A                    txa   
5545 BBBF 0A                    asl   a
5546 BBC0 0A                    asl   a
5547 BBC1 AA                    tax   
5548 BBC2 CA                    dex   
5549 BBC3 80 EB                 bra   REP1
5550 BBC5
5551 BBC5              *****************************************
5552 BBC5              *                                       *
5553 BBC5              * REP44 : MUST SET UP FOR 2 STORES I.E. *
5554 BBC5              *         4 BYTES WORTH, AND COUNT IS   *
5555 BBC5              *         DOUBLED (2 STORES EACH TIME)  *
5556 BBC5              *                                       *
5557 BBC5              *****************************************
5558 BBC5 E8           REP44    inx   
5559 BBC6 8A                    txa   
5560 BBC7 0A                    asl   a
5561 BBC8 AA                    tax                            ; FIRST DOUBLE X
5562 BBC9 CA                    dex   
5563 BBCA 48                    pha                            ; MUST PUT SOMETHING ON STACK FOR
5564 BBCB              ;                                         OTHER CASES
5565 BBCB
5566 BBCB              *	bra	JOIN		; WE FIND 4 BYTES AT [FROM],
5567 BBCB              * (FALL THROUGH TO JOIN)	; SO MUST REMEMBER TO FIND IT THERE
5568 BBCB
5569 BBCB              *****************************************
5570 BBCB              *                                       *
5571 BBCB              * JOIN : HERE, THE LOAD STORE SEQUENCE  *
5572 BBCB              *        OF DATA TRANSFER TAKES PLACE   *
5573 BBCB              *                                       *
5574 BBCB              *****************************************
5575 BBCB E4 11        JOIN     cpx   COUNT                    ; BE SURE THERE'S ROOM
5576 BBCD B0 DA                 bge   OUTP                     ; NO - DONE   (BUT PULL OFF EXTRA PUSH)
5577 BBCF
5578 BBCF A9 01 00              lda   #1                       ; CHECK IF LENGTH WOULD GO OVER
5579 BBD2 24 0C                 bit   TEMP-1                   ; DEPENDS ON TYPE OF CMD.
5580 BBD4 70 09                 bvs   L1                       ; LEN=1 FOR %01 & %11
5581 BBD6 30 04                 bmi   L4                       ; LEN=4 FOR %10
5582 BBD8 8A                    txa   
5583 BBD9 1A                    inc   a                        ; LEN=N+1 FOR %00..N...
5584 BBDA 80 03                 bra   L1
5585 BBDC A9 04 00     L4       lda   #4
5586 BBDF 18           L1       clc                            ; FROM+LEN .LT. ENDBUF MEANS NOT DONE
5587 BBE0 65 01                 adc   FROM
5588 BBE2 48                    pha                            ; SAVE FOR COMPARE
5589 BBE3 A5 03                 lda   FROM+2
5590 BBE5 69 00 00              adc   #0
5591 BBE8 C5 0B                 cmp   ENDBUF+2
5592 BBEA 90 09                 bcc   NOTDONP
5593 BBEC 68                    pla   
5594 BBED C5 09                 cmp   ENDBUF
5595 BBEF 90 05                 blt   NOTDON
5596 BBF1 F0 03                 beq   NOTDON
5597 BBF3 80 B4                 bra   OUTP
5598 BBF5 68           NOTDONP  pla   
5599 BBF6
5600 BBF6 E0 00 00     NOTDON   cpx   #0                       ; (NEEDED FOR 1ST ENTRY IN LOOP)
5601 BBF9 30 51        LOOP     bmi   DOUPD                    ; YES
5602 BBFB
5603 BBFB
5604 BBFB              *****************************************
5605 BBFB              *                                       *
5606 BBFB              * MOVEIT : USED LOCALLY TO FETCH PROPER *
5607 BBFB              *          INPUT, DEPENDING ON TYPE OF  *
5608 BBFB              *          CMD. BEING PROCESSED         *
5609 BBFB              *  NOTE: X<0 MEANS STORE 1 BYTE ONLY    *
5610 BBFB              *****************************************
5611 BBFB 24 0C                 bit   TEMP-1                   ; THIS HAS THE FLAGS
5612 BBFD 30 36                 bmi   MREP4
5613 BBFF 70 1A                 bvs   MREP1
5614 BC01 E0 00 00              cpx   #0                       ; IF NEG. IT'S ONE BYTE ONLY
5615 BC04 F0 09                 beq   MSPEC
5616 BC06 B7 01                 lda   [FROM],Y
5617 BC08 97 05                 sta   [TO],Y
5618 BC0A C8                    iny   
5619 BC0B C8                    iny   
5620 BC0C 4C 48 BC              jmp   NDMOV
5621 BC0F E2 20        MSPEC    sep   #%00100000
5622 BC11 B7 01                 lda   [FROM],Y
5623 BC13 97 05                 sta   [TO],Y
5624 BC15 C2 20                 rep   #%00100000
5625 BC17 C8                    iny   
5626 BC18 4C 48 BC              jmp   NDMOV
5627 BC1B E0 00 00     MREP1    cpx   #0
5628 BC1E F0 09                 beq   M2SPEC
5629 BC20 A3 01                 lda   1,S
5630 BC22 97 05                 sta   [TO],Y
5631 BC24 C8                    iny   
5632 BC25 C8                    iny   
5633 BC26 4C 48 BC              jmp   NDMOV
5634 BC29 E2 20        M2SPEC   sep   #%00100000
5635 BC2B A3 01                 lda   1,S
5636 BC2D 97 05                 sta   [TO],Y
5637 BC2F C2 20                 rep   #%00100000
5638 BC31 C8                    iny   
5639 BC32 4C 48 BC              jmp   NDMOV
5640 BC35 70 E4        MREP4    bvs   MREP1                    ;REP41 SAME AS REP1 BUT LARGER COUNT
5641 BC37 A7 01                 lda   [FROM]
5642 BC39 97 05                 sta   [TO],Y
5643 BC3B 5A                    phy                            ; HOLD Y A SEC
5644 BC3C A0 02 00              ldy   #2
5645 BC3F B7 01                 lda   [FROM],Y
5646 BC41 7A                    ply   
5647 BC42 C8                    iny   
5648 BC43 C8                    iny   
5649 BC44 97 05                 sta   [TO],Y
5650 BC46 C8                    iny   
5651 BC47 C8                    iny   
5652 BC48              ******
5653 BC48 CA           NDMOV    dex   
5654 BC49 CA                    dex   
5655 BC4A 80 AD                 bra   LOOP                     ; GO DO NEXT ONES
5656 BC4C 68           DOUPD    pla                            ; GET RID OF EXTRA PUSH
5657 BC4D A5 0D                 lda   TEMP                     ; UPDATE APPROPRIATE POINTERS
5658 BC4F 29 3F 00              and   #$3F
5659 BC52 1A                    inc   a
5660 BC53 24 0C                 bit   TEMP-1
5661 BC55 30 13                 bmi   XREP4                    ; FROM DEPENDS ON TYPE
5662 BC57 50 03                 bvc   XDIFF                    ; FOR 00xxxxxx ADD LENGTH
5663 BC59 A9 01 00     FP1      lda   #1                       ; FOR 01xxxxxx ADD 1
5664 BC5C 18           XDIFF    clc   
5665 BC5D 65 01                 adc   FROM
5666 BC5F 85 01                 sta   FROM
5667 BC61 A5 03                 lda   FROM+2
5668 BC63 69 00 00              adc   #0
5669 BC66 85 03                 sta   FROM+2
5670 BC68 80 07                 bra   DOTO
5671 BC6A 70 ED        XREP4    bvs   FP1                      ; FOR 11xxxxxx ALSO ADD 1
5672 BC6C A9 04 00              lda   #4                       ; FOR 10xxxxxx ADD 4
5673 BC6F 80 EB                 bra   XDIFF
5674 BC71
5675 BC71 98           DOTO     tya                            ; Y IS OUTPUT COUNT
5676 BC72 18                    clc   
5677 BC73 65 05                 adc   TO
5678 BC75 85 05                 sta   TO
5679 BC77 A5 07                 lda   TO+2
5680 BC79 69 00 00              adc   #0
5681 BC7C 85 07                 sta   TO+2
5682 BC7E 98                    tya   
5683 BC7F 85 0D                 sta   TEMP
5684 BC81 A5 11                 lda   COUNT
5685 BC83 38                    sec   
5686 BC84 E5 0D                 sbc   TEMP
5687 BC86 85 11                 sta   COUNT
5688 BC88 4C 8C BB              jmp   DOUNPACK
5689 BC8B
5690 BC8B A5 01        UDONE    lda   FROM
5691 BC8D 38                    sec   
5692 BC8E E5 27                 sbc   BUFPTR
5693 BC90 3A                    dec   a
5694 BC91 85 2B                 sta   RESULT                   ; SET RESULT LENGTH
5695 BC93
5696 BC93 A5 05                 lda   TO
5697 BC95 38                    sec   
5698 BC96 E7 21                 sbc   [PICPTRP]
5699 BC98 48                    pha                            ; HOLD IT, NEED SIZE - IT
5700 BC99 A7 1D                 lda   [PICSIZEP]
5701 BC9B 38                    sec   
5702 BC9C E3 01                 sbc   1,S
5703 BC9E 87 1D                 sta   [PICSIZEP]
5704 BCA0 68                    pla   
5705 BCA1
5706 BCA1 A5 05                 lda   TO
5707 BCA3 87 21                 sta   [PICPTRP]
5708 BCA5 A5 07                 lda   TO+2
5709 BCA7 A0 02 00              ldy   #2
5710 BCAA 97 21                 sta   [PICPTRP],Y
5711 BCAC
5712 BCAC A5 15                 lda   ORIGDRCT
5713 BCAE 5B                    tcd   
5714 BCAF A3 17                 lda   RTL1,S                   ;FIX STACK UP CORRECTLY
5715 BCB1 83 25                 sta   RESULT-6,S
5716 BCB3 A3 19                 lda   RTL1+2,S
5717 BCB5 83 27                 sta   RESULT-4,S
5718 BCB7 A3 1B                 lda   RTL1+4,S
5719 BCB9 83 29                 sta   RESULT-2,S
5720 BCBB 3B                    tsc   
5721 BCBC 18                    clc   
5722 BCBD 69 24 00              adc   #RESULT-7
5723 BCC0 1B                    tcs   
5724 BCC1 A9 00 00              lda   #0                       ; fix by SEG 5 March 87
5725 BCC4 18                    clc                            ; fix by SEG 5 March 87
5726 BCC5 6B                    RTL   
5727 BCC6                       ENDP 
5728 BCC6
5729 BCC6
5730 BCC6
5731 BCC6
5732 BCC6                       title 'Munger'
5733 BCC6              ************************************************************************
5734 BCC6              *                                                                      *
5735 BCC6              *  FUNCTION Munger  (VAR DestPtr : POINTER;                            *
5736 BCC6              *  VAR DestLen : INTEGER;                                              *
5737 BCC6              *      TargPtr : POINTER;                                              *
5738 BCC6              *      TargLen : INTEGER;                                              *
5739 BCC6              *      ReplPtr : POINTER;                                              *
5740 BCC6              *      ReplLen : INTEGER;                                              *
5741 BCC6              *  VAR Pad     : INTEGER) : INTEGER;                                   *
5742 BCC6              *                                                                      *
5743 BCC6              *  Params: DestPtr - Pointer to text to be manipulated                 *
5744 BCC6              *          DestLen - Number of bytes to be included in manipulation    *
5745 BCC6              *          TargPtr - String to be searched for in above text           *
5746 BCC6              *          TargLen - its length                                        *
5747 BCC6              *          ReplPtr - string to replace with when target string found   *
5748 BCC6              *          ReplLen - its length                                        *
5749 BCC6              *          Pad     - <on entry> : character to pad with stored as int. *
5750 BCC6              *          Pad     - <returned value> : pad amount                     *
5751 BCC6              *                                                                      *
5752 BCC6              *  Returns: Munger returns a negative value if target not found        *
5753 BCC6              *                                                                      *
5754 BCC6              *           Pad returns the net effect of the replacement. If data is  *
5755 BCC6              *           truncated, a negative value, and if blanks are padded in   *
5756 BCC6              *           at the end, a positive value count                         *
5757 BCC6              *                                                                      *
5758 BCC6              *           DestPtr is updated to one past the replacement             *
5759 BCC6              *           DestLen is reduced by amount of data passed over           *
5760 BCC6              *                                                                      *
5761 BCC6              *                                                                      *
5762 BCC6              *  Special considerations:                                             *
5763 BCC6              *                                                                      *
5764 BCC6              *        - If TargPtr is 0, the substring of length TargLen is         *
5765 BCC6              *          replaced by ReplPtr's string                                *
5766 BCC6              *                                                                      *
5767 BCC6              *        - If TargLen is 0, ReplPtr's string is inserted at DestPtr    *
5768 BCC6              *                                                                      *
5769 BCC6              *        - If ReplPtr is 0, DestPtr is updated to past the end of the  *
5770 BCC6              *          TargPtr's string                                            *
5771 BCC6              *                                                                      *
5772 BCC6              *        - If ReplLen is 0, (and ReplPtr is NOT 0) TargPtr's string is *
5773 BCC6              *          deleted rather than replaced (since the replacement string  *
5774 BCC6              *          is empty)                                                   *
5775 BCC6              *                                                                      *
5776 BCC6              *        There is one case in which munger performs a replacement even *
5777 BCC6              *        if it doesn't find all of the target string. If DestPtr's     *
5778 BCC6              *        entire string is at the begining of TargPtr's string, then    *
5779 BCC6              *        the entire DestPtr string is replaced with ReplPtr's string   *
5780 BCC6              *                                                                      *
5781 BCC6              *        ------------------------------------------------------        *
5782 BCC6              *                                                                      *
5783 BCC6              *  Sample Calls:                                                       *
5784 BCC6              *                                                                      *
5785 BCC6              *        {***}                                                         *
5786 BCC6              *                                                                      *
5787 BCC6              *                                                                      *
5788 BCC6              *     -----------------------------------------------------------      *
5789 BCC6              *                                                                      *
5790 BCC6              *                                                                      *
5791 BCC6              *  Written By: Eagle I. Berns                                          *
5792 BCC6              *                                                                      *
5793 BCC6              *  Modification History:                                               *
5794 BCC6              *                                                                      *
5795 BCC6              *  01-JAN-86   EIB  First coding begun                                 *
5796 BCC6              *  01-AUG-86   EIB  fixed targptr=0 bug                                *
5797 BCC6              *  02-AUG-86   EIB  fixed delete (repllen=0)                           *
5798 BCC6              *  05-Mar-87   EIB  fixed one byte compare problem for targe string of *
5799 BCC6              *  length one.                                                         *
5800 BCC6              *              SEG  Routine now clears carry and puts zero in A-reg    *
5801 BCC6              *  on exit                                                             *
5802 BCC6              *                                                                      *
5803 BCC6              ************************************************************************
5804 BCC6
5805 BCC6
5806 BCC6              ************************************************************************
5807 BCC6              * Main munger entry                                                    *
5808 BCC6              ************************************************************************
5809 BCC6              MUNGER   PROC 
5810 BCC6
5811 BCC6              search   equ   1
5812 BCC6              find     equ   search+4
5813 BCC6              destptr  equ   find+4
5814 BCC6              destlen  equ   destptr+4
5815 BCC6              temp     equ   destlen+2
5816 BCC6              padchar  equ   temp+4
5817 BCC6              Origdrct equ   padchar+2
5818 BCC6
5819 BCC6              rtl1     equ   origdrct+2
5820 BCC6              rtl2     equ   rtl1+3
5821 BCC6
5822 BCC6              padP     equ   rtl2+3
5823 BCC6              repllen  equ   padP+4
5824 BCC6              replptr  equ   repllen+2
5825 BCC6              targlen  equ   replptr+4
5826 BCC6              targptr  equ   targlen+2
5827 BCC6              destlenP equ   targptr+4
5828 BCC6              destptrP equ   destlenP+4
5829 BCC6              result   equ   destptrP+4
5830 BCC6              ;                     -> +2
5831 BCC6
5832 BCC6 0B                    phd                            ; SET UP STACK AS ZERO PAGE +PARMS
5833 BCC7 3B                    tsc   
5834 BCC8 38                    sec   
5835 BCC9 E9 14 00              sbc   #ORIGDRCT-1
5836 BCCC 1B                    tcs   
5837 BCCD 5B                    tcd   
5838 BCCE
5839 BCCE A7 31                 lda   [DESTPTRP]               ; GET THE ARGS.
5840 BCD0 85 09                 sta   DESTPTR
5841 BCD2 85 01                 sta   SEARCH
5842 BCD4 A0 02 00              ldy   #2
5843 BCD7 B7 31                 lda   [DESTPTRP],Y
5844 BCD9 85 0B                 sta   DESTPTR+2
5845 BCDB 85 03                 sta   SEARCH+2
5846 BCDD
5847 BCDD A7 2D                 lda   [DESTLENP]
5848 BCDF 85 0D                 sta   DESTLEN
5849 BCE1 C5 21                 cmp   REPLLEN                  ; IF REPLLEN >, SHORTEN IT
5850 BCE3 B0 02                 bge   MLBZ
5851 BCE5 85 21                 sta   REPLLEN
5852 BCE7 C5 27        MLBZ     cmp   TARGLEN                  ; TARGLEN ALSO      
5853 BCE9 B0 02                 bge   MLB0
5854 BCEB 85 27                 sta   TARGLEN
5855 BCED
5856 BCED A7 1D        MLB0     lda   [PADP]
5857 BCEF 85 13                 sta   PADCHAR
5858 BCF1
5859 BCF1 A5 29                 lda   TARGPTR                  ; SAVE LOCAL TARGET PTR.,CHECK FOR ZERO
5860 BCF3 85 05                 sta   FIND
5861 BCF5 AA                    tax   
5862 BCF6 A5 2B                 lda   TARGPTR+2
5863 BCF8 85 07                 sta   FIND+2                   ; IF ZERO - SPECIAL CASE - INSERT
5864 BCFA D0 07                 bne   MLB1
5865 BCFC E0 00 00              cpx   #0
5866 BCFF D0 02                 bne   MLB1
5867 BD01
5868 BD01              *===> bug fix: next line deleted EIB 1-AUG-86
5869 BD01              *	sta	DESTLEN	; SET TO 0 , DO REPLACE - (INSERT)
5870 BD01
5871 BD01 80 34                 bra   MUNGREP                  ; (ARGS ARE 'SEARCH' AND 'DESTLEN')
5872 BD03 A5 0D        MLB1     lda   DESTLEN                  ; DESTLEN<=TARGLEN SPECIAL - CHECK @ CHAR 1
5873 BD05 38                    sec   
5874 BD06 E5 27                 sbc   TARGLEN
5875 BD08 F0 05                 beq   MLB2
5876 BD0A 90 03                 blt   MLB2
5877 BD0C 4C 24 BD              jmp   MUNGGNRL
5878 BD0F A5 0D        MLB2     lda   DESTLEN                  ; CALL COMPARE (DESTLEN,SEARCH,FIND)
5879 BD11 85 27                 sta   TARGLEN                  ; FORCE SAME LEN. FOR PTR. ADJ. LATER
5880 BD13 20 7A BE              jsr   MUNGCMPR
5881 BD16 F0 1F                 beq   MUNGREP                  ; MATCH, GO REPL. FULL DEST. STRING
5882 BD18 A9 00 00     MUNGOUT  lda   #0                       ; DONE, RETURN 0 PAD
5883 BD1B 87 1D                 sta   [PADP]
5884 BD1D 85 35                 sta   RESULT
5885 BD1F C6 35                 dec   RESULT                   ; NEGATIVE RESULT
5886 BD21 4C 3B BE              jmp   MUNGXIT
5887 BD24
5888 BD24 AA           MUNGGNRL tax                            ; X HOLDS HOW FAR DOWN 'SEARCH' WE GO
5889 BD25 A5 27        MLB4     lda   TARGLEN                  ; CALL COMPARE (TARGLEN,SEARCH,FIND)
5890 BD27 20 7A BE              jsr   MUNGCMPR
5891 BD2A F0 0B                 beq   MUNGREP                  ; GOT IT, GO DO REPLACE
5892 BD2C E6 01                 inc   SEARCH                   ; NO, MOVE ALONG SEARCH
5893 BD2E D0 02                 bne   MLB5
5894 BD30 E6 03                 inc   SEARCH+2
5895 BD32 CA           MLB5     dex   
5896 BD33 10 F0                 bpl   MLB4                     ; BACK IF WE CAN SEARC MORE
5897 BD35 80 E1                 bra   MUNGOUT                  ; NO MATCH, GO QUIT
5898 BD37
5899 BD37              *****
5900 BD37              *
5901 BD37              * HERE, MOVE destlen CHARS FROM replptr TO search
5902 BD37              * AFTER VERIFYING replptr & repllen & SPECIAL CASES
5903 BD37              *
5904 BD37              ****
5905 BD37
5906 BD37 A5 23        MUNGREP  lda   REPLPTR                  ; SIMPLE CASE - UPDATE destptr
5907 BD39 D0 17                 bne   MLB6                     ;               IF replptr 0
5908 BD3B A5 25                 lda   REPLPTR+2
5909 BD3D D0 13                 bne   MLB6
5910 BD3F
5911 BD3F              *===> bug fix: next 2 lines not needed any longer EIB 1-AUG-86
5912 BD3F              *	lda	[DESTLENP]	; IN CASE WE CHANGED IT BEFORE
5913 BD3F              *	sta	DESTLEN
5914 BD3F
5915 BD3F A5 27                 lda   TARGLEN                  ; IF TARGLEN ALSO 0, MAKE DESTLEN 0
5916 BD41 D0 02                 bne   MUNGRP2
5917 BD43 85 0D                 sta   DESTLEN
5918 BD45 20 55 BE     MUNGRP2  jsr   MUNGPMOV                 ; UPDATE destptr & destlen
5919 BD48
5920 BD48 A9 00 00              lda   #0                       ; ALL DONE - RETURN 0
5921 BD4B 85 35                 sta   RESULT
5922 BD4D 87 1D                 sta   [PADP]                   ; PAD ALSO 0 - NO CHANGE
5923 BD4F 4C 26 BE              jmp   MGD2OUT
5924 BD52 20 55 BE     MLB6     jsr   MUNGPMOV                 ; HAVE REPLPTR - SO ADJUST PTRS FIRST
5925 BD55
5926 BD55              ***
5927 BD55              *
5928 BD55              * MOVE FROM DESTPTR	TO SEARCH+REPLLEN FOR LENGTH DESTLEN
5929 BD55              *   AND ADJUST PAD BY TARGLEN-REPLLEN
5930 BD55              *
5931 BD55              ***
5932 BD55
5933 BD55 A0 02 00              ldy   #2
5934 BD58 A7 31                 lda   [DESTPTRP]               ; COMPUTE TRUE END OF INPUT
5935 BD5A 18                    clc   
5936 BD5B 67 2D                 adc   [DESTLENP]
5937 BD5D 85 05                 sta   FIND                     ; (USE 'FIND' TO HOLD IT IN)
5938 BD5F B7 31                 lda   [DESTPTRP],Y
5939 BD61 69 00 00              adc   #0
5940 BD64 85 07                 sta   FIND+2
5941 BD66
5942 BD66
5943 BD66 A5 0D                 lda   DESTLEN                  ; CHECK IF PAST END and ADJUST
5944 BD68 48                    pha                            ; SAVE FOR LATER
5945 BD69
5946 BD69 A5 27                 lda   TARGLEN
5947 BD6B 38                    sec   
5948 BD6C E5 21                 sbc   REPLLEN
5949 BD6E 87 1D                 sta   [PADP]                   ; THATS PAD AMOUNT, WILL NEED LATER
5950 BD70
5951 BD70 A5 01                 lda   SEARCH
5952 BD72 18                    clc   
5953 BD73 65 21                 adc   REPLLEN
5954 BD75 85 0F                 sta   TEMP
5955 BD77 A5 03                 lda   SEARCH+2
5956 BD79 69 00 00              adc   #0
5957 BD7C 85 11                 sta   TEMP+2                   ; TEMP:=SEARCH+REPLLEN
5958 BD7E C5 07                 cmp   FIND+2                   ; CHECK IF TEMP>FIND (I.E. END OF INPUT)
5959 BD80 B0 0D                 bge   CHKMOR
5960 BD82 A7 1D        DSTGRTR  lda   [PADP]
5961 BD84 10 1C                 bpl   MGD1                     ; POS. SO CAN DO FULL MOVE
5962 BD86 18                    clc   
5963 BD87 65 0D                 adc   DESTLEN                  ; ADD NEG. (SUBT.) FOR CORRECT LEN
5964 BD89 85 0D        DSTGT2   sta   DESTLEN
5965 BD8B 83 01                 sta   1,S
5966 BD8D 80 13                 bra   MGD1
5967 BD8F
5968 BD8F D0 06        CHKMOR   bne   DSTSMLR
5969 BD91 A5 05                 lda   FIND
5970 BD93 C5 0F                 cmp   TEMP
5971 BD95 B0 EB                 bge   DSTGRTR
5972 BD97 A5 05        DSTSMLR  lda   FIND                     ; TOO BIG, ADJ. REPLLEN & REPLACE ONLY
5973 BD99 38                    sec   
5974 BD9A E5 01                 sbc   SEARCH
5975 BD9C 85 21                 sta   REPLLEN
5976 BD9E 68                    pla                            ; DON'T FORGET TO GET RID OF THIS
5977 BD9F 4C 09 BE              jmp   MGDOUT
5978 BDA2
5979 BDA2
5980 BDA2              ************************************************************************
5981 BDA2              *                                                                      *
5982 BDA2              *   MEMORY MANAGER BLOCKMOVE PROCEEDURE WITH SRC = <DESTPTR> ,         *
5983 BDA2              *   DEST = <TEMP> , and LENGTH ON THE STACK (DO THE PULL)              *
5984 BDA2              *                                                                      *
5985 BDA2              ************************************************************************
5986 BDA2
5987 BDA2 FA           MGD1     plx   
5988 BDA3 A5 0B 48 A5           PushLong DESTPTR 
5989 BDA9 A5 11 48 A5           PushLong TEMP 
5990 BDAF F4 00 00              pea   0
5991 BDB2 DA                    phx   
5992 BDB3 A2 02 2B 22           _BlockMove 
5993 BDBA
5994 BDBA
5995 BDBA A5 27        MGDS     lda   TARGLEN                  ; TARGLEN>REPLLEN - MUST PAD
5996 BDBC 38                    sec   
5997 BDBD E5 21                 sbc   REPLLEN                  ; TARGLEN BLANKS FROM DESTPTR+DESTLEN
5998 BDBF F0 48                 beq   MGDOUT
5999 BDC1 90 46                 blt   MGDOUT
6000 BDC3 48                    pha                            ; SAVE FOR COMPUTATION
6001 BDC4 A5 09                 lda   DESTPTR
6002 BDC6 18                    clc   
6003 BDC7 65 0D                 adc   DESTLEN
6004 BDC9 85 0F                 sta   TEMP
6005 BDCB AA                    tax                            ; SRC - FOR RIPPLE MOVE
6006 BDCC A5 0B                 lda   DESTPTR+2
6007 BDCE 69 00 00              adc   #0
6008 BDD1 85 11                 sta   TEMP+2
6009 BDD3 8A                    txa   
6010 BDD4 38                    sec                            ; TEMP:=TEMP-<DIFF. IN COUNT>
6011 BDD5 E3 01                 sbc   1,S
6012 BDD7 85 0F                 sta   TEMP
6013 BDD9 A5 11                 lda   TEMP+2
6014 BDDB E9 00 00              sbc   #0
6015 BDDE 85 11                 sta   TEMP+2
6016 BDE0 A7 0F                 lda   [TEMP]
6017 BDE2 29 00 FF              and   #$FF00                   ; STORE 1 BLANK BYTE
6018 BDE5 05 13                 ora   PADCHAR                  ; OR IN PAD CHARACTER
6019 BDE7 87 0F                 sta   [TEMP]
6020 BDE9 A5 13                 lda   PADCHAR                  ; GET TWO BYE PAD
6021 BDEB EB                    xba   
6022 BDEC 05 13                 ora   PADCHAR
6023 BDEE AA                    tax                            ; HOLD IN X AWHILE
6024 BDEF A3 01                 lda   1,S                      ; WAS COUNT ODD OR EVEN
6025 BDF1 29 01 00              and   #$01
6026 BDF4 F0 0B                 beq   MGD2                     ; EVEN, GO DO IT
6027 BDF6 68                    pla   
6028 BDF7 3A                    dec   a                        ; MAKE EVEN IF WASN'T
6029 BDF8 F0 0F                 beq   MGDOUT                   ; BUT DONE IF WAS 1
6030 BDFA 48                    pha   
6031 BDFB E6 0F                 inc   TEMP                     ; BUMP ADDRESS 1 ALSO
6032 BDFD D0 02                 bne   MGD2
6033 BDFF E6 10                 inc   TEMP+1
6034 BE01 7A           MGD2     ply                            ; Y NOW HAS COUNT OF STORES
6035 BE02 8A                    txa                            ; A NOW HAS PAD TO FILL WITH
6036 BE03 88           MGD3     dey                            ; DO THE TIGHT STORE LOOP
6037 BE04 88                    dey   
6038 BE05 97 0F                 sta   [TEMP],Y
6039 BE07 D0 FA                 bne   MGD3
6040 BE09
6041 BE09
6042 BE09              ****
6043 BE09              *
6044 BE09              * NOW MOVE REPLLEN CHARS. FROM REPLPTR TO SEARCH
6045 BE09              *
6046 BE09              ***
6047 BE09
6048 BE09              * ===> bug fix: PushLongS must be AFTER test below - EIB 2-AUG-86
6049 BE09 A5 21        MGDOUT   lda   REPLLEN                  ;LEN
6050 BE0B F0 19                 beq   MGD2OUT
6051 BE0D A5 25 48 A5           PushLong REPLPTR               ;SRC
6052 BE13 A5 03 48 A5           PushLong SEARCH                ;DEST
6053 BE19 F4 00 00              pea   0
6054 BE1C A5 21                 lda   REPLLEN
6055 BE1E 48                    pha   
6056 BE1F A2 02 2B 22           _BLOCKMOVE 
6057 BE26
6058 BE26 A0 02 00     MGD2OUT  ldy   #2
6059 BE29 A5 01                 lda   SEARCH
6060 BE2B 18                    clc   
6061 BE2C 65 21                 adc   REPLLEN
6062 BE2E 87 31                 sta   [DESTPTRP]
6063 BE30 A5 03                 lda   SEARCH+2
6064 BE32 69 00 00              adc   #0
6065 BE35 97 31                 sta   [DESTPTRP],Y
6066 BE37
6067 BE37 A5 0D                 lda   DESTLEN
6068 BE39 87 2D                 sta   [DESTLENP]
6069 BE3B
6070 BE3B A5 15        MUNGXIT  lda   ORIGDRCT
6071 BE3D 5B                    tcd   
6072 BE3E A3 17                 lda   RTL1,S                   ;FIX STACK UP CORRECTLY
6073 BE40 83 2F                 sta   RESULT-6,S
6074 BE42 A3 19                 lda   RTL1+2,S
6075 BE44 83 31                 sta   RESULT-4,S
6076 BE46 A3 1B                 lda   RTL1+4,S
6077 BE48 83 33                 sta   RESULT-2,S
6078 BE4A 3B                    tsc   
6079 BE4B 18                    clc   
6080 BE4C 69 2E 00              adc   #RESULT-7
6081 BE4F 1B                    tcs   
6082 BE50 A9 00 00              lda   #0                       ; fixed 5 March 87 SEG
6083 BE53 18                    clc                            ; fixed 5 March 87 SEG
6084 BE54 6B                    RTL   
6085 BE55
6086 BE55              *****************************************
6087 BE55              *                                       *
6088 BE55              * MUNGPMOV - UPDATE DESTPTR & DESTLEN   *
6089 BE55              *            BY TARGLEN AMOUNT          *
6090 BE55              *                                       *
6091 BE55              *****************************************
6092 BE55
6093 BE55 A5 01        MUNGPMOV lda   SEARCH                   ; TEMP:=SEARCH+TARGLEN (WHERE TO WIND UP)
6094 BE57 18                    clc   
6095 BE58 65 27                 adc   TARGLEN
6096 BE5A 85 0F                 sta   TEMP
6097 BE5C A5 03                 lda   SEARCH+2
6098 BE5E 69 00 00              adc   #0
6099 BE61 85 11                 sta   TEMP+2
6100 BE63 A5 0F                 lda   TEMP                     ; FIND := TEMP-DESTPTR (DIST. MOVED)
6101 BE65 38                    sec   
6102 BE66 E5 09                 sbc   DESTPTR
6103 BE68 85 05                 sta   FIND
6104 BE6A A5 0D                 lda   DESTLEN                  ; DESTLEN:=DESTLEN-FIND (LEFT TO SCAN)
6105 BE6C 38                    sec   
6106 BE6D E5 05                 sbc   FIND
6107 BE6F 85 0D                 sta   DESTLEN
6108 BE71 A5 0F                 lda   TEMP                     ; DESTPTR:=TEMP (WHERE TO GO NEXT)
6109 BE73 85 09                 sta   DESTPTR
6110 BE75 A5 11                 lda   TEMP+2
6111 BE77 85 0B                 sta   DESTPTR+2
6112 BE79 60                    rts   
6113 BE7A
6114 BE7A              *****************************************
6115 BE7A              *                                       *
6116 BE7A              *  MUNGCMPR - COMPARE REG. A BYTES      *
6117 BE7A              *    @ SEARCH                           *
6118 BE7A              *    & FIND                             *
6119 BE7A              *                                       *
6120 BE7A              *****************************************
6121 BE7A
6122 BE7A A0 00 00     MUNGCMPR ldy   #0                       ; (USUALLY)
6123 BE7D DA                    phx                            ;MUST PRESERVE X REG.
6124 BE7E C9 00 00              cmp   #0                       ; 0 LENGTH ALWAYS =
6125 BE81 D0 05                 bne   MGC1
6126 BE83 A9 00 00              lda   #0                       ; SET FOR RETURN = CONDITION
6127 BE86 80 1A                 bra   MGCOND
6128 BE88 48           MGC1     pha   
6129 BE89 29 01 00              and   #01                      ; ODD OR EVEN COMPARE LENGTH
6130 BE8C F0 22                 beq   MGCLP                    ; IF EVEN, JUST DO COMPARES
6131 BE8E A7 01                 lda   [SEARCH]
6132 BE90 29 FF 00              and   #$FF                     ; ODD, DO FIRST BYTE - THEN EVEN AMT.
6133 BE93 48                    pha   
6134 BE94 A7 05                 lda   [FIND]
6135 BE96 29 FF 00              and   #$FF
6136 BE99 C3 01                 cmp   1,S
6137 BE9B F0 0A                 beq   MGONE
6138 BE9D 68                    pla   
6139 BE9E 68                    pla                            ; GET RID OF PUSH
6140 BE9F A9 01 00     MGCNO    lda   #1
6141 BEA2 FA           MGCOND   plx                            ; RESTORE X
6142 BEA3 C9 00 00              cmp   #0                       ; SET COND. CODE
6143 BEA6 60           MGCOUT   rts   
6144 BEA7
6145 BEA7 68           MGONE    pla                            ; EXTRA
6146 BEA8 68                    pla                            ; GET LENGTH
6147 BEA9 3A                    dec   a                        ; LESS 1 TO MAKE EVEN
6148 BEAA F0 11                 beq   MGCEQU                   ; patch on 5 March 87 by EIB
6149 BEAC 48                    pha                            ; BACK ON
6150 BEAD A0 01 00              ldy   #1                       ; MOVE FORWARD 1
6151 BEB0 FA           MGCLP    plx                            ; GUARENTEED EVEN
6152 BEB1 B7 01        MGCLP1   lda   [SEARCH],Y
6153 BEB3 D7 05                 cmp   [FIND],Y
6154 BEB5 D0 E8                 bne   MGCNO
6155 BEB7 C8                    iny   
6156 BEB8 C8                    iny   
6157 BEB9 CA                    dex   
6158 BEBA CA                    dex   
6159 BEBB D0 F4                 bne   MGCLP1
6160 BEBD A9 00 00     MGCEQU   lda   #0                       ; SET EQUAL RETURN
6161 BEC0 80 E0                 bra   MGCOND                   ; GO QUIT
6162 BEC2                       ENDP 
6163 BEC2
6164 BEC2
6165 BEC2
6166 BEC2
6167 BEC2                       title 'IRQ Stuff'
6168 BEC2              ****************************************************************
6169 BEC2              *
6170 BEC2              * This tool returns the state of hardware interrupt enables
6171 BEC2              * under the control of the miscellaneous tool set.
6172 BEC2              *
6173 BEC2              *        D8-15 Undefined
6174 BEC2              *        D7    1 = Keyboard interrupts enabled
6175 BEC2              *        D6    1 = Vertical blanking interrupts enabled
6176 BEC2              *        D5    1 = Quarter second interrupts enabled
6177 BEC2              *        D4    1 = One second interrupts enabled
6178 BEC2              *        D3    RESERVED
6179 BEC2              *        D2    1 = Front desk bus data interrupts enabled
6180 BEC2              *        D1    1 = Scan line interrupts enabled
6181 BEC2              *        D0    1 = External VGC interrupts enabled
6182 BEC2              *
6183 BEC2              ****************************************************************
6184 BEC2              GetIRQenbl PROC 
6185 BEC2                       longa on
6186 BEC2                       longi on
6187 BEC2
6188 BEC2              OrigDir  equ   1
6189 BEC2              rtl1     equ   OrigDir+2
6190 BEC2              rtl2     equ   rtl1+3
6191 BEC2              irqstate equ   rtl2+3
6192 BEC2
6193 BEC2 0B                    phd                            ; turn stack into zp
6194 BEC3 3B                    tsc   
6195 BEC4 5B                    tcd   
6196 BEC5 64 09                 stz   irqstate                 ; assume no sources enbl
6197 BEC7 E2 20                 sep   #$20                     ; 8 bit 'm'
6198 BEC9                       longa off
6199 BEC9 AF D4 0F E1           lda   >KBDIRQFLAG              ; if KBD interrupts, set flag
6200 BECD 04 09                 tsb   irqstate
6201 BECF              nokbden                                 ; 
6202 BECF AF 41 C0 00           lda   >inten                   ; get mega irq reg
6203 BED3 48                    pha   
6204 BED4 29 08                 and   #%00001000               ; vbl on?
6205 BED6 F0 04                 beq   novblen                  ; set flag bit if on
6206 BED8 A9 40                 lda   #%01000000
6207 BEDA 04 09                 tsb   irqstate
6208 BEDC              novblen                                 ; 
6209 BEDC 68                    pla                            ; get mega irq reg
6210 BEDD 29 10                 and   #%00010000               ; 1/4 sec on?
6211 BEDF 0A                    asl   a                        ; set flag bit if enabled
6212 BEE0 04 09                 tsb   irqstate
6213 BEE2 AF 23 C0 00           lda   >vgcint                  ; get VGC irq reg
6214 BEE6 48                    pha   
6215 BEE7 29 04                 and   #%00000100               ; 1 sec on?
6216 BEE9 0A                    asl   a
6217 BEEA 0A                    asl   a                        ; set flag bit if enabled
6218 BEEB 04 09                 tsb   irqstate
6219 BEED AF 27 C0 00           lda   >kmstatus                ; get KBDu status
6220 BEF1 29 10                 and   #%00010000               ; fdb data irq on?
6221 BEF3 4A                    lsr   a                        ; set flag bit if enabled
6222 BEF4 4A                    lsr   a
6223 BEF5 04 09                 tsb   irqstate
6224 BEF7 68                    pla                            ; get VGC irq reg
6225 BEF8 29 03                 and   #%00000011               ; scan lines or ext on?
6226 BEFA 04 09                 tsb   irqstate                 ; set flag bit if on
6227 BEFC C2 30                 rep   #$30                     ; 16 bit 'm' & 'x'
6228 BEFE                       longa on
6229 BEFE                       longi on
6230 BEFE 4C E0 FB              jmp   EndCall0
6231 BF01
6232 BF01                       ENDP 
6233 BF01
6234 BF01
6235 BF01
6236 BF01                       title 'SysBeep'
6237 BF01              SysBeep  PROC 
6238 BF01              ****************************************************************
6239 BF01              *
6240 BF01              * There are no input parameters to this tool call.
6241 BF01              * No output parameters will be returned on this tool call.
6242 BF01              * This call will dispatch to the Apple// entry point 'BELL1'.
6243 BF01              * The bell routine may be patched out by using the setvector
6244 BF01              * call with a parameter reference number of $001B.  Any routine
6245 BF01              * installed into the bellvector will be called in native mode
6246 BF01              * with 8 bit 'm' and 'x'.
6247 BF01              *
6248 BF01              ****************************************************************
6249 BF01 A2 08 00              ldx   #8                       ; 8 words to push
6250 BF04 A9 DD FB              lda   #$FBDD                   ; BELL1 entry in rom
6251 BF07              here                                    ; 
6252 BF07 48                    pha   
6253 BF08 CA                    dex   
6254 BF09 D0 FC                 bne   here
6255 BF0B A2 03 24 22           _FWEntry 
6256 BF12 68                    pla                            ; clean off stack
6257 BF13 68                    pla   
6258 BF14 68                    pla   
6259 BF15 68                    pla   
6260 BF16 4C DF FB              jmp   oEndcall0                ; return to application
6261 BF19
6262 BF19                       ENDP 
6263 BF19
6264 BF19                       END   
